/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public final class AlgorithmBuilder {
    public static final String RS256 = "RS256";
    public static final String RS384 = "RS384";
    public static final String RS512 = "RS512";
    public static final String ES256 = "ES256";
    public static final String ES256K = "ES256K";
    public static final String ES384 = "ES384";
    public static final String ES512 = "ES512";
    public static final String HS256 = "HS256";
    public static final String HS384 = "HS384";
    public static final String HS512 = "HS512";

    private AlgorithmBuilder() {
    }

    public static Algorithm buildAlgorithm(Jwk jwk) throws JwkException {
        return AlgorithmBuilder.buildAlgorithm(jwk.getAlgorithm(), jwk.getPublicKey());
    }

    public static Algorithm buildAlgorithm(String alg, PublicKey publicKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)alg) ? 1 : 0) != 0, (Object)"A algorithm is required");
        Preconditions.checkArgument((publicKey != null ? 1 : 0) != 0, (Object)"A public key is required");
        switch (alg) {
            case "RS256": {
                return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "ES256": {
                return Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)publicKey), null);
            }
            case "ES256K": {
                return Algorithm.ECDSA256K((ECPublicKey)((ECPublicKey)publicKey), null);
            }
            case "ES384": {
                return Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)publicKey), null);
            }
            case "ES512": {
                return Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)publicKey), null);
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm '" + alg + "'");
    }

    public static Algorithm buildAlgorithm(DecodedJWT jwt, String secret) {
        return AlgorithmBuilder.buildAlgorithm(jwt.getAlgorithm(), secret);
    }

    public static Algorithm buildAlgorithm(String alg, String secret) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)alg) ? 1 : 0) != 0, (Object)"A algorithm is required");
        Preconditions.checkArgument((secret != null ? 1 : 0) != 0, (Object)"A secret is required");
        switch (alg) {
            case "HS256": {
                return Algorithm.HMAC256((String)secret);
            }
            case "HS384": {
                return Algorithm.HMAC384((String)secret);
            }
            case "HS512": {
                return Algorithm.HMAC512((String)secret);
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm '" + alg + "'");
    }
}

