/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.aai.api;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AttributeMapper
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AttributeMapper.class);
    private List<String> aaiAttributes;
    private Map<String, List<String>> attributeMap;
    private boolean useHeader = true;
    private String multiValueDelimiter = ";";

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.attributeMap, (String)"attributeMap must be set");
    }

    public List<String> getMappedAttributes(Map<String, List<String>> sourceAttributes, String mappingId) {
        LinkedHashSet<String> mappedAttributes = new LinkedHashSet<String>();
        SpelExpressionParser parser = new SpelExpressionParser();
        List<String> expressions = this.attributeMap.get(mappingId);
        if (expressions == null) {
            throw new IllegalArgumentException("No mapping for \"" + mappingId + "\" specified. Did you forget to configure a <util:map id=\"" + mappingId + "\" ...?");
        }
        for (String expression : expressions) {
            Expression exp = null;
            try {
                exp = parser.parseExpression(expression);
                String res = (String)exp.getValue(sourceAttributes);
                logger.debug("Mapping {} to {}", (Object)exp.getExpressionString(), (Object)res);
                if (res == null) continue;
                mappedAttributes.add(res);
            }
            catch (Exception e) {
                logger.warn("Mapping for '{}' with expression {} exp.getExpressionString() failed: {}", new Object[]{mappingId, exp.getExpressionString(), e.getMessage()});
            }
        }
        return CollectionUtils.arrayToList((Object)mappedAttributes.toArray());
    }

    public List<String> getMappedAttributes(HttpServletRequest request, String mappingId) {
        Assert.notNull(this.aaiAttributes, (String)"aaiAttributes must be set. Did you forget to configure <util:list id=\"aaiAttribute\"?");
        Assert.isTrue((this.aaiAttributes.size() > 0 ? 1 : 0) != 0, (String)"At least one aaiAttribute must be set. Did you forget to configure some in <util:list id=\"aaiAttribute\"?");
        HashMap<String, List<String>> sourceAttributes = new HashMap<String, List<String>>();
        for (String aaiAttribute : this.aaiAttributes) {
            String value = null;
            if (this.isUseHeader()) {
                value = request.getHeader(aaiAttribute);
                if (value == null) {
                    logger.warn("No header '{}' found in request.", (Object)aaiAttribute);
                    continue;
                }
            } else {
                value = (String)request.getAttribute(aaiAttribute);
                if (value == null) {
                    logger.warn("No attribute '{}' found in request.", (Object)aaiAttribute);
                    continue;
                }
            }
            sourceAttributes.put(aaiAttribute, CollectionUtils.arrayToList((Object)value.split(this.multiValueDelimiter)));
        }
        return this.getMappedAttributes(sourceAttributes, mappingId);
    }

    public Map<String, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, List<String>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public List<String> getAaiAttributes() {
        return this.aaiAttributes;
    }

    public void setAaiAttributes(List<String> aaiAttributes) {
        this.aaiAttributes = aaiAttributes;
    }

    public boolean isUseHeader() {
        return this.useHeader;
    }

    public void setUseHeader(boolean useHeader) {
        this.useHeader = useHeader;
    }

    public String getMultiValueDelimiter() {
        return this.multiValueDelimiter;
    }

    public void setMultiValueDelimiter(String multiValueDelimiter) {
        this.multiValueDelimiter = multiValueDelimiter;
    }
}

