/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.aai;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.aai.api.AttributeMapper;
import org.opencastproject.security.api.GroupProvider;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUserReference;
import org.opencastproject.security.shibboleth.ShibbolethLoginHandler;
import org.opencastproject.userdirectory.api.AAIRoleProvider;
import org.opencastproject.userdirectory.api.UserReferenceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DynamicLoginHandler
implements ShibbolethLoginHandler,
AAIRoleProvider,
GroupProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DynamicLoginHandler.class);
    private UserReferenceProvider userReferenceProvider = null;
    private SecurityService securityService = null;
    private AttributeMapper attributeMapper = null;

    public void newUserLogin(String id, HttpServletRequest request) {
        String name = this.extractName(request);
        String email = this.extractEmail(request);
        Date loginDate = new Date();
        JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
        Set<JpaRole> roles = this.extractRoles(id, request);
        JpaUserReference userReference = new JpaUserReference(id, name, email, "shibboleth", loginDate, organization, roles);
        logger.debug("Shibboleth user '{}' logged in for the first time", (Object)id);
        this.userReferenceProvider.addUserReference(userReference, "shibboleth");
    }

    public void existingUserLogin(String id, HttpServletRequest request) {
        Organization organization = this.securityService.getOrganization();
        JpaUserReference userReference = this.userReferenceProvider.findUserReference(id, organization.getId());
        if (userReference == null) {
            throw new UsernameNotFoundException("User reference '" + id + "' was not found");
        }
        userReference.setName(this.extractName(request));
        userReference.setEmail(this.extractEmail(request));
        userReference.setLastLogin(new Date());
        Set<JpaRole> roles = this.extractRoles(id, request);
        userReference.setRoles(roles);
        logger.debug("Shibboleth user '{}' logged in", (Object)id);
        this.userReferenceProvider.updateUserReference(userReference);
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserReferenceProvider(UserReferenceProvider userReferenceProvider) {
        this.userReferenceProvider = userReferenceProvider;
    }

    private String extractName(HttpServletRequest request) {
        String displayName = this.extractDisplayName(request);
        if (StringUtils.isNotBlank((CharSequence)displayName)) {
            return displayName;
        }
        return null;
    }

    private String extractEmail(HttpServletRequest request) {
        List<String> mailAdresses = this.attributeMapper.getMappedAttributes(request, "mail");
        if (mailAdresses.size() == 0) {
            return null;
        }
        String mailValue = mailAdresses.get(0);
        String mail = StringUtils.isBlank((CharSequence)mailValue) ? "" : new String(mailValue.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        return mail;
    }

    private String extractDisplayName(HttpServletRequest request) {
        List<String> displayNames = this.attributeMapper.getMappedAttributes(request, "displayName");
        if (displayNames.size() == 0) {
            return null;
        }
        String displayNameValue = displayNames.get(0);
        String displayName = StringUtils.isBlank((CharSequence)displayNameValue) ? "" : new String(displayNameValue.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        return displayName;
    }

    private Set<JpaRole> extractRoles(String id, HttpServletRequest request) {
        List<String> aaiRoles = this.attributeMapper.getMappedAttributes(request, "roles");
        JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
        HashSet<JpaRole> roles = new HashSet<JpaRole>();
        if (aaiRoles != null) {
            for (String aaiRole : aaiRoles) {
                roles.add(new JpaRole(aaiRole, organization));
            }
        }
        return roles;
    }

    private JpaOrganization fromOrganization(Organization org) {
        if (org instanceof JpaOrganization) {
            return (JpaOrganization)org;
        }
        return new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
    }

    public Iterator<Role> getRoles() {
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
        roles.add(new JaxbRole(organization.getAnonymousRole(), organization));
        roles.addAll(this.securityService.getUser().getRoles());
        return roles.iterator();
    }

    public List<Role> getRolesForUser(String userName) {
        ArrayList<Role> roles = new ArrayList<Role>();
        User user = this.userReferenceProvider.loadUser(userName);
        if (user != null) {
            roles.addAll(user.getRoles());
        }
        return roles;
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        HashSet<Role> foundRoles = new HashSet<Role>();
        Iterator<Role> it = this.getRoles();
        while (it.hasNext()) {
            Role role = it.next();
            if (!this.like(role.getName(), query) && !this.like(role.getDescription(), query)) continue;
            foundRoles.add(role);
        }
        return this.offsetLimitCollection(offset, limit, foundRoles).iterator();
    }

    private <T> HashSet<T> offsetLimitCollection(int offset, int limit, HashSet<T> entries) {
        HashSet<T> result = new HashSet<T>();
        int i = 0;
        for (T entry : entries) {
            if (limit != 0 && result.size() >= limit) break;
            if (i >= offset) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }

    public void afterPropertiesSet() throws Exception {
        this.userReferenceProvider.setRoleProvider((RoleProvider)this);
    }

    public AttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    public void setAttributeMapper(AttributeMapper attributeMapper) {
        this.attributeMapper = attributeMapper;
    }

    public List<Role> getRolesForGroup(String groupName) {
        return null;
    }
}

