/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.aai;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUserReference;
import org.opencastproject.security.shibboleth.ShibbolethLoginHandler;
import org.opencastproject.userdirectory.api.UserReferenceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ConfigurableLoginHandler
implements ShibbolethLoginHandler,
RoleProvider,
ManagedService {
    private static final String CFG_AAI_ENABLED_KEY = "enabled";
    private static final boolean CFG_AAI_ENABLED_DEFAULT = false;
    private static final String CFG_BOOTSTRAP_USER_ID_KEY = "bootstrap.user.id";
    private static final String CFG_HEADER_GIVEN_NAME_KEY = "header.given_name";
    private static final String CFG_HEADER_SURNAME_KEY = "header.surname";
    private static final String CFG_HEADER_MAIL_KEY = "header.mail";
    private static final String CFG_HEADER_HOME_ORGANIZATION_KEY = "header.home_organization";
    private static final String CFG_HEADER_AFFILIATION_KEY = "header.affiliation";
    private static final String CFG_ROLE_USER_PREFIX_KEY = "role.user.prefix";
    private static final String CFG_ROLE_USER_PREFIX_DEFAULT = "ROLE_AAI_USER_";
    private static final String CFG_ROLE_ORGANIZATION_PREFIX_KEY = "role.organization.prefix";
    private static final String CFG_ROLE_ORGANIZATION_PREFIX_DEFAULT = "ROLE_AAI_ORG_";
    private static final String CFG_ROLE_ORGANIZATION_SUFFIX_KEY = "role.organization.suffix";
    private static final String CFG_ROLE_ORGANIZATION_SUFFIX_DEFAULT = "_MEMBER";
    private static final String CFG_ROLE_FEDERATION_KEY = "role.federation";
    private static final String CFG_ROLE_FEDERATION_DEFAULT = "ROLE_AAI_USER";
    private static final String CFG_ROLE_AFFILIATION_PREFIX_KEY = "role.affiliation.prefix";
    private static final String CFG_ROLE_AFFILIATION_PREFIX_DEFAULT = "ROLE_AAI_USER_AFFILIATION_";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableLoginHandler.class);
    private UserReferenceProvider userReferenceProvider = null;
    private SecurityService securityService = null;
    private boolean enabled = false;
    private String bootstrapUserId = null;
    private String headerGivenName = null;
    private String headerSurname = null;
    private String headerMail = null;
    private String headerHomeOrganization = null;
    private String headerAffiliation = null;
    private String roleFederationMember = "ROLE_AAI_USER";
    private String roleUserPrefix = "ROLE_AAI_USER_";
    private String roleOrganizationPrefix = "ROLE_AAI_ORG_";
    private String roleOrganizationSuffix = "_MEMBER";
    private String roleAffiliationPrefix = "ROLE_AAI_USER_AFFILIATION_";

    public ConfigurableLoginHandler() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.registerAsManagedService(bundleContext);
    }

    protected ConfigurableLoginHandler(BundleContext bundleContext) {
        this.registerAsManagedService(bundleContext);
    }

    private void registerAsManagedService(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", this.getClass().getName());
        bundleContext.registerService(ManagedService.class.getName(), (Object)this, properties);
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        String cfgEnabled = StringUtils.trimToNull((String)((String)properties.get(CFG_AAI_ENABLED_KEY)));
        if (cfgEnabled != null) {
            this.enabled = BooleanUtils.toBoolean((String)cfgEnabled);
        }
        if (!this.enabled) {
            logger.info("AAI login handler is disabled.");
            return;
        }
        logger.info("AAI login handler is enabled.");
        String cfgBootstrapUserId = StringUtils.trimToNull((String)((String)properties.get(CFG_BOOTSTRAP_USER_ID_KEY)));
        if (cfgBootstrapUserId != null) {
            this.bootstrapUserId = cfgBootstrapUserId;
            logger.warn("AAI User ID '{}' is configured as AAI boostrap user. You want to disable this after bootstrapping.", (Object)this.bootstrapUserId);
        } else {
            this.bootstrapUserId = null;
        }
        String cfgGivenName = StringUtils.trimToNull((String)((String)properties.get(CFG_HEADER_GIVEN_NAME_KEY)));
        if (cfgGivenName != null) {
            this.headerGivenName = cfgGivenName;
            logger.info("Header '{}' set to '{}'", (Object)CFG_HEADER_GIVEN_NAME_KEY, (Object)this.headerGivenName);
        } else {
            logger.error("Header '{}' is not configured ", (Object)CFG_HEADER_GIVEN_NAME_KEY);
        }
        String cfgSurname = StringUtils.trimToNull((String)((String)properties.get(CFG_HEADER_SURNAME_KEY)));
        if (cfgSurname != null) {
            this.headerSurname = cfgSurname;
            logger.info("Header '{}' set to '{}'", (Object)CFG_HEADER_SURNAME_KEY, (Object)this.headerSurname);
        } else {
            logger.error("Header '{}' is not configured ", (Object)CFG_HEADER_SURNAME_KEY);
        }
        String cfgMail = StringUtils.trimToNull((String)((String)properties.get(CFG_HEADER_MAIL_KEY)));
        if (cfgMail != null) {
            this.headerMail = cfgMail;
            logger.info("Header '{}' set to '{}'", (Object)CFG_HEADER_MAIL_KEY, (Object)this.headerMail);
        } else {
            logger.error("Header '{}' is not configured ", (Object)CFG_HEADER_MAIL_KEY);
        }
        String cfgHomeOrganization = StringUtils.trimToNull((String)((String)properties.get(CFG_HEADER_HOME_ORGANIZATION_KEY)));
        if (cfgHomeOrganization != null) {
            this.headerHomeOrganization = cfgHomeOrganization;
            logger.info("Header '{}' set to '{}'", (Object)CFG_HEADER_HOME_ORGANIZATION_KEY, (Object)this.headerHomeOrganization);
        } else {
            logger.warn("Optional header '{}' is not configured ", (Object)CFG_HEADER_HOME_ORGANIZATION_KEY);
        }
        String cfgAffiliation = StringUtils.trimToNull((String)((String)properties.get(CFG_HEADER_AFFILIATION_KEY)));
        if (cfgAffiliation != null) {
            this.headerAffiliation = cfgAffiliation;
            logger.info("Header '{}' set to '{}'", (Object)CFG_HEADER_AFFILIATION_KEY, (Object)this.headerAffiliation);
        } else {
            logger.warn("Optional header '{}' is not configured ", (Object)CFG_HEADER_AFFILIATION_KEY);
        }
        String cfgRoleFederationMember = StringUtils.trimToNull((String)((String)properties.get(CFG_ROLE_FEDERATION_KEY)));
        if (cfgRoleFederationMember != null) {
            this.roleFederationMember = cfgRoleFederationMember;
            logger.info("AAI federation membership role '{}' set to '{}'", (Object)CFG_ROLE_FEDERATION_KEY, (Object)this.roleFederationMember);
        } else {
            this.roleFederationMember = CFG_ROLE_FEDERATION_DEFAULT;
            logger.info("AAI federation membership role '{}' is not configured, using default '{}'", (Object)CFG_ROLE_FEDERATION_KEY, (Object)this.roleFederationMember);
        }
        String cfgRoleUserPrefix = StringUtils.trimToNull((String)((String)properties.get(CFG_ROLE_USER_PREFIX_KEY)));
        if (cfgRoleUserPrefix != null) {
            this.roleUserPrefix = cfgRoleUserPrefix;
            logger.info("AAI user role prefix '{}' set to '{}'", (Object)CFG_ROLE_USER_PREFIX_KEY, (Object)this.roleUserPrefix);
        } else {
            this.roleUserPrefix = CFG_ROLE_USER_PREFIX_DEFAULT;
            logger.info("AAI user role prefix '{}' is not configured, using default '{}'", (Object)CFG_ROLE_USER_PREFIX_KEY, (Object)this.roleUserPrefix);
        }
        String cfgRoleOrganizationPrefix = StringUtils.trimToNull((String)((String)properties.get(CFG_ROLE_ORGANIZATION_PREFIX_KEY)));
        if (cfgRoleOrganizationPrefix != null) {
            this.roleOrganizationPrefix = cfgRoleOrganizationPrefix;
            logger.info("AAI organization membership role prefix '{}' set to '{}'", (Object)CFG_ROLE_ORGANIZATION_PREFIX_KEY, (Object)cfgRoleOrganizationPrefix);
        } else {
            this.roleOrganizationPrefix = CFG_ROLE_ORGANIZATION_PREFIX_DEFAULT;
            logger.info("AAI organization membership role prefix '{}' is not configured, using default '{}'", (Object)CFG_ROLE_ORGANIZATION_PREFIX_KEY, (Object)this.roleOrganizationPrefix);
        }
        String cfgRoleOrganizationSuffix = StringUtils.trimToNull((String)((String)properties.get(CFG_ROLE_ORGANIZATION_SUFFIX_KEY)));
        if (cfgRoleOrganizationSuffix != null) {
            this.roleOrganizationSuffix = cfgRoleOrganizationSuffix;
            logger.info("AAI organization membership role suffix '{}' set to '{}'", (Object)CFG_ROLE_ORGANIZATION_SUFFIX_KEY, (Object)cfgRoleOrganizationSuffix);
        } else {
            this.roleOrganizationSuffix = CFG_ROLE_ORGANIZATION_SUFFIX_DEFAULT;
            logger.info("AAI organization membership role suffix '{}' is not configured, using default '{}'", (Object)CFG_ROLE_ORGANIZATION_SUFFIX_KEY, (Object)this.roleOrganizationSuffix);
        }
        String cfgRoleAffiliationPrefix = StringUtils.trimToNull((String)((String)properties.get(CFG_ROLE_AFFILIATION_PREFIX_KEY)));
        if (cfgRoleAffiliationPrefix != null) {
            this.roleAffiliationPrefix = cfgRoleAffiliationPrefix;
            logger.info("AAI affiliation role prefix '{}' set to '{}'", (Object)CFG_ROLE_AFFILIATION_PREFIX_KEY, (Object)cfgRoleAffiliationPrefix);
        } else {
            this.roleAffiliationPrefix = CFG_ROLE_AFFILIATION_PREFIX_DEFAULT;
            logger.info("AAI affiliation role prefix '{}' is not configured, using default '{}'", (Object)CFG_ROLE_AFFILIATION_PREFIX_KEY, (Object)this.roleAffiliationPrefix);
        }
    }

    public void newUserLogin(String id, HttpServletRequest request) {
        String name = this.extractName(request);
        String email = this.extractEmail(request);
        Date loginDate = new Date();
        JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
        Set<JpaRole> roles = this.extractRoles(id, request);
        JpaUserReference userReference = new JpaUserReference(id, name, email, "shibboleth", loginDate, organization, roles);
        logger.debug("Shibboleth user '{}' logged in for the first time", (Object)id);
        this.userReferenceProvider.addUserReference(userReference, "shibboleth");
    }

    public void existingUserLogin(String id, HttpServletRequest request) {
        Organization organization = this.securityService.getOrganization();
        JpaUserReference userReference = this.userReferenceProvider.findUserReference(id, organization.getId());
        if (userReference == null) {
            throw new UsernameNotFoundException("User reference '" + id + "' was not found");
        }
        userReference.setName(this.extractName(request));
        userReference.setEmail(this.extractEmail(request));
        userReference.setLastLogin(new Date());
        Set<JpaRole> roles = this.extractRoles(id, request);
        userReference.setRoles(roles);
        logger.debug("Shibboleth user '{}' logged in", (Object)id);
        this.userReferenceProvider.updateUserReference(userReference);
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserReferenceProvider(UserReferenceProvider userReferenceProvider) {
        this.userReferenceProvider = userReferenceProvider;
    }

    private String extractName(HttpServletRequest request) {
        String givenName = StringUtils.isBlank((CharSequence)request.getHeader(this.headerGivenName)) ? "" : new String(request.getHeader(this.headerGivenName).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String surname = StringUtils.isBlank((CharSequence)request.getHeader(this.headerSurname)) ? "" : new String(request.getHeader(this.headerSurname).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        return StringUtils.join((Object[])new String[]{givenName, surname}, (String)" ");
    }

    private String extractEmail(HttpServletRequest request) {
        return request.getHeader(this.headerMail);
    }

    private Set<JpaRole> extractRoles(String id, HttpServletRequest request) {
        String affiliation;
        JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
        HashSet<JpaRole> roles = new HashSet<JpaRole>();
        roles.add(new JpaRole(this.roleFederationMember, organization));
        roles.add(new JpaRole(this.roleUserPrefix + id, organization));
        roles.add(new JpaRole(organization.getAnonymousRole(), organization));
        if (this.headerHomeOrganization != null) {
            String homeOrganization = request.getHeader(this.headerHomeOrganization);
            roles.add(new JpaRole(this.roleOrganizationPrefix + homeOrganization + this.roleOrganizationSuffix, organization));
        }
        if (StringUtils.equals((CharSequence)id, (CharSequence)this.bootstrapUserId)) {
            roles.add(new JpaRole("ROLE_ADMIN", organization));
        }
        if (this.headerAffiliation != null && (affiliation = request.getHeader(this.headerAffiliation)) != null) {
            List<String> affiliations = Arrays.asList(affiliation.split(";"));
            for (String eachAffiliation : affiliations) {
                roles.add(new JpaRole(this.roleAffiliationPrefix + eachAffiliation, organization));
            }
        }
        return roles;
    }

    private JpaOrganization fromOrganization(Organization org) {
        if (org instanceof JpaOrganization) {
            return (JpaOrganization)org;
        }
        return new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        String[] roleNames;
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        HashSet<JaxbRole> roles = new HashSet<JaxbRole>(2);
        for (String name : roleNames = new String[]{this.roleFederationMember, organization.getAnonymousRole()}) {
            if (!this.like(name, query)) continue;
            roles.add(new JaxbRole(name, organization));
        }
        return this.offsetLimitCollection(offset, limit, roles).iterator();
    }

    private <T> HashSet<T> offsetLimitCollection(int offset, int limit, HashSet<T> entries) {
        HashSet<T> result = new HashSet<T>();
        int i = 0;
        for (T entry : entries) {
            if (limit != 0 && result.size() >= limit) break;
            if (i >= offset) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }
}

