/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.schema;

import java.util.Date;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.schema.JaxbOcDublinCore;
import org.opencastproject.schema.OcDublinCore;
import org.opencastproject.util.data.Function;

public final class OcDublinCoreUtil {
    public static final Function<Date, DublinCoreValue> encodeDate = new Function<Date, DublinCoreValue>(){

        public DublinCoreValue apply(Date a) {
            return OcDublinCoreUtil.encodeDate(a);
        }
    };
    public static final Function<Date, DublinCoreValue> encodeDateAccepted = new Function<Date, DublinCoreValue>(){

        public DublinCoreValue apply(Date a) {
            return OcDublinCoreUtil.encodeDateAccepted(a);
        }
    };
    public static final Function<Date, DublinCoreValue> encodeDateCopyrighted = new Function<Date, DublinCoreValue>(){

        public DublinCoreValue apply(Date a) {
            return OcDublinCoreUtil.encodeDateCopyrighted(a);
        }
    };
    public static final Function<Date, DublinCoreValue> encodeDateSubmitted = new Function<Date, DublinCoreValue>(){

        public DublinCoreValue apply(Date a) {
            return OcDublinCoreUtil.encodeDateSubmitted(a);
        }
    };

    private OcDublinCoreUtil() {
    }

    public static DublinCoreValue encodeCreated(Date a) {
        return EncodingSchemeUtils.encodeDate((Date)a, (Precision)Precision.Second);
    }

    public static DublinCoreValue encodeDate(Date a) {
        return EncodingSchemeUtils.encodeDate((Date)a, (Precision)Precision.Second);
    }

    public static DublinCoreValue encodeDateAccepted(Date a) {
        return EncodingSchemeUtils.encodeDate((Date)a, (Precision)Precision.Second);
    }

    public static DublinCoreValue encodeDateCopyrighted(Date a) {
        return EncodingSchemeUtils.encodeDate((Date)a, (Precision)Precision.Second);
    }

    public static DublinCoreValue encodeDateSubmitted(Date a) {
        return EncodingSchemeUtils.encodeDate((Date)a, (Precision)Precision.Second);
    }

    public static DublinCoreValue encodeExtent(Long a) {
        return DublinCoreValue.mk((String)a.toString());
    }

    public static DublinCoreCatalog toCatalog(OcDublinCore source) {
        DublinCoreCatalog target = DublinCores.mkOpencastEpisode().getCatalog();
        for (Object a : source.getAbstract()) {
            target.set(DublinCore.PROPERTY_ABSTRACT, (String)a);
        }
        for (Object a : source.getAccessRights()) {
            target.set(DublinCore.PROPERTY_ACCESS_RIGHTS, (String)a);
        }
        for (Object a : source.getAccrualMethod()) {
            target.set(DublinCore.PROPERTY_ACCRUAL_METHOD, (String)a);
        }
        for (Object a : source.getAccrualPeriodicity()) {
            target.set(DublinCore.PROPERTY_ACCRUAL_PERIODICITY, (String)a);
        }
        for (Object a : source.getAccrualPolicy()) {
            target.set(DublinCore.PROPERTY_ACCRUAL_POLICY, (String)a);
        }
        for (Object a : source.getAlternative()) {
            target.set(DublinCore.PROPERTY_ALTERNATIVE, (String)a);
        }
        for (Object a : source.getAudience()) {
            target.set(DublinCore.PROPERTY_AUDIENCE, (String)a);
        }
        for (Object a : source.getAvailable()) {
            target.set(DublinCore.PROPERTY_AVAILABLE, (String)a);
        }
        for (Object a : source.getBibliographicCitation()) {
            target.set(DublinCore.PROPERTY_BIBLIOGRAPHIC_CITATION, (String)a);
        }
        for (Object a : source.getConformsTo()) {
            target.set(DublinCore.PROPERTY_CONFORMS_TO, (String)a);
        }
        for (Object a : source.getContributor()) {
            target.set(DublinCore.PROPERTY_CONTRIBUTOR, (String)a);
        }
        for (Object a : source.getCoverage()) {
            target.set(DublinCore.PROPERTY_COVERAGE, (String)a);
        }
        target.set(DublinCore.PROPERTY_CREATED, OcDublinCoreUtil.encodeCreated(source.getCreated()));
        for (Object a : source.getCreator()) {
            target.set(DublinCore.PROPERTY_CREATOR, (String)a);
        }
        for (Object a : source.getDate()) {
            target.set(DublinCore.PROPERTY_DATE, OcDublinCoreUtil.encodeDate((Date)a));
        }
        for (Object a : source.getDateAccepted()) {
            target.set(DublinCore.PROPERTY_DATE_ACCEPTED, OcDublinCoreUtil.encodeDateAccepted((Date)a));
        }
        for (Object a : source.getDateCopyrighted()) {
            target.set(DublinCore.PROPERTY_DATE_COPYRIGHTED, OcDublinCoreUtil.encodeDateCopyrighted((Date)a));
        }
        for (Object a : source.getDateSubmitted()) {
            target.set(DublinCore.PROPERTY_DATE_SUBMITTED, OcDublinCoreUtil.encodeDateSubmitted((Date)a));
        }
        for (Object a : source.getDescription()) {
            target.set(DublinCore.PROPERTY_DESCRIPTION, (String)a);
        }
        for (Object a : source.getEducationLevel()) {
            target.set(DublinCore.PROPERTY_EDUCATION_LEVEL, (String)a);
        }
        for (Object a : source.getExtent()) {
            target.set(DublinCore.PROPERTY_EXTENT, OcDublinCoreUtil.encodeExtent((Long)a));
        }
        for (Object a : source.getFormat()) {
            target.set(DublinCore.PROPERTY_FORMAT, (String)a);
        }
        for (Object a : source.getHasFormat()) {
            target.set(DublinCore.PROPERTY_HAS_FORMAT, (String)a);
        }
        for (Object a : source.getHasPart()) {
            target.set(DublinCore.PROPERTY_HAS_PART, (String)a);
        }
        for (Object a : source.getHasVersion()) {
            target.set(DublinCore.PROPERTY_HAS_VERSION, (String)a);
        }
        for (Object a : source.getIdentifier()) {
            target.set(DublinCore.PROPERTY_IDENTIFIER, (String)a);
        }
        for (Object a : source.getInstructionalMethod()) {
            target.set(DublinCore.PROPERTY_INSTRUCTIONAL_METHOD, (String)a);
        }
        for (Object a : source.getIsFormatOf()) {
            target.set(DublinCore.PROPERTY_IS_FORMAT_OF, (String)a);
        }
        for (Object a : source.getIsPartOf()) {
            target.set(DublinCore.PROPERTY_IS_PART_OF, (String)a);
        }
        for (Object a : source.getIsReferencedBy()) {
            target.set(DublinCore.PROPERTY_IS_REFERENCED_BY, (String)a);
        }
        for (Object a : source.getIsReplacedBy()) {
            target.set(DublinCore.PROPERTY_IS_REPLACED_BY, (String)a);
        }
        for (Object a : source.getIsRequiredBy()) {
            target.set(DublinCore.PROPERTY_IS_REQUIRED_BY, (String)a);
        }
        for (Object a : source.getIssued()) {
            target.set(DublinCore.PROPERTY_ISSUED, (String)a);
        }
        for (Object a : source.getIsVersionOf()) {
            target.set(DublinCore.PROPERTY_IS_VERSION_OF, (String)a);
        }
        for (Object a : source.getLanguage()) {
            target.set(DublinCore.PROPERTY_LANGUAGE, (String)a);
        }
        for (Object a : source.getLicense()) {
            target.set(DublinCore.PROPERTY_LICENSE, (String)a);
        }
        for (Object a : source.getMediator()) {
            target.set(DublinCore.PROPERTY_MEDIATOR, (String)a);
        }
        for (Object a : source.getMedium()) {
            target.set(DublinCore.PROPERTY_MEDIUM, (String)a);
        }
        for (Object a : source.getModified()) {
            target.set(DublinCore.PROPERTY_MODIFIED, (String)a);
        }
        for (Object a : source.getProvenance()) {
            target.set(DublinCore.PROPERTY_PROVENANCE, (String)a);
        }
        for (Object a : source.getPublisher()) {
            target.set(DublinCore.PROPERTY_PUBLISHER, (String)a);
        }
        for (Object a : source.getReferences()) {
            target.set(DublinCore.PROPERTY_REFERENCES, (String)a);
        }
        for (Object a : source.getRelation()) {
            target.set(DublinCore.PROPERTY_RELATION, (String)a);
        }
        for (Object a : source.getReplaces()) {
            target.set(DublinCore.PROPERTY_REPLACES, (String)a);
        }
        for (Object a : source.getRequires()) {
            target.set(DublinCore.PROPERTY_REQUIRES, (String)a);
        }
        for (Object a : source.getRights()) {
            target.set(DublinCore.PROPERTY_RIGHTS, (String)a);
        }
        for (Object a : source.getRightsHolder()) {
            target.set(DublinCore.PROPERTY_RIGHTS_HOLDER, (String)a);
        }
        for (Object a : source.getSource()) {
            target.set(DublinCore.PROPERTY_SOURCE, (String)a);
        }
        for (Object a : source.getSpatial()) {
            target.set(DublinCore.PROPERTY_SPATIAL, (String)a);
        }
        for (Object a : source.getSubject()) {
            target.set(DublinCore.PROPERTY_SUBJECT, (String)a);
        }
        for (Object a : source.getTableOfContents()) {
            target.set(DublinCore.PROPERTY_TABLE_OF_CONTENTS, (String)a);
        }
        for (Object a : source.getTemporal()) {
            target.set(DublinCore.PROPERTY_TEMPORAL, (String)a);
        }
        target.set(DublinCore.PROPERTY_TITLE, source.getTitle());
        for (Object a : source.getType()) {
            target.set(DublinCore.PROPERTY_TYPE, (String)a);
        }
        for (Object a : source.getValid()) {
            target.set(DublinCore.PROPERTY_VALID, (String)a);
        }
        return target;
    }

    public static JaxbOcDublinCore toJaxb(OcDublinCore source) {
        JaxbOcDublinCore target = new JaxbOcDublinCore();
        target.abstrakt = (String)source.getAbstract().getOrElseNull();
        target.accessRights = (String)source.getAccessRights().getOrElseNull();
        target.accrualMethod = (String)source.getAccrualMethod().getOrElseNull();
        target.accrualPeriodicity = (String)source.getAccrualPeriodicity().getOrElseNull();
        target.accrualPolicy = (String)source.getAccrualPolicy().getOrElseNull();
        target.alternative = (String)source.getAlternative().getOrElseNull();
        target.audience = (String)source.getAudience().getOrElseNull();
        target.available = (String)source.getAvailable().getOrElseNull();
        target.bibliographicCitation = (String)source.getBibliographicCitation().getOrElseNull();
        target.conformsTo = (String)source.getConformsTo().getOrElseNull();
        target.contributor = (String)source.getContributor().getOrElseNull();
        target.coverage = (String)source.getCoverage().getOrElseNull();
        target.created = source.getCreated();
        target.creator = (String)source.getCreator().getOrElseNull();
        target.date = (Date)source.getDate().getOrElseNull();
        target.dateAccepted = (Date)source.getDateAccepted().getOrElseNull();
        target.dateCopyrighted = (Date)source.getDateCopyrighted().getOrElseNull();
        target.dateSubmitted = (Date)source.getDateSubmitted().getOrElseNull();
        target.description = (String)source.getDescription().getOrElseNull();
        target.educationLevel = (String)source.getEducationLevel().getOrElseNull();
        target.extent = (Long)source.getExtent().getOrElseNull();
        target.format = (String)source.getFormat().getOrElseNull();
        target.hasFormat = (String)source.getHasFormat().getOrElseNull();
        target.hasPart = (String)source.getHasPart().getOrElseNull();
        target.hasVersion = (String)source.getHasVersion().getOrElseNull();
        target.identifier = (String)source.getIdentifier().getOrElseNull();
        target.instructionalMethod = (String)source.getInstructionalMethod().getOrElseNull();
        target.isFormatOf = (String)source.getIsFormatOf().getOrElseNull();
        target.isPartOf = (String)source.getIsPartOf().getOrElseNull();
        target.isReferencedBy = (String)source.getIsReferencedBy().getOrElseNull();
        target.isReplacedBy = (String)source.getIsReplacedBy().getOrElseNull();
        target.isRequiredBy = (String)source.getIsRequiredBy().getOrElseNull();
        target.issued = (String)source.getIssued().getOrElseNull();
        target.isVersionOf = (String)source.getIsVersionOf().getOrElseNull();
        target.language = (String)source.getLanguage().getOrElseNull();
        target.license = (String)source.getLicense().getOrElseNull();
        target.mediator = (String)source.getMediator().getOrElseNull();
        target.medium = (String)source.getMedium().getOrElseNull();
        target.modified = (String)source.getModified().getOrElseNull();
        target.provenance = (String)source.getProvenance().getOrElseNull();
        target.publisher = (String)source.getPublisher().getOrElseNull();
        target.references = (String)source.getReferences().getOrElseNull();
        target.relation = (String)source.getRelation().getOrElseNull();
        target.replaces = (String)source.getReplaces().getOrElseNull();
        target.requires = (String)source.getRequires().getOrElseNull();
        target.rights = (String)source.getRights().getOrElseNull();
        target.rightsHolder = (String)source.getRightsHolder().getOrElseNull();
        target.source = (String)source.getSource().getOrElseNull();
        target.spatial = (String)source.getSpatial().getOrElseNull();
        target.subject = (String)source.getSubject().getOrElseNull();
        target.tableOfContents = (String)source.getTableOfContents().getOrElseNull();
        target.temporal = (String)source.getTemporal().getOrElseNull();
        target.title = source.getTitle();
        target.type = (String)source.getType().getOrElseNull();
        target.valid = (String)source.getValid().getOrElseNull();
        return target;
    }
}

