/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl.persistence;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.scheduler.impl.persistence.EventIdPK;

@IdClass(value=EventIdPK.class)
@Entity(name="ExtendedEvent")
@NamedQueries(value={@NamedQuery(name="ExtendedEvent.findAll", query="SELECT e FROM ExtendedEvent e WHERE e.organization = :org"), @NamedQuery(name="ExtendedEvent.countAll", query="SELECT COUNT(e) FROM ExtendedEvent e"), @NamedQuery(name="ExtendedEvent.findEvents", query="SELECT e.mediaPackageId FROM ExtendedEvent e WHERE e.organization = :org AND e.captureAgentId = :ca AND e.startDate < :end AND e.endDate > :start ORDER BY e.startDate ASC"), @NamedQuery(name="ExtendedEvent.searchEventsCA", query="SELECT e FROM ExtendedEvent e WHERE e.organization = :org AND e.captureAgentId = :ca AND e.startDate >= :startFrom AND e.startDate < :startTo AND e.endDate >= :endFrom AND e.endDate < :endTo ORDER BY e.startDate ASC"), @NamedQuery(name="ExtendedEvent.searchEvents", query="SELECT e FROM ExtendedEvent e WHERE e.organization = :org AND e.startDate >= :startFrom AND e.startDate < :startTo AND e.endDate >= :endFrom AND e.endDate < :endTo ORDER BY e.startDate ASC"), @NamedQuery(name="ExtendedEvent.knownRecordings", query="SELECT e FROM ExtendedEvent e WHERE e.organization = :org AND e.recordingState IS NOT NULL AND e.recordingLastHeard IS NOT NULL")})
@Table(name="oc_scheduled_extended_event", indexes={@Index(name="IX_oc_scheduled_extended_event_organization", columnList="organization"), @Index(name="IX_oc_scheduled_extended_event_capture_agent_id", columnList="capture_agent_id"), @Index(name="IX_oc_scheduled_extended_event_dates", columnList="start_date, end_date")})
public class ExtendedEventDto {
    @Id
    @Column(name="mediapackage_id", length=128)
    private String mediaPackageId;
    @Id
    @Column(name="organization", length=128)
    private String organization;
    @Column(name="capture_agent_id", nullable=false, length=128)
    private String captureAgentId;
    @Column(name="start_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startDate;
    @Column(name="end_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date endDate;
    @Column(name="source")
    private String source;
    @Column(name="recording_state")
    private String recordingState;
    @Column(name="recording_last_heard")
    private Long recordingLastHeard;
    @Lob
    @Column(name="presenters")
    private String presenters;
    @Column(name="last_modified_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedDate;
    @Lob
    @Column(name="capture_agent_properties")
    private String captureAgentProperties;
    @Lob
    @Column(name="workflow_properties")
    private String workflowProperties;
    @Column(name="checksum", length=64)
    private String checksum;

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public void setMediaPackageId(String mediaPackageId) {
        this.mediaPackageId = mediaPackageId;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getCaptureAgentId() {
        return this.captureAgentId;
    }

    public void setCaptureAgentId(String captureAgentId) {
        this.captureAgentId = captureAgentId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(String recordingState) {
        this.recordingState = recordingState;
    }

    public Long getRecordingLastHeard() {
        return this.recordingLastHeard;
    }

    public void setRecordingLastHeard(Long recordingLastHeard) {
        this.recordingLastHeard = recordingLastHeard;
    }

    public String getPresenters() {
        return this.presenters;
    }

    public void setPresenters(String presenters) {
        this.presenters = presenters;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getCaptureAgentProperties() {
        return this.captureAgentProperties;
    }

    public void setCaptureAgentProperties(String captureAgentProperties) {
        this.captureAgentProperties = captureAgentProperties;
    }

    public String getWorkflowProperties() {
        return this.workflowProperties;
    }

    public void setWorkflowProperties(String workflowProperties) {
        this.workflowProperties = workflowProperties;
    }
}

