/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opencastproject.assetmanager.api.Asset;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Availability;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.Predicate;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventIndexUtils;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.identifier.Id;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.message.broker.api.scheduler.SchedulerItem;
import org.opencastproject.message.broker.api.scheduler.SchedulerItemList;
import org.opencastproject.message.broker.api.update.SchedulerUpdateHandler;
import org.opencastproject.metadata.dublincore.CatalogUIAdapter;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.RecordingImpl;
import org.opencastproject.scheduler.api.RecordingState;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.scheduler.api.TechnicalMetadataImpl;
import org.opencastproject.scheduler.api.Util;
import org.opencastproject.scheduler.impl.CalendarGenerator;
import org.opencastproject.scheduler.impl.RuntimeNotFoundException;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabase;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabaseException;
import org.opencastproject.scheduler.impl.SchedulerUtil;
import org.opencastproject.scheduler.impl.persistence.ExtendedEventDto;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.XmlNamespaceBinding;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.util.data.functions.Strings;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ManagedService.class, SchedulerService.class, IndexProducer.class}, property={"service.description=Scheduler Service"})
public class SchedulerServiceImpl
extends AbstractIndexProducer
implements SchedulerService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    private static final String CFG_KEY_LAST_MODIFIED_CACHE_EXPIRE = "last_modified_cache_expire";
    private static final String CFG_KEY_MAINTENANCE = "maintenance";
    private static final int DEFAULT_CACHE_EXPIRE = 60;
    private static final String EMPTY_CALENDAR_ETAG = "mod0";
    private static final String SNAPSHOT_OWNER = "org.opencastproject.scheduler";
    private static final Gson gson = new Gson();
    protected Cache<String, String> lastModifiedCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    private SchedulerServiceDatabase persistence;
    private SeriesService seriesService;
    private SecurityService securityService;
    private AssetManager assetManager;
    private Workspace workspace;
    private AuthorizationService authorizationService;
    private OrganizationDirectoryService orgDirectoryService;
    private ElasticsearchIndex index;
    private List<EventCatalogUIAdapter> eventCatalogUIAdapters = new ArrayList<EventCatalogUIAdapter>();
    private final List<SchedulerUpdateHandler> schedulerUpdateHandlers = new CopyOnWriteArrayList<SchedulerUpdateHandler>();
    private String systemUserName;
    private ComponentContext componentContext;

    private static Map<String, String> deserializeExtendedEventProperties(String props) {
        if (props == null || props.trim().isEmpty()) {
            return new HashMap<String, String>();
        }
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(props, type);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeSchedulerUpdateHandler")
    public void addSchedulerUpdateHandler(SchedulerUpdateHandler handler) {
        this.schedulerUpdateHandlers.add(handler);
    }

    public void removeSchedulerUpdateHandler(SchedulerUpdateHandler handler) {
        this.schedulerUpdateHandlers.remove(handler);
    }

    @Reference
    public void setPersistence(SchedulerServiceDatabase persistence) {
        this.persistence = persistence;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    private void sendSchedulerUpdate(SchedulerItemList list) {
        while (this.schedulerUpdateHandlers.size() != 1) {
            logger.warn("Expecting 1 handler, but {} are registered.  Waiting 10s then retrying...", (Object)this.schedulerUpdateHandlers.size());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String mpid = list.getId();
        for (SchedulerItem item : list.getItems()) {
            for (SchedulerUpdateHandler handler : this.schedulerUpdateHandlers) {
                handler.execute(mpid, item);
            }
        }
    }

    @Reference
    public void setOrgDirectoryService(OrganizationDirectoryService orgDirectoryService) {
        this.orgDirectoryService = orgDirectoryService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.eventCatalogUIAdapters.add(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.eventCatalogUIAdapters.remove(catalogUIAdapter);
    }

    @Activate
    public void activate(ComponentContext cc) throws Exception {
        this.componentContext = cc;
        this.systemUserName = SecurityUtil.getSystemUserName((ComponentContext)cc);
        logger.info("Activating Scheduler Service");
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties != null) {
            Option cacheExpireDuration = OsgiUtil.getOptCfg(properties, (String)CFG_KEY_LAST_MODIFIED_CACHE_EXPIRE).bind(Strings.toInt);
            if (cacheExpireDuration.isSome()) {
                this.lastModifiedCache = CacheBuilder.newBuilder().expireAfterWrite((long)((Integer)cacheExpireDuration.get()).intValue(), TimeUnit.SECONDS).build();
                logger.info("Set last modified cache to {}", (Object)DateTimeSupport.humanReadableTime((long)((Integer)cacheExpireDuration.get()).intValue()));
            } else {
                logger.info("Set last modified cache to default {}", (Object)DateTimeSupport.humanReadableTime((long)60L));
            }
            Option maintenance = OsgiUtil.getOptCfgAsBoolean(properties, (String)CFG_KEY_MAINTENANCE);
            if (((Boolean)maintenance.getOrElse((Object)false)).booleanValue()) {
                String name = SchedulerServiceImpl.class.getName();
                logger.warn("Putting scheduler into maintenance mode. This only makes sense when migrating data. If this is not intended, edit the config file '{}.cfg' accordingly and restart opencast.", (Object)name);
                this.componentContext.disableComponent(name);
            }
        }
    }

    public void addEvent(Date startDateTime, Date endDateTime, String captureAgentId, Set<String> userIds, MediaPackage mediaPackage, Map<String, String> wfProperties, Map<String, String> caMetadata, Optional<String> schedulingSource) throws UnauthorizedException, SchedulerException {
        this.addEventInternal(startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, wfProperties, caMetadata, schedulingSource);
    }

    private void addEventInternal(Date startDateTime, Date endDateTime, String captureAgentId, Set<String> userIds, MediaPackage mediaPackage, Map<String, String> wfProperties, Map<String, String> caMetadata, Optional<String> schedulingSource) throws SchedulerException {
        RequireUtil.notNull((Object)startDateTime, (String)"startDateTime");
        RequireUtil.notNull((Object)endDateTime, (String)"endDateTime");
        RequireUtil.notEmpty((String)captureAgentId, (String)"captureAgentId");
        RequireUtil.notNull(userIds, (String)"userIds");
        RequireUtil.notNull((Object)mediaPackage, (String)"mediaPackage");
        RequireUtil.notNull(wfProperties, (String)"wfProperties");
        RequireUtil.notNull(caMetadata, (String)"caMetadata");
        RequireUtil.notNull(schedulingSource, (String)"schedulingSource");
        if (endDateTime.before(startDateTime)) {
            throw new IllegalArgumentException("The end date is before the start date");
        }
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        try {
            AQueryBuilder query = this.assetManager.createQuery();
            AResult result = query.select(new Target[]{query.nothing()}).where(this.withOrganization(query).and(query.mediaPackageId(mediaPackageId).and(query.version().isLatest()))).run();
            Optional record = result.getRecords().stream().findFirst();
            if (record.isPresent()) {
                logger.warn("Mediapackage with id '{}' already exists!", (Object)mediaPackageId);
                throw new SchedulerConflictException("Mediapackage with id '" + mediaPackageId + "' already exists!");
            }
            Optional<String> seriesId = Optional.ofNullable(StringUtils.trimToNull((String)mediaPackage.getSeries()));
            List<MediaPackage> conflictingEvents = this.findConflictingEvents(captureAgentId, startDateTime, endDateTime);
            if (conflictingEvents.size() > 0) {
                logger.info("Unable to add event {}, conflicting events found: {}", (Object)mediaPackageId, conflictingEvents);
                throw new SchedulerConflictException("Unable to add event, conflicting events found for event " + mediaPackageId);
            }
            Optional dublinCore = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mediaPackage);
            AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mediaPackage).getA();
            Map<String, String> finalCaProperties = this.getFinalAgentProperties(caMetadata, wfProperties, captureAgentId, seriesId, dublinCore);
            String checksum = SchedulerUtil.calculateChecksum(this.workspace, this.getEventCatalogUIAdapterFlavors(), startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, dublinCore, wfProperties, finalCaProperties, acl);
            this.persistEvent(mediaPackageId, checksum, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(captureAgentId), Optional.of(userIds), Optional.of(mediaPackage), Optional.of(wfProperties), Optional.of(finalCaProperties), schedulingSource);
            this.updateLiveEvent(mediaPackageId, Optional.of(acl), dublinCore, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(captureAgentId), Optional.of(finalCaProperties));
            this.updateEventInIndex(mediaPackageId, Optional.of(acl), dublinCore, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(userIds), Optional.of(captureAgentId), Optional.of(finalCaProperties), Optional.empty());
            this.touchLastEntry(captureAgentId);
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to create event with id '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public Map<String, Period> addMultipleEvents(RRule rRule, Date start, Date end, Long duration, TimeZone tz, String captureAgentId, Set<String> userIds, MediaPackage templateMp, Map<String, String> wfProperties, Map<String, String> caMetadata, Optional<String> schedulingSource) throws UnauthorizedException, SchedulerConflictException, SchedulerException {
        Util.adjustRrule((RRule)rRule, (Date)start, (TimeZone)tz);
        List periods = Util.calculatePeriods((Date)start, (Date)end, (long)duration, (RRule)rRule, (TimeZone)tz);
        if (periods.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.addMultipleEventInternal(periods, captureAgentId, userIds, templateMp, wfProperties, caMetadata, schedulingSource);
    }

    private Map<String, Period> addMultipleEventInternal(List<Period> periods, String captureAgentId, Set<String> userIds, MediaPackage templateMp, Map<String, String> wfProperties, Map<String, String> caMetadata, Optional<String> schedulingSource) throws SchedulerException {
        RequireUtil.notNull(periods, (String)"periods");
        RequireUtil.requireTrue((periods.size() > 0 ? 1 : 0) != 0, (String)"periods");
        RequireUtil.notEmpty((String)captureAgentId, (String)"captureAgentId");
        RequireUtil.notNull(userIds, (String)"userIds");
        RequireUtil.notNull((Object)templateMp, (String)"mediaPackages");
        RequireUtil.notNull(wfProperties, (String)"wfProperties");
        RequireUtil.notNull(caMetadata, (String)"caMetadata");
        RequireUtil.notNull(schedulingSource, (String)"schedulingSource");
        ConcurrentHashMap<String, Period> scheduledEvents = new ConcurrentHashMap<String, Period>();
        try {
            LinkedList<IdImpl> ids = new LinkedList<IdImpl>();
            AQueryBuilder qb = this.assetManager.createQuery();
            Predicate p = null;
            while (ids.size() <= periods.size()) {
                while (ids.size() <= periods.size()) {
                    IdImpl id = new IdImpl(UUID.randomUUID().toString());
                    ids.add(id);
                    Predicate np = qb.mediaPackageId(id.toString());
                    if (null == p) {
                        p = np;
                        continue;
                    }
                    p = p.or(np);
                }
                AResult result = qb.select(new Target[]{qb.nothing()}).where(this.withOrganization(qb).and(p).and(qb.version().isLatest())).run();
                if (result.getTotalSize() <= 0L) continue;
                ids.clear();
            }
            Optional<String> seriesId = Optional.ofNullable(StringUtils.trimToNull((String)templateMp.getSeries()));
            List<MediaPackage> conflictingEvents = this.findConflictingEvents(periods, captureAgentId, TimeZone.getDefault());
            if (conflictingEvents.size() > 0) {
                logger.info("Unable to add events, conflicting events found: {}", conflictingEvents);
                throw new SchedulerConflictException("Unable to add event, conflicting events found");
            }
            Organization org = this.securityService.getOrganization();
            User user = this.securityService.getUser();
            periods.parallelStream().forEach(event -> SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)user, () -> {
                DublinCoreCatalog dc;
                int currentCounter = periods.indexOf(event);
                MediaPackage mediaPackage = (MediaPackage)templateMp.clone();
                Date startDate = new Date(event.getStart().getTime());
                Date endDate = new Date(event.getEnd().getTime());
                Id id = (Id)ids.get(currentCounter);
                Optional dcOpt = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)templateMp);
                if (dcOpt.isPresent()) {
                    dc = (DublinCoreCatalog)dcOpt.get();
                    dc = (DublinCoreCatalog)dc.clone();
                    dc.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"oc", (String)"http://www.opencastproject.org/matterhorn/")}));
                } else {
                    dc = DublinCores.mkOpencastEpisode().getCatalog();
                }
                mediaPackage.setIdentifier(id);
                String newTitle = dc.getFirst(DublinCore.PROPERTY_TITLE) + String.format(" %0" + Integer.toString(periods.size()).length() + "d", currentCounter + 1);
                dc.set(DublinCore.PROPERTY_TITLE, newTitle);
                DublinCoreValue eventTime = EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(startDate, endDate), (Precision)Precision.Second);
                dc.set(DublinCore.PROPERTY_TEMPORAL, eventTime);
                dc.set(DublinCore.PROPERTY_CREATED, EncodingSchemeUtils.encodeDate((Date)startDate, (Precision)Precision.Second));
                try {
                    mediaPackage = this.updateDublincCoreCatalog(mediaPackage, dc);
                }
                catch (Exception e) {
                    Misc.chuck((Throwable)e);
                }
                mediaPackage.setTitle(newTitle);
                String mediaPackageId = mediaPackage.getIdentifier().toString();
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.setTime((Date)event.getStart());
                Date startDateTime = cal.getTime();
                cal.setTime((Date)event.getEnd());
                Date endDateTime = cal.getTime();
                Optional dublinCore = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mediaPackage);
                AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mediaPackage).getA();
                Map<String, String> finalCaProperties = this.getFinalAgentProperties(caMetadata, wfProperties, captureAgentId, seriesId, dublinCore);
                String checksum = SchedulerUtil.calculateChecksum(this.workspace, this.getEventCatalogUIAdapterFlavors(), startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, dublinCore, wfProperties, finalCaProperties, acl);
                try {
                    this.persistEvent(mediaPackageId, checksum, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(captureAgentId), Optional.of(userIds), Optional.of(mediaPackage), Optional.of(wfProperties), Optional.of(finalCaProperties), schedulingSource);
                }
                catch (Exception e) {
                    Misc.chuck((Throwable)e);
                }
                this.updateLiveEvent(mediaPackageId, Optional.of(acl), dublinCore, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(captureAgentId), Optional.of(finalCaProperties));
                this.updateEventInIndex(mediaPackageId, Optional.of(acl), dublinCore, Optional.of(startDateTime), Optional.of(endDateTime), Optional.of(userIds), Optional.of(captureAgentId), Optional.of(finalCaProperties), Optional.empty());
                scheduledEvents.put(mediaPackageId, (Period)event);
                for (MediaPackageElement mediaPackageElement : mediaPackage.getElements()) {
                    try {
                        this.workspace.delete(mediaPackage.getIdentifier().toString(), mediaPackageElement.getIdentifier());
                    }
                    catch (IOException | NotFoundException e) {
                        logger.warn("Failed to delete media package element", e);
                    }
                }
            }));
            ConcurrentHashMap<String, Period> concurrentHashMap = scheduledEvents;
            return concurrentHashMap;
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
        finally {
            if (!scheduledEvents.isEmpty()) {
                this.touchLastEntry(captureAgentId);
            }
        }
    }

    public void updateEvent(String mpId, Optional<Date> startDateTime, Optional<Date> endDateTime, Optional<String> captureAgentId, Optional<Set<String>> userIds, Optional<MediaPackage> mediaPackage, Optional<Map<String, String>> wfProperties, Optional<Map<String, String>> caMetadata) throws NotFoundException, UnauthorizedException, SchedulerException {
        this.updateEventInternal(mpId, startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, wfProperties, caMetadata, false);
    }

    public void updateEvent(String mpId, Optional<Date> startDateTime, Optional<Date> endDateTime, Optional<String> captureAgentId, Optional<Set<String>> userIds, Optional<MediaPackage> mediaPackage, Optional<Map<String, String>> wfProperties, Optional<Map<String, String>> caMetadata, boolean allowConflict) throws NotFoundException, UnauthorizedException, SchedulerException {
        this.updateEventInternal(mpId, startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, wfProperties, caMetadata, allowConflict);
    }

    private void updateEventInternal(String mpId, Optional<Date> startDateTime, Optional<Date> endDateTime, Optional<String> captureAgentId, Optional<Set<String>> userIds, Optional<MediaPackage> mediaPackageOpt, Optional<Map<String, String>> wfProperties, Optional<Map<String, String>> caMetadata, boolean allowConflict) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)mpId, (String)"mpId");
        RequireUtil.notNull(startDateTime, (String)"startDateTime");
        RequireUtil.notNull(endDateTime, (String)"endDateTime");
        RequireUtil.notNull(captureAgentId, (String)"captureAgentId");
        RequireUtil.notNull(userIds, (String)"userIds");
        RequireUtil.notNull(mediaPackageOpt, (String)"mediaPackageOpt");
        RequireUtil.notNull(wfProperties, (String)"wfProperties");
        RequireUtil.notNull(caMetadata, (String)"caMetadata");
        try {
            String oldChecksum;
            String checksum;
            List conflictingEvents;
            AQueryBuilder query = this.assetManager.createQuery();
            ASelectQuery select = query.select(new Target[]{query.snapshot()}).where(this.withOrganization(query).and(query.mediaPackageId(mpId).and(query.version().isLatest()).and(this.withOwner(query))));
            Optional optEvent = select.run().getRecords().stream().findFirst();
            Optional<ExtendedEventDto> optExtEvent = this.persistence.getEvent(mpId);
            if (optEvent.isEmpty() || optExtEvent.isEmpty()) {
                throw new NotFoundException("No event found while updating event " + mpId);
            }
            ARecord record = (ARecord)optEvent.get();
            if (record.getSnapshot().isEmpty()) {
                throw new NotFoundException("No mediapackage found while updating event " + mpId);
            }
            Snapshot snapshot = (Snapshot)record.getSnapshot().get();
            MediaPackage archivedMediaPackage = snapshot.getMediaPackage();
            Optional<DublinCoreCatalog> archivedDublinCoreOpt = this.loadEpisodeDublinCoreFromAsset(snapshot);
            if (archivedDublinCoreOpt.isEmpty()) {
                throw new NotFoundException("No dublincore found while updating event " + mpId);
            }
            DublinCoreCatalog archivedDublinCore = archivedDublinCoreOpt.get();
            AccessControlList archivedAcl = (AccessControlList)this.authorizationService.getActiveAcl(archivedMediaPackage).getA();
            ExtendedEventDto extendedEventDto = optExtEvent.get();
            Date start = extendedEventDto.getStartDate();
            Date end = extendedEventDto.getEndDate();
            if ((startDateTime.isPresent() || endDateTime.isPresent()) && endDateTime.orElse(end).before(startDateTime.orElse(start))) {
                throw new SchedulerException("The end date is before the start date");
            }
            String agentId = extendedEventDto.getCaptureAgentId();
            Optional<String> seriesId = Optional.ofNullable(archivedMediaPackage.getSeries());
            if (!(!captureAgentId.isPresent() && !startDateTime.isPresent() && !endDateTime.isPresent() || allowConflict && this.isAdmin() || (conflictingEvents = this.findConflictingEvents(captureAgentId.orElse(agentId), startDateTime.orElse(start), endDateTime.orElse(end)).stream().filter(mp -> !mpId.equals(mp.getIdentifier().toString())).collect(Collectors.toList())).size() <= 0)) {
                logger.info("Unable to update event {}, conflicting events found: {}", (Object)mpId, conflictingEvents);
                throw new SchedulerConflictException("Unable to update event, conflicting events found for event " + mpId);
            }
            Set<String> presenters = this.getPresenters(Optional.ofNullable(extendedEventDto.getPresenters()).orElse(""));
            Map<String, String> wfProps = SchedulerServiceImpl.deserializeExtendedEventProperties(extendedEventDto.getWorkflowProperties());
            Map<String, String> caProperties = SchedulerServiceImpl.deserializeExtendedEventProperties(extendedEventDto.getCaptureAgentProperties());
            boolean propertiesChanged = false;
            boolean dublinCoreChanged = false;
            if (wfProperties.isPresent()) {
                propertiesChanged = true;
                wfProps = wfProperties.get();
            }
            if (caMetadata.isPresent()) {
                propertiesChanged = true;
                caProperties = caMetadata.get();
            }
            if (captureAgentId.isPresent()) {
                propertiesChanged = true;
            }
            Optional<Object> changedAclOpt = Optional.empty();
            Optional<Object> changedDublinCoreOpt = Optional.empty();
            if (mediaPackageOpt.isPresent()) {
                Optional dublinCoreOpt;
                AccessControlList acl;
                MediaPackage mediaPackage = mediaPackageOpt.get();
                if (EqualsUtil.ne((Object)archivedMediaPackage.getSeries(), (Object)mediaPackage.getSeries())) {
                    propertiesChanged = true;
                    seriesId = Optional.ofNullable(mediaPackage.getSeries());
                }
                if (!AccessControlUtil.equals((AccessControlList)(acl = (AccessControlList)this.authorizationService.getActiveAcl(mediaPackage).getA()), (AccessControlList)archivedAcl)) {
                    changedAclOpt = Optional.of(acl);
                }
                if ((dublinCoreOpt = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mediaPackage)).isPresent() && !DublinCoreUtil.equals((DublinCoreCatalog)archivedDublinCore, (DublinCoreCatalog)((DublinCoreCatalog)dublinCoreOpt.get()))) {
                    dublinCoreChanged = true;
                    propertiesChanged = true;
                    changedDublinCoreOpt = dublinCoreOpt;
                }
            }
            DublinCoreCatalog dublinCore = changedDublinCoreOpt.orElse(archivedDublinCore);
            DublinCoreCatalog dublinCoreCopy = (DublinCoreCatalog)dublinCore.clone();
            if (startDateTime.isPresent() && endDateTime.isPresent()) {
                DublinCoreValue eventTime = EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(startDateTime.get(), endDateTime.get()), (Precision)Precision.Second);
                dublinCore.set(DublinCore.PROPERTY_TEMPORAL, eventTime);
            }
            if (captureAgentId.isPresent()) {
                dublinCore.set(DublinCore.PROPERTY_SPATIAL, captureAgentId.get());
            }
            if (!DublinCoreUtil.equals((DublinCoreCatalog)dublinCore, (DublinCoreCatalog)dublinCoreCopy)) {
                dublinCoreChanged = true;
                changedDublinCoreOpt = Optional.of(dublinCore);
                mediaPackageOpt = Optional.of(this.updateDublincCoreCatalog(mediaPackageOpt.orElse(archivedMediaPackage), (DublinCoreCatalog)changedDublinCoreOpt.get()));
            }
            Optional<Object> finalCaProperties = Optional.empty();
            if (propertiesChanged) {
                finalCaProperties = Optional.of(this.getFinalAgentProperties(caProperties, wfProps, captureAgentId.orElse(agentId), seriesId, Optional.of((DublinCoreCatalog)changedDublinCoreOpt.orElse(archivedDublinCore))));
            }
            if ((checksum = SchedulerUtil.calculateChecksum(this.workspace, this.getEventCatalogUIAdapterFlavors(), startDateTime.orElse(start), endDateTime.orElse(end), captureAgentId.orElse(agentId), userIds.orElse(presenters), mediaPackageOpt.orElse(archivedMediaPackage), Optional.of((DublinCoreCatalog)changedDublinCoreOpt.orElse(archivedDublinCore)), wfProperties.orElse(wfProps), finalCaProperties.orElse(caProperties), changedAclOpt.orElse(new AccessControlList()))).equals(oldChecksum = extendedEventDto.getChecksum())) {
                logger.debug("Updated event {} has same checksum, ignore update", (Object)mpId);
                return;
            }
            this.persistEvent(mpId, checksum, startDateTime, endDateTime, captureAgentId, userIds, mediaPackageOpt, wfProperties, finalCaProperties, Optional.empty());
            this.updateLiveEvent(mpId, changedAclOpt, changedDublinCoreOpt, startDateTime, endDateTime, Optional.of(agentId), finalCaProperties);
            this.updateEventInIndex(mpId, changedAclOpt, changedDublinCoreOpt, startDateTime, endDateTime, userIds, Optional.of(agentId), finalCaProperties, Optional.empty());
            if (propertiesChanged || dublinCoreChanged || startDateTime.isPresent() || endDateTime.isPresent()) {
                this.touchLastEntry(agentId);
                if (captureAgentId.isPresent()) {
                    this.touchLastEntry(captureAgentId.get());
                }
            }
        }
        catch (SchedulerException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    private boolean isAdmin() {
        return this.securityService.getUser().hasRole("ROLE_ADMIN") || this.securityService.getUser().hasRole(this.securityService.getOrganization().getAdminRole());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<DublinCoreCatalog> loadEpisodeDublinCoreFromAsset(Snapshot snapshot) {
        Optional<DublinCoreCatalog> optional;
        Option dcCatalog = Monadics.mlist((Object[])snapshot.getMediaPackage().getElements()).filter(MediaPackageSupport.Filters.isEpisodeDublinCore).headOpt();
        if (dcCatalog.isNone()) {
            return Optional.empty();
        }
        Optional asset = this.assetManager.getAsset(snapshot.getVersion(), snapshot.getMediaPackage().getIdentifier().toString(), ((MediaPackageElement)dcCatalog.get()).getIdentifier());
        if (asset.isEmpty()) {
            return Optional.empty();
        }
        if (Availability.OFFLINE.equals((Object)((Asset)asset.get()).getAvailability())) {
            return Optional.empty();
        }
        InputStream inputStream = null;
        try {
            inputStream = ((Asset)asset.get()).getInputStream();
            optional = Optional.of(DublinCores.read((InputStream)inputStream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return optional;
    }

    public synchronized void removeEvent(String mediaPackageId) throws NotFoundException, SchedulerException {
        boolean notFoundInAssetManager;
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        boolean notFoundInDatabase = false;
        try {
            try {
                Optional<ExtendedEventDto> extEvtOpt = this.persistence.getEvent(mediaPackageId);
                if (extEvtOpt.isPresent()) {
                    String agentId = extEvtOpt.get().getCaptureAgentId();
                    this.persistence.deleteEvent(mediaPackageId);
                    if (StringUtils.isNotEmpty((CharSequence)agentId)) {
                        this.touchLastEntry(agentId);
                    }
                } else {
                    notFoundInDatabase = true;
                }
            }
            catch (NotFoundException e) {
                notFoundInDatabase = true;
            }
            AQueryBuilder query = this.assetManager.createQuery();
            long deletedSnapshots = query.delete(SNAPSHOT_OWNER, query.snapshot()).where(this.withOrganization(query).and(query.mediaPackageId(mediaPackageId))).name("delete episode").run();
            notFoundInAssetManager = deletedSnapshots == 0L;
            this.sendSchedulerUpdate(new SchedulerItemList(mediaPackageId, new SchedulerItem[]{SchedulerItem.delete()}));
            this.removeSchedulingInfoFromIndex(mediaPackageId);
        }
        catch (Exception e) {
            logger.error("Could not remove event '{}' from persistent storage", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
        if (notFoundInDatabase && notFoundInAssetManager) {
            throw new NotFoundException();
        }
    }

    public MediaPackage getMediaPackage(String mediaPackageId) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        try {
            return this.getEventMediaPackage(mediaPackageId);
        }
        catch (RuntimeNotFoundException e) {
            throw e.getWrappedException();
        }
        catch (Exception e) {
            logger.error("Failed to get mediapackage of event '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public DublinCoreCatalog getDublinCore(String mediaPackageId) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        try {
            AQueryBuilder query = this.assetManager.createQuery();
            AResult result = query.select(new Target[]{query.snapshot()}).where(this.withOrganization(query).and(query.mediaPackageId(mediaPackageId)).and(this.withOwner(query)).and(query.version().isLatest())).run();
            Optional record = result.getRecords().stream().findFirst();
            if (record.isEmpty()) {
                throw new NotFoundException();
            }
            Optional<DublinCoreCatalog> dublinCore = this.loadEpisodeDublinCoreFromAsset((Snapshot)((ARecord)record.get()).getSnapshot().get());
            if (dublinCore.isEmpty()) {
                throw new NotFoundException("No dublincore catalog found " + mediaPackageId);
            }
            return dublinCore.get();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get dublin core catalog of event '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public TechnicalMetadata getTechnicalMetadata(String mediaPackageId) throws NotFoundException, UnauthorizedException, SchedulerException {
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        try {
            Optional<ExtendedEventDto> extEvt = this.persistence.getEvent(mediaPackageId);
            if (extEvt.isEmpty()) {
                throw new NotFoundException();
            }
            return this.getTechnicalMetadata(extEvt.get());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get technical metadata of event '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public Map<String, String> getWorkflowConfig(String mediaPackageId) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        try {
            Optional<ExtendedEventDto> record = this.persistence.getEvent(mediaPackageId);
            if (record.isEmpty()) {
                throw new NotFoundException();
            }
            return SchedulerServiceImpl.deserializeExtendedEventProperties(record.get().getWorkflowProperties());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get workflow configuration of event '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public Map<String, String> getCaptureAgentConfiguration(String mediaPackageId) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)mediaPackageId, (String)"mediaPackageId");
        try {
            Optional<ExtendedEventDto> record = this.persistence.getEvent(mediaPackageId);
            if (record.isEmpty()) {
                throw new NotFoundException();
            }
            return SchedulerServiceImpl.deserializeExtendedEventProperties(record.get().getCaptureAgentProperties());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get capture agent contiguration of event '{}':", (Object)mediaPackageId, (Object)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    public int getEventCount() throws SchedulerException {
        try {
            return this.persistence.countEvents();
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public List<MediaPackage> search(Optional<String> captureAgentId, Optional<Date> startsFrom, Optional<Date> startsTo, Optional<Date> endFrom, Optional<Date> endTo) throws SchedulerException {
        try {
            return this.persistence.search(captureAgentId, startsFrom, startsTo, endFrom, endTo, Optional.empty()).stream().map(ExtendedEventDto::getMediaPackageId).map(this::getEventMediaPackage).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public Optional<MediaPackage> getCurrentRecording(String captureAgentId) throws SchedulerException {
        try {
            Date now = new Date();
            List<ExtendedEventDto> result = this.persistence.search(Optional.of(captureAgentId), Optional.empty(), Optional.of(now), Optional.of(now), Optional.empty(), Optional.of(1));
            if (result.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.getEventMediaPackage(result.get(0).getMediaPackageId()));
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public Optional<MediaPackage> getUpcomingRecording(String captureAgentId) throws SchedulerException {
        try {
            Date now = new Date();
            List<ExtendedEventDto> result = this.persistence.search(Optional.of(captureAgentId), Optional.of(now), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(1));
            if (result.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.getEventMediaPackage(result.get(0).getMediaPackageId()));
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public List<MediaPackage> findConflictingEvents(String captureDeviceID, Date startDate, Date endDate) throws SchedulerException {
        try {
            Organization organization = this.securityService.getOrganization();
            User user = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)organization);
            ArrayList<MediaPackage> conflictingEvents = new ArrayList<MediaPackage>();
            SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)user, () -> {
                try {
                    this.persistence.getEvents(captureDeviceID, startDate, endDate, 0).stream().map(id -> this.getEventMediaPackage((String)id, false)).forEach(conflictingEvents::add);
                }
                catch (SchedulerServiceDatabaseException e) {
                    logger.error("Failed to get conflicting events", (Throwable)e);
                }
            });
            return conflictingEvents;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public List<MediaPackage> findConflictingEvents(String captureAgentId, RRule rrule, Date start, Date end, long duration, TimeZone tz) throws SchedulerException {
        RequireUtil.notEmpty((String)captureAgentId, (String)"captureAgentId");
        RequireUtil.notNull((Object)rrule, (String)"rrule");
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        RequireUtil.notNull((Object)tz, (String)"timeZone");
        Util.adjustRrule((RRule)rrule, (Date)start, (TimeZone)tz);
        List periods = Util.calculatePeriods((Date)start, (Date)end, (long)duration, (RRule)rrule, (TimeZone)tz);
        if (periods.isEmpty()) {
            return Collections.emptyList();
        }
        return this.findConflictingEvents(periods, captureAgentId, tz);
    }

    private boolean checkPeriodOverlap(List<Period> periods) {
        ArrayList<Period> sortedPeriods = new ArrayList<Period>(periods);
        sortedPeriods.sort(Comparator.comparing(Period::getStart));
        Period prior = periods.get(0);
        for (Period current : periods.subList(1, periods.size())) {
            if (current.getStart().compareTo((Date)prior.getEnd()) < 0) {
                return true;
            }
            prior = current;
        }
        return false;
    }

    private List<MediaPackage> findConflictingEvents(List<Period> periods, String captureAgentId, TimeZone tz) throws SchedulerException {
        RequireUtil.notEmpty((String)captureAgentId, (String)"captureAgentId");
        RequireUtil.notNull(periods, (String)"periods");
        RequireUtil.requireTrue((periods.size() > 0 ? 1 : 0) != 0, (String)"periods");
        if (this.checkPeriodOverlap(periods)) {
            throw new IllegalArgumentException("RRULE periods overlap");
        }
        try {
            TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
            HashSet<MediaPackage> events = new HashSet<MediaPackage>();
            for (Period event : periods) {
                event.setTimeZone(registry.getTimeZone(tz.getID()));
                net.fortuna.ical4j.model.DateTime startDate = event.getStart();
                net.fortuna.ical4j.model.DateTime endDate = event.getEnd();
                events.addAll(this.findConflictingEvents(captureAgentId, (Date)startDate, (Date)endDate));
            }
            return new ArrayList<MediaPackage>(events);
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public String getCalendar(Optional<String> captureAgentId, Optional<String> seriesId, Optional<Date> cutoff) throws SchedulerException {
        try {
            Map searchResult = this.persistence.search(captureAgentId, Optional.empty(), cutoff, Optional.of(DateTime.now().minusHours(1).toDate()), Optional.empty(), Optional.empty()).stream().collect(Collectors.toMap(ExtendedEventDto::getMediaPackageId, Function.identity()));
            AQueryBuilder query = this.assetManager.createQuery();
            AResult result = query.select(new Target[]{query.snapshot()}).where(this.withOrganization(query).and(query.mediaPackageIds(searchResult.keySet().toArray(new String[0]))).and(this.withOwner(query)).and(query.version().isLatest())).run();
            CalendarGenerator cal = new CalendarGenerator(this.seriesService);
            for (ARecord record : result.getRecords()) {
                Optional optMp;
                Optional<Object> optional = optMp = record.getSnapshot().isPresent() ? Optional.of(((Snapshot)record.getSnapshot().get()).getMediaPackage()) : Optional.empty();
                if (optMp.isEmpty()) {
                    logger.warn("Mediapackage for event '{}' can't be found, event is not recorded", (Object)record.getMediaPackageId());
                    continue;
                }
                if (seriesId.isPresent() && !seriesId.get().equals(((MediaPackage)optMp.get()).getSeries())) continue;
                Optional<DublinCoreCatalog> catalogOpt = this.loadEpisodeDublinCoreFromAsset((Snapshot)record.getSnapshot().get());
                if (catalogOpt.isEmpty()) {
                    logger.warn("No episode catalog available, skipping!");
                    continue;
                }
                Map<String, String> caMetadata = SchedulerServiceImpl.deserializeExtendedEventProperties(((ExtendedEventDto)searchResult.get(record.getMediaPackageId())).getCaptureAgentProperties());
                if (caMetadata.isEmpty()) {
                    logger.warn("Properties for event '{}' can't be found, event is not recorded", (Object)record.getMediaPackageId());
                    continue;
                }
                String agentId = ((ExtendedEventDto)searchResult.get(record.getMediaPackageId())).getCaptureAgentId();
                Date start = ((ExtendedEventDto)searchResult.get(record.getMediaPackageId())).getStartDate();
                Date end = ((ExtendedEventDto)searchResult.get(record.getMediaPackageId())).getEndDate();
                Date lastModified = ((Snapshot)record.getSnapshot().get()).getArchivalDate();
                try {
                    cal.addEvent((MediaPackage)optMp.get(), catalogOpt.get(), agentId, start, end, lastModified, this.toPropertyString(caMetadata));
                }
                catch (Exception e) {
                    logger.warn("Error adding event '{}' to calendar, event is not recorded", (Object)record.getMediaPackageId(), (Object)e);
                }
            }
            if (cal.getCalendar().getComponents().size() > 0) {
                cal.getCalendar().validate();
            }
            return cal.getCalendar().toString();
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public String getScheduleLastModified(String captureAgentId) throws SchedulerException {
        RequireUtil.notEmpty((String)captureAgentId, (String)"captureAgentId");
        try {
            String lastModified = (String)this.lastModifiedCache.getIfPresent((Object)captureAgentId);
            if (lastModified != null) {
                return lastModified;
            }
            this.populateLastModifiedCache();
            lastModified = (String)this.lastModifiedCache.getIfPresent((Object)captureAgentId);
            if (lastModified == null) {
                lastModified = EMPTY_CALENDAR_ETAG;
                this.lastModifiedCache.put((Object)captureAgentId, (Object)lastModified);
            }
            return lastModified;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void removeScheduledRecordingsBeforeBuffer(long buffer) throws SchedulerException {
        List<ExtendedEventDto> finishedEvents;
        DateTime end = new DateTime(DateTimeZone.UTC).minus(buffer * 1000L);
        logger.info("Starting to look for scheduled recordings that have finished before {}.", (Object)DateTimeSupport.toUTC((long)end.getMillis()));
        try {
            finishedEvents = this.persistence.search(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(end.toDate()), Optional.empty());
            logger.debug("Found {} events from search.", (Object)finishedEvents.size());
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
        int recordingsRemoved = 0;
        for (ExtendedEventDto extEvt : finishedEvents) {
            String eventId = extEvt.getMediaPackageId();
            try {
                this.removeEvent(eventId);
                logger.debug("Sucessfully removed scheduled event with id " + eventId);
                ++recordingsRemoved;
            }
            catch (NotFoundException e) {
                logger.debug("Skipping event with id {} because it is not found", (Object)eventId);
            }
            catch (Exception e) {
                logger.warn("Unable to delete event with id '{}':", (Object)eventId, (Object)e);
            }
        }
        logger.info("Found {} to remove that ended before {}.", (Object)recordingsRemoved, (Object)DateTimeSupport.toUTC((long)end.getMillis()));
    }

    public boolean updateRecordingState(String id, String state) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)id, (String)"id");
        RequireUtil.notEmpty((String)state, (String)"state");
        if (!RecordingState.KNOWN_STATES.contains(state)) {
            logger.warn("Invalid recording state: {}.", (Object)state);
            return false;
        }
        try {
            Optional<ExtendedEventDto> optExtEvt = this.persistence.getEvent(id);
            if (optExtEvt.isEmpty()) {
                throw new NotFoundException();
            }
            String prevRecordingState = optExtEvt.get().getRecordingState();
            RecordingImpl r = new RecordingImpl(id, state);
            if (!state.equals(prevRecordingState)) {
                logger.debug("Setting Recording {} to state {}.", (Object)id, (Object)state);
                this.sendSchedulerUpdate(new SchedulerItemList(r.getID(), Collections.singletonList(SchedulerItem.updateRecordingStatus((String)r.getState(), (Long)r.getLastCheckinTime()))));
                this.updateEventInIndex(r.getID(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(r.getState()));
            } else {
                logger.debug("Recording state not changed");
            }
            this.persistence.storeEvent(id, this.securityService.getOrganization().getId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(r.getState()), Optional.of(r.getLastCheckinTime()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            return true;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public Recording getRecordingState(String id) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)id, (String)"id");
        try {
            Optional<ExtendedEventDto> extEvt = this.persistence.getEvent(id);
            if (extEvt.isEmpty() || extEvt.get().getRecordingState() == null) {
                throw new NotFoundException();
            }
            return new RecordingImpl(id, extEvt.get().getRecordingState(), extEvt.get().getRecordingLastHeard().longValue());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void removeRecording(String id) throws NotFoundException, SchedulerException {
        RequireUtil.notEmpty((String)id, (String)"id");
        try {
            this.persistence.resetRecordingState(id);
            this.sendSchedulerUpdate(new SchedulerItemList(id, new SchedulerItem[]{SchedulerItem.deleteRecordingState()}));
            this.removeRecordingStatusFromIndex(id);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public Map<String, Recording> getKnownRecordings() throws SchedulerException {
        try {
            return this.persistence.getKnownRecordings().parallelStream().collect(Collectors.toMap(ExtendedEventDto::getMediaPackageId, dto -> new RecordingImpl(dto.getMediaPackageId(), dto.getRecordingState(), dto.getRecordingLastHeard().longValue())));
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    private synchronized void persistEvent(String mpId, String checksum, Optional<Date> startDateTime, Optional<Date> endDateTime, Optional<String> captureAgentId, Optional<Set<String>> userIds, Optional<MediaPackage> mediaPackage, Optional<Map<String, String>> wfProperties, Optional<Map<String, String>> caProperties, Optional<String> schedulingSource) throws SchedulerServiceDatabaseException {
        if (mediaPackage.isPresent()) {
            this.assetManager.takeSnapshot(SNAPSHOT_OWNER, mediaPackage.get());
        }
        this.persistence.storeEvent(mpId, this.securityService.getOrganization().getId(), captureAgentId, startDateTime, endDateTime, schedulingSource, Optional.empty(), Optional.empty(), userIds.isPresent() ? Optional.of(String.join((CharSequence)",", (Iterable<? extends CharSequence>)userIds.get())) : Optional.empty(), Optional.of(new Date()), Optional.of(checksum), wfProperties, caProperties);
    }

    private void updateEventInIndex(String mediaPackageId, Optional<AccessControlList> acl, Optional<DublinCoreCatalog> dublinCore, Optional<Date> startTime, Optional<Date> endTime, Optional<Set<String>> presenters, Optional<String> agentId, Optional<Map<String, String>> properties, Optional<String> recordingStatus) {
        String organization = this.getSecurityService().getOrganization().getId();
        User user = this.getSecurityService().getUser();
        Function<Optional<Event>, Optional<Event>> updateFunction = this.getEventUpdateFunction(mediaPackageId, acl, dublinCore, startTime, endTime, presenters, agentId, properties, recordingStatus, organization, user);
        try {
            this.index.addOrUpdateEvent(mediaPackageId, updateFunction, organization, user);
            logger.debug("Scheduled event {} updated in the {} index.", (Object)mediaPackageId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Error updating the scheduled event {} in the {} index.", new Object[]{mediaPackageId, this.index.getIndexName(), e});
        }
    }

    private void removeRecordingStatusFromIndex(String mediaPackageId) {
        String organization = this.getSecurityService().getOrganization().getId();
        User user = this.getSecurityService().getUser();
        Function<Optional, Optional> updateFunction = eventOpt -> {
            Event event = eventOpt.orElse(new Event(mediaPackageId, organization));
            event.setRecordingStatus(null);
            return Optional.of(event);
        };
        try {
            this.index.addOrUpdateEvent(mediaPackageId, updateFunction, organization, user);
            logger.debug("Recording state of event {} removed from the {} index.", (Object)mediaPackageId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Failed to remove the recording state of event {} from the {} index.", new Object[]{mediaPackageId, this.index.getIndexName(), e});
        }
    }

    private void removeSchedulingInfoFromIndex(String mediaPackageId) {
        String orgId = this.getSecurityService().getOrganization().getId();
        try {
            this.index.deleteEvent(mediaPackageId, orgId);
            logger.debug("Scheduling information of event {} removed from the {} index.", (Object)mediaPackageId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Failed to delete the scheduling information of event {} from the {} index.", new Object[]{mediaPackageId, this.index.getIndexName(), e});
        }
    }

    private void updateLiveEvent(String mpId, Optional<AccessControlList> acl, Optional<DublinCoreCatalog> dublinCore, Optional<Date> startTime, Optional<Date> endTime, Optional<String> agentId, Optional<Map<String, String>> properties) {
        ArrayList<SchedulerItem> items = new ArrayList<SchedulerItem>();
        if (acl.isPresent()) {
            items.add(SchedulerItem.updateAcl((AccessControlList)acl.get()));
        }
        if (dublinCore.isPresent()) {
            items.add(SchedulerItem.updateCatalog((DublinCoreCatalog)dublinCore.get()));
        }
        if (startTime.isPresent()) {
            items.add(SchedulerItem.updateStart((Date)startTime.get()));
        }
        if (endTime.isPresent()) {
            items.add(SchedulerItem.updateEnd((Date)endTime.get()));
        }
        if (agentId.isPresent()) {
            items.add(SchedulerItem.updateAgent((String)agentId.get()));
        }
        if (properties.isPresent()) {
            items.add(SchedulerItem.updateProperties(properties.get()));
        }
        if (!items.isEmpty()) {
            this.sendSchedulerUpdate(new SchedulerItemList(mpId, items));
        }
    }

    private Map<String, String> getFinalAgentProperties(Map<String, String> caMetadata, Map<String, String> wfProperties, String captureAgentId, Optional<String> seriesId, Optional<DublinCoreCatalog> dublinCore) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : caMetadata.entrySet()) {
            if (entry.getKey().startsWith("org.opencastproject.workflow.config.")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : wfProperties.entrySet()) {
            properties.put("org.opencastproject.workflow.config.".concat(entry.getKey()), entry.getValue());
        }
        if (dublinCore.isPresent()) {
            properties.put("event.title", dublinCore.get().getFirst(DublinCore.PROPERTY_TITLE));
        }
        if (seriesId.isPresent()) {
            properties.put("event.series", seriesId.get());
        }
        properties.put("event.location", captureAgentId);
        return properties;
    }

    private void touchLastEntry(String captureAgentId) throws SchedulerException {
        try {
            logger.debug("Marking calendar feed for {} as modified", (Object)captureAgentId);
            this.persistence.touchLastEntry(captureAgentId);
            this.populateLastModifiedCache();
        }
        catch (SchedulerServiceDatabaseException e) {
            logger.error("Failed to update last modified entry of agent '{}':", (Object)captureAgentId, (Object)e);
        }
    }

    private void populateLastModifiedCache() throws SchedulerException {
        try {
            Map<String, Date> lastModifiedDates = this.persistence.getLastModifiedDates();
            for (Map.Entry<String, Date> entry : lastModifiedDates.entrySet()) {
                Date lastModifiedDate = entry.getValue() != null ? entry.getValue() : new Date();
                this.lastModifiedCache.put((Object)entry.getKey(), (Object)this.generateLastModifiedHash(lastModifiedDate));
            }
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    private String generateLastModifiedHash(Date lastModifiedDate) {
        return "mod" + Long.toString(lastModifiedDate.getTime());
    }

    private String toPropertyString(Map<String, String> properties) {
        StringBuilder wfPropertiesString = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            wfPropertiesString.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return wfPropertiesString.toString();
    }

    private MediaPackage getEventMediaPackage(String mediaPackageId, boolean checkOwner) {
        Optional record;
        AQueryBuilder query = this.assetManager.createQuery();
        Predicate predicate = this.withOrganization(query).and(query.mediaPackageId(mediaPackageId)).and(query.version().isLatest());
        if (checkOwner) {
            predicate = predicate.and(this.withOwner(query));
        }
        if ((record = query.select(new Target[]{query.snapshot()}).where(predicate).run().getRecords().stream().findFirst()).isEmpty()) {
            throw new RuntimeNotFoundException(new NotFoundException());
        }
        return ((Snapshot)((ARecord)record.get()).getSnapshot().get()).getMediaPackage();
    }

    private MediaPackage getEventMediaPackage(String mediaPackageId) {
        return this.getEventMediaPackage(mediaPackageId, true);
    }

    private MediaPackage updateDublincCoreCatalog(MediaPackage mp, DublinCoreCatalog dc) throws IOException, MediaPackageException {
        block7: {
            try (InputStream inputStream = IOUtils.toInputStream((String)dc.toXmlString(), (String)"UTF-8");){
                Catalog[] catalogs = mp.getCatalogs(MediaPackageElements.EPISODE);
                if (catalogs.length > 0) {
                    Catalog catalog = catalogs[0];
                    URI uri = this.workspace.put(mp.getIdentifier().toString(), catalog.getIdentifier(), "dublincore.xml", inputStream);
                    catalog.setURI(uri);
                    catalog.setChecksum(null);
                    break block7;
                }
                throw new MediaPackageException("Unable to find catalog");
            }
        }
        return mp;
    }

    private TechnicalMetadata getTechnicalMetadata(ExtendedEventDto extEvt) {
        String agentId = extEvt.getCaptureAgentId();
        Date start = extEvt.getStartDate();
        Date end = extEvt.getEndDate();
        Set<String> presenters = this.getPresenters(Optional.ofNullable(extEvt.getPresenters()).orElse(""));
        Optional<String> recordingStatus = Optional.ofNullable(extEvt.getRecordingState());
        Optional<Long> lastHeard = Optional.ofNullable(extEvt.getRecordingLastHeard());
        Map<String, String> caMetadata = SchedulerServiceImpl.deserializeExtendedEventProperties(extEvt.getCaptureAgentProperties());
        Map<String, String> wfProperties = SchedulerServiceImpl.deserializeExtendedEventProperties(extEvt.getWorkflowProperties());
        RecordingImpl recording = null;
        if (recordingStatus.isPresent() && lastHeard.isPresent()) {
            recording = new RecordingImpl(extEvt.getMediaPackageId(), recordingStatus.get(), lastHeard.get().longValue());
        }
        return new TechnicalMetadataImpl(extEvt.getMediaPackageId(), agentId, start, end, presenters, wfProperties, caMetadata, Optional.ofNullable(recording));
    }

    private Predicate withOrganization(AQueryBuilder query) {
        return query.organizationId().eq((Object)this.securityService.getOrganization().getId());
    }

    private Predicate withOwner(AQueryBuilder query) {
        return query.owner().eq((Object)SNAPSHOT_OWNER);
    }

    private Set<String> getPresenters(String presentersString) {
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)presentersString, (String)",")));
    }

    private List<MediaPackageElementFlavor> getEventCatalogUIAdapterFlavors() {
        String organization = this.securityService.getOrganization().getId();
        return this.eventCatalogUIAdapters.stream().filter(adapter -> adapter.handlesOrganization(organization)).map(CatalogUIAdapter::getFlavor).filter(mpe -> !MediaPackageElements.EPISODE.matches(mpe)).collect(Collectors.toList());
    }

    public void repopulate(IndexRebuildService.DataType type) throws IndexRebuildException {
        try {
            int total;
            try {
                total = this.persistence.countEvents();
            }
            catch (SchedulerServiceDatabaseException e) {
                this.logIndexRebuildError(logger, e);
                throw new IndexRebuildException(this.getService(), (Throwable)e);
            }
            this.logIndexRebuildBegin(logger, total, "scheduled events");
            int[] current = new int[]{0};
            int n = 20;
            ArrayList updatedEventRange = new ArrayList();
            for (Organization organization : this.orgDirectoryService.getOrganizations()) {
                User user = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)organization);
                SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)user, () -> {
                    List<ExtendedEventDto> events;
                    try {
                        events = this.persistence.getEvents();
                    }
                    catch (SchedulerServiceDatabaseException e) {
                        this.logIndexRebuildError(logger, e, organization);
                        return;
                    }
                    for (ExtendedEventDto event : events) {
                        try {
                            current[0] = current[0] + 1;
                            Optional<Event> updatedEventData = Optional.of(new Event(event.getMediaPackageId(), organization.getId()));
                            Set<String> presenters = this.getPresenters(Optional.ofNullable(event.getPresenters()).orElse(""));
                            Map<String, String> caMetadata = SchedulerServiceImpl.deserializeExtendedEventProperties(event.getCaptureAgentProperties());
                            updatedEventData = this.getEventUpdateFunction(event.getMediaPackageId(), Optional.empty(), Optional.empty(), Optional.of(event.getStartDate()), Optional.of(event.getEndDate()), Optional.of(presenters), Optional.of(event.getCaptureAgentId()), Optional.of(caMetadata), Optional.ofNullable(event.getRecordingState()), organization.getId(), this.securityService.getUser()).apply(updatedEventData);
                            updatedEventRange.add(updatedEventData.get());
                            if (updatedEventRange.size() < n && current[0] < events.size()) continue;
                            this.index.bulkEventUpdate((List)updatedEventRange);
                            this.logIndexRebuildProgress(logger, total, current[0], n);
                            updatedEventRange.clear();
                        }
                        catch (SearchIndexException e) {
                            logger.error("Error while updating event '{}' from search index:", (Object)event.getMediaPackageId(), (Object)e);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Fatal error while indexing event " + event.getMediaPackageId(), e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logIndexRebuildError(logger, e);
            throw new IndexRebuildException(this.getService(), (Throwable)e);
        }
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Scheduler;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    private Function<Optional<Event>, Optional<Event>> getEventUpdateFunction(String mediaPackageId, Optional<AccessControlList> acl, Optional<DublinCoreCatalog> dublinCore, Optional<Date> startTime, Optional<Date> endTime, Optional<Set<String>> presenters, Optional<String> agentId, Optional<Map<String, String>> properties, Optional<String> recordingStatus, String orgId, User user) {
        return eventOpt -> {
            Event event = eventOpt.orElse(new Event(mediaPackageId, orgId));
            if (acl.isPresent()) {
                event.setAccessPolicy(AccessControlParser.toJsonSilent((AccessControlList)((AccessControlList)acl.get())));
            }
            if (dublinCore.isPresent()) {
                EventIndexUtils.updateEvent((Event)event, (DublinCore)((DublinCore)dublinCore.get()));
                if (StringUtils.isBlank((CharSequence)event.getCreator())) {
                    event.setCreator(this.getSecurityService().getUser().getName());
                }
                try {
                    EventIndexUtils.updateSeriesName((Event)event, (String)orgId, (User)user, (ElasticsearchIndex)this.index);
                }
                catch (SearchIndexException e) {
                    logger.error("Error updating the series name of the event {} in the {} index.", new Object[]{mediaPackageId, this.index.getIndexName(), e});
                }
            }
            if (presenters.isPresent()) {
                event.setTechnicalPresenters(new ArrayList((Collection)presenters.get()));
            }
            if (agentId.isPresent()) {
                event.setAgentId((String)agentId.get());
            }
            if (recordingStatus.isPresent() && !((String)recordingStatus.get()).equals("unknown")) {
                event.setRecordingStatus((String)recordingStatus.get());
            }
            if (properties.isPresent()) {
                event.setAgentConfiguration((Map)properties.get());
            }
            if (startTime.isPresent()) {
                String startTimeStr = startTime == null ? null : DateTimeSupport.toUTC((long)((Date)startTime.get()).getTime());
                event.setTechnicalStartTime(startTimeStr);
            }
            if (endTime.isPresent()) {
                String endTimeStr = endTime == null ? null : DateTimeSupport.toUTC((long)((Date)endTime.get()).getTime());
                event.setTechnicalEndTime(endTimeStr);
            }
            return Optional.of(event);
        };
    }
}

