/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Prelude;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.scheduler.api.SchedulerEvent;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulerUtil {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerUtil.class);
    public static final Comparator<Catalog> sortCatalogById = new Comparator<Catalog>(){

        @Override
        public int compare(Catalog c1, Catalog c2) {
            return c1.getIdentifier().compareTo(c2.getIdentifier());
        }
    };
    public static final Fn<MediaPackageElementFlavor, Boolean> isNotEpisodeDublinCore = new Fn<MediaPackageElementFlavor, Boolean>(){

        public Boolean apply(MediaPackageElementFlavor mpe) {
            return !MediaPackageElements.EPISODE.matches(mpe);
        }
    };
    public static final Fn<EventCatalogUIAdapter, MediaPackageElementFlavor> uiAdapterToFlavor = new Fn<EventCatalogUIAdapter, MediaPackageElementFlavor>(){

        public MediaPackageElementFlavor apply(EventCatalogUIAdapter adapter) {
            return adapter.getFlavor();
        }
    };
    public static final Fn2<EventCatalogUIAdapter, String, Boolean> eventOrganizationFilter = new Fn2<EventCatalogUIAdapter, String, Boolean>(){

        public Boolean apply(EventCatalogUIAdapter catalogUIAdapter, String organization) {
            return catalogUIAdapter.getOrganization().equals(organization);
        }
    };

    private SchedulerUtil() {
    }

    public static String calculateChecksum(Workspace workspace, List<MediaPackageElementFlavor> eventCatalogUIAdapterFlavors, Date startDateTime, Date endDateTime, String captureAgentId, Set<String> userIds, MediaPackage mediaPackage, Opt<DublinCoreCatalog> episodeDublincore, Map<String, String> wfProperties, Map<String, String> finalCaProperties, AccessControlList acl) {
        ArrayList<String> userIdsList = new ArrayList<String>(userIds);
        Collections.sort(userIdsList);
        MessageDigest messageDigest = SchedulerUtil.mkMd5MessageDigest();
        messageDigest.update(SchedulerUtil.mkChecksumInput(startDateTime));
        messageDigest.update(SchedulerUtil.mkChecksumInput(endDateTime));
        messageDigest.update(SchedulerUtil.mkChecksumInput(captureAgentId));
        for (String user : userIdsList) {
            messageDigest.update(SchedulerUtil.mkChecksumInput(user));
        }
        if (episodeDublincore.isSome()) {
            Catalog episodeCatalog = (Catalog)Stream.$((Object[])mediaPackage.getCatalogs()).filter(MediaPackageSupport.Filters.isEpisodeDublinCore.toFn()).head2();
            Checksum checksum = episodeCatalog.getChecksum();
            if (checksum == null) {
                checksum = DublinCoreUtil.calculateChecksum((DublinCoreCatalog)((DublinCoreCatalog)episodeDublincore.get()));
                episodeCatalog.setChecksum(checksum);
            }
            messageDigest.update(SchedulerUtil.mkChecksumInput(checksum.toString()));
        }
        for (Catalog c : Stream.$((Object[])mediaPackage.getCatalogs()).sort(sortCatalogById)) {
            if (!eventCatalogUIAdapterFlavors.contains(c.getFlavor())) continue;
            Checksum checksum = c.getChecksum();
            if (checksum == null) {
                DublinCoreCatalog dublinCore = DublinCoreUtil.loadDublinCore((Workspace)workspace, (MediaPackageElement)c);
                checksum = DublinCoreUtil.calculateChecksum((DublinCoreCatalog)dublinCore);
                c.setChecksum(checksum);
            }
            messageDigest.update(SchedulerUtil.mkChecksumInput(checksum.toString()));
        }
        messageDigest.update(SchedulerUtil.mkChecksumInput(AccessControlUtil.calculateChecksum((AccessControlList)acl).toString()));
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(wfProperties).entrySet()) {
            messageDigest.update(SchedulerUtil.mkChecksumInput(entry.getKey()));
            messageDigest.update(SchedulerUtil.mkChecksumInput(entry.getValue()));
        }
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(finalCaProperties).entrySet()) {
            messageDigest.update(SchedulerUtil.mkChecksumInput(entry.getKey()));
            messageDigest.update(SchedulerUtil.mkChecksumInput(entry.getValue()));
        }
        return Checksum.convertToHex((byte[])messageDigest.digest());
    }

    private static MessageDigest mkMd5MessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Unable to create md5 message digest");
            return (MessageDigest)Prelude.chuck((Throwable)e);
        }
    }

    private static byte[] mkChecksumInput(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] mkChecksumInput(Date input) {
        return SchedulerUtil.mkChecksumInput(Long.toString(input.getTime()));
    }

    public static String toHumanReadableString(Workspace workspace, List<MediaPackageElementFlavor> catalogFlavors, SchedulerEvent event) {
        TechnicalMetadata technicalMetadata = event.getTechnicalMetadata();
        StringBuilder sb = new StringBuilder("Event: ").append('\n');
        sb.append("- ").append(event.getEventId()).append('\n');
        sb.append('\n');
        sb.append("Version").append('\n');
        sb.append("- ").append(event.getVersion()).append('\n');
        sb.append('\n');
        sb.append("Start").append('\n');
        sb.append("- ").append(DateTimeSupport.toUTC((long)technicalMetadata.getStartDate().getTime())).append('\n');
        sb.append('\n');
        sb.append("End").append('\n');
        sb.append("- ").append(DateTimeSupport.toUTC((long)technicalMetadata.getEndDate().getTime())).append('\n');
        sb.append('\n');
        sb.append("Room").append('\n');
        sb.append("- ").append(technicalMetadata.getAgentId()).append('\n');
        sb.append('\n');
        sb.append("Scheduling configuration").append('\n');
        for (Map.Entry entry : technicalMetadata.getCaptureAgentConfiguration().entrySet()) {
            sb.append("- ").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append('\n');
        }
        sb.append('\n');
        sb.append("Presenters").append('\n');
        for (String presenter : technicalMetadata.getPresenters()) {
            sb.append("- ").append(presenter).append('\n');
        }
        sb.append('\n');
        sb.append("Workflow configuration").append('\n');
        for (Map.Entry entry : technicalMetadata.getWorkflowProperties().entrySet()) {
            sb.append("- ").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append('\n');
        }
        sb.append('\n');
        for (Catalog c : Stream.$((Object[])event.getMediaPackage().getCatalogs())) {
            DublinCoreCatalog dublinCore;
            if (!catalogFlavors.contains(c.getFlavor())) continue;
            try {
                dublinCore = DublinCoreUtil.loadDublinCore((Workspace)workspace, (MediaPackageElement)c);
            }
            catch (Exception e) {
                logger.error("Unable to read event dublincore", (Throwable)e);
                continue;
            }
            sb.append("Event metadata ").append("(").append(c.getFlavor().toString()).append(")").append('\n');
            for (Map.Entry entry : dublinCore.getValues().entrySet()) {
                EName eName = (EName)entry.getKey();
                for (DublinCoreValue value : (List)entry.getValue()) {
                    boolean hasLanguageDefined;
                    sb.append("- ").append(eName.getNamespaceURI()).append(":").append(eName.getLocalName()).append(": ").append(value.getValue());
                    boolean bl = hasLanguageDefined = !"__".equals(value.getLanguage());
                    if (hasLanguageDefined || value.getEncodingScheme().isSome()) {
                        sb.append(" (");
                        if (hasLanguageDefined) {
                            sb.append("lang:").append(value.getLanguage());
                            if (value.getEncodingScheme().isSome()) {
                                sb.append("/");
                            }
                        }
                        for (EName schema : value.getEncodingScheme()) {
                            sb.append(schema.getLocalName());
                        }
                        sb.append(")");
                    }
                    sb.append('\n');
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

