/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.api;

import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.RRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    public static final int EVENT_MINIMUM_SEPARATION_MILLISECONDS = 0;
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();

    private Util() {
    }

    public static void adjustRrule(RRule rRule, java.util.Date start, TimeZone tz) {
        Recur recur = rRule.getRecur();
        if (recur.getHourList().size() != 1 || recur.getMinuteList().size() != 1) {
            throw new IllegalArgumentException("RRules with multiple hours/minutes are not supported by Opencast. " + recur.toString());
        }
        ZonedDateTime adjustedDate = ZonedDateTime.ofInstant(start.toInstant(), ZoneOffset.UTC).withHour((Integer)recur.getHourList().get(0)).withMinute((Integer)recur.getMinuteList().get(0)).withZoneSameInstant(tz.toZoneId());
        recur.getHourList().set(0, (Object)adjustedDate.getHour());
        recur.getMinuteList().set(0, (Object)adjustedDate.getMinute());
    }

    public static List<Period> calculatePeriods(java.util.Date start, java.util.Date end, long duration, RRule rRule, TimeZone tz) {
        Calendar startCal = Calendar.getInstance(tz);
        Calendar endCal = Calendar.getInstance(tz);
        startCal.setTime(start);
        endCal.setTime(end);
        return Util.calculatePeriods(startCal, endCal, duration, rRule.getRecur(), tz);
    }

    public static List<Period> calculatePeriods(Calendar startCalTz, Calendar endCalTz, long duration, Recur recur, TimeZone tz) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EE MMM dd HH:mm:ss zzz yyyy");
        simpleDateFormat.setTimeZone(tz);
        String tzStr = tz.getID();
        LinkedList<Period> event = new LinkedList<Period>();
        logger.debug("Inbound start of recurrence {} to end of recurrence {}, in Tz {}", new Object[]{simpleDateFormat.format(startCalTz.getTime()), simpleDateFormat.format(endCalTz.getTime()), tzStr});
        DateTime periodStart = new DateTime(startCalTz.getTime());
        logger.debug("ical4j timeZone for {} is {}", (Object)tzStr, (Object)registry.getTimeZone(tzStr).toZoneId());
        periodStart.setTimeZone(registry.getTimeZone(tzStr));
        DateTime periodEnd = new DateTime(endCalTz.getTime());
        periodEnd.setTimeZone(registry.getTimeZone(tzStr));
        logger.trace("is utc {}? Tz is {} ", (Object)periodStart.isUtc(), (Object)periodStart.getTimeZone().toZoneId());
        logger.debug("({}) Looking at recurrences for {} to {}, duration {}, {}", new Object[]{periodStart.getTimeZone().toZoneId(), simpleDateFormat.format(new java.util.Date(periodStart.getTime())), simpleDateFormat.format(new java.util.Date(periodEnd.getTime())), duration, recur.toString()});
        DateList dates = recur.getDates((Date)periodStart, (Date)periodEnd, Value.DATE_TIME);
        logger.trace("Got {} dates: {}, tz '{}'", new Object[]{dates.size(), dates.toString(), dates.getTimeZone().toZoneId()});
        for (java.util.Date date : dates) {
            DateTime endTZ = new DateTime(date.getTime() + duration);
            DateTime startDT = new DateTime(date);
            DateTime endDT = new DateTime((java.util.Date)endTZ);
            Period p = new Period(startDT, endDT);
            event.add(p);
        }
        for (Period e : event) {
            Calendar cal = Calendar.getInstance((TimeZone)e.getStart().getTimeZone());
            cal.setTimeInMillis(e.getStart().getTime());
            logger.debug("EventList start {} Instance {}, calendar hour {}, zone {}", new Object[]{e.getStart().toString(), simpleDateFormat.format(cal.getTime()), cal.get(11), e.getStart().getTimeZone().toZoneId()});
        }
        return event;
    }

    public static boolean schedulingIntervalsOverlap(java.util.Date start1, java.util.Date end1, java.util.Date start2, java.util.Date end2) {
        return end2.after(start1) && end1.after(start2) || Util.eventWithinMinimumSeparation(start1, end1, start2, end2);
    }

    private static boolean eventWithinMinimumSeparation(java.util.Date checkStart, java.util.Date checkEnd, java.util.Date start, java.util.Date end) {
        return Math.abs(checkStart.getTime() - start.getTime()) < 0L || Math.abs(checkStart.getTime() - end.getTime()) < 0L || Math.abs(checkEnd.getTime() - start.getTime()) < 0L || Math.abs(checkEnd.getTime() - end.getTime()) < 0L;
    }
}

