/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.opencastproject.runtimeinfo.rest.RestEndpointData;
import org.opencastproject.util.doc.DocData;

public class RestEndpointHolderData {
    private String name;
    private String title;
    private List<RestEndpointData> endpoints;

    public RestEndpointHolderData(String name, String title) throws IllegalArgumentException {
        if (!DocData.isValidName((String)name)) {
            throw new IllegalArgumentException("Name must not be null and must be alphanumeric.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title must not be null.");
        }
        this.name = name;
        this.title = title;
    }

    public void addEndPoint(RestEndpointData endpoint) {
        if (endpoint != null) {
            if (this.endpoints == null) {
                this.endpoints = new Vector<RestEndpointData>();
            }
            this.endpoints.add(endpoint);
            Collections.sort(this.endpoints);
        }
    }

    public String toString() {
        return "HOLD:" + this.name + ":" + this.endpoints;
    }

    public RestEndpointHolderData duplicate() {
        return new RestEndpointHolderData(this.name, this.title);
    }

    protected Object clone() {
        return this.duplicate();
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public List<RestEndpointData> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new Vector<RestEndpointData>(0);
        }
        return this.endpoints;
    }
}

