/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.runtimeinfo.rest.RestEndpointData;
import org.opencastproject.runtimeinfo.rest.RestEndpointHolderData;
import org.opencastproject.runtimeinfo.rest.RestFormData;
import org.opencastproject.runtimeinfo.rest.RestFormatData;
import org.opencastproject.runtimeinfo.rest.RestParamData;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;

public class RestDocData
extends DocData {
    private static final String READ_ENDPOINT_HOLDER_NAME = "READ";
    private static final String WRITE_ENDPOINT_HOLDER_NAME = "WRITE";
    public static final String PATH_PARAM_COUNTING_REGEX = "\\{(.+?)\\}";
    protected List<RestEndpointHolderData> holders;

    public RestDocData(String name, String title, String url, String[] notes) throws IllegalArgumentException {
        super(name, title, notes);
        if (url == null || "".equals(url)) {
            throw new IllegalArgumentException("URL cannot be blank.");
        }
        this.meta.put("url", url);
        this.holders = new Vector<RestEndpointHolderData>(2);
        this.holders.add(new RestEndpointHolderData(READ_ENDPOINT_HOLDER_NAME, "Read"));
        this.holders.add(new RestEndpointHolderData(WRITE_ENDPOINT_HOLDER_NAME, "Write"));
    }

    public Map<String, Object> toMap() throws IllegalStateException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("meta", this.meta);
        m.put("notes", this.notes);
        ArrayList<RestEndpointHolderData> holdersList = new ArrayList<RestEndpointHolderData>();
        for (RestEndpointHolderData holder : this.holders) {
            if (holder.getEndpoints().isEmpty()) continue;
            for (RestEndpointData endpoint : holder.getEndpoints()) {
                if (!endpoint.getPathParams().isEmpty()) {
                    for (RestParamData param : endpoint.getPathParams()) {
                        if (endpoint.getPath().contains("{" + param.getName() + "}") || endpoint.getPath().contains("{" + param.getName() + ":")) continue;
                        throw new IllegalStateException("Path (" + endpoint.getPath() + ") does not match path parameter (" + param.getName() + ") for endpoint (" + endpoint.getName() + "), the path must contain all path parameter names.");
                    }
                }
                Pattern pattern = Pattern.compile(PATH_PARAM_COUNTING_REGEX);
                Matcher matcher = pattern.matcher(endpoint.getPath());
                int count = 0;
                while (matcher.find()) {
                    ++count;
                }
                if (count == endpoint.getPathParams().size()) continue;
                throw new IllegalStateException("Path (" + endpoint.getPath() + ") does not match path parameters (" + endpoint.getPathParams() + ") for endpoint (" + endpoint.getName() + "), the path must contain the same number of path parameters (" + count + ") as the pathParams list (" + endpoint.getPathParams().size() + ").");
            }
            holdersList.add(holder);
        }
        m.put("endpointHolders", holdersList);
        return m;
    }

    public String getDefaultTemplatePath() {
        return "/ui/restdocs/template.xhtml";
    }

    public String toString() {
        return "DOC:meta=" + this.meta + ", notes=" + this.notes + ", " + this.holders;
    }

    private void addEndpoint(String type, RestEndpointData endpoint) throws IllegalStateException {
        RestEndpointHolderData currentHolder = null;
        for (RestEndpointHolderData holder : this.holders) {
            if (!type.equalsIgnoreCase(holder.getName())) continue;
            currentHolder = holder;
            break;
        }
        if (currentHolder == null) {
            throw new IllegalStateException("Could not find holder of type: " + type + ".");
        }
        currentHolder.addEndPoint(endpoint);
    }

    public void setAbstract(String abstractText) {
        if (StringUtils.isBlank((CharSequence)abstractText)) {
            this.meta.remove("abstract");
        } else {
            this.meta.put("abstract", abstractText);
        }
    }

    public static boolean isValidPath(String path) {
        return path != null && path.matches("^/$|^/[\\w/{}|:.*+]*[\\w}.]$");
    }

    public void addEndpoint(RestQuery restQuery, Class<?> returnType, Produces produces, String httpMethodString, Path path) {
        Object pathValue = path.value().startsWith("/") ? path.value() : "/" + path.value();
        RestEndpointData endpoint = new RestEndpointData(returnType, restQuery.name(), httpMethodString, (String)pathValue, restQuery.description());
        if (!restQuery.returnDescription().isEmpty()) {
            endpoint.addNote("Return value description: " + restQuery.returnDescription());
        }
        if (produces != null) {
            for (String string : produces.value()) {
                endpoint.addFormat(new RestFormatData(string));
            }
        }
        for (String string : restQuery.responses()) {
            endpoint.addStatus((RestResponse)string);
        }
        if (restQuery.bodyParameter().type() != RestParameter.Type.NO_PARAMETER) {
            endpoint.addBodyParam(restQuery.bodyParameter());
        }
        for (String string : restQuery.pathParameters()) {
            endpoint.addPathParam(new RestParamData((RestParameter)string));
        }
        for (String string : restQuery.restParameters()) {
            if (string.isRequired()) {
                endpoint.addRequiredParam(new RestParamData((RestParameter)string));
                continue;
            }
            endpoint.addOptionalParam(new RestParamData((RestParameter)string));
        }
        endpoint.setTestForm(new RestFormData(endpoint));
        if ("GET".equalsIgnoreCase(httpMethodString) || "HEAD".equalsIgnoreCase(httpMethodString)) {
            this.addEndpoint(READ_ENDPOINT_HOLDER_NAME, endpoint);
        } else if ("DELETE".equalsIgnoreCase(httpMethodString) || "POST".equalsIgnoreCase(httpMethodString) || "PUT".equalsIgnoreCase(httpMethodString)) {
            this.addEndpoint(WRITE_ENDPOINT_HOLDER_NAME, endpoint);
        }
    }
}

