/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.runtimeinfo.rest.RestDocData;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.util.doc.DocUtil;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@HttpWhiteboardServletName(value="/docs.html")
@HttpWhiteboardServletPattern(value={"/docs.html"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class RestDocsServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RestDocsServlet.class);
    public static final String SERVLET_PATH = "/docs.html";
    private static final String PATH_PARAM = "path";
    private static final long serialVersionUID = 6930336096831297329L;
    protected BundleContext bundleContext;
    private Map<String, String> globalMacro;

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.prepareMacros();
    }

    private void prepareMacros() {
        this.globalMacro = new HashMap<String, String>();
        this.globalMacro.put("PING_BACK_URL", this.bundleContext.getProperty("org.opencastproject.anonymous.feedback.url"));
        this.globalMacro.put("HOST_URL", this.bundleContext.getProperty("org.opencastproject.server.url"));
        this.globalMacro.put("LOCAL_STORAGE_DIRECTORY", this.bundleContext.getProperty("org.opencastproject.storage.dir"));
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String docPath = req.getParameter(PATH_PARAM);
        if (StringUtils.isBlank((CharSequence)docPath)) {
            resp.sendRedirect("rest_docs.html");
        } else {
            this.writeServiceDocumentation(docPath, resp);
        }
    }

    private void writeServiceDocumentation(final String docPath, HttpServletResponse resp) throws IOException {
        ServiceReference reference = null;
        for (ServiceReference ref : this.getRestEndpointServices()) {
            String alias = (String)ref.getProperty("opencast.service.path");
            if (!docPath.equalsIgnoreCase(alias)) continue;
            reference = ref;
            break;
        }
        final StringBuilder docs = new StringBuilder();
        if (reference == null) {
            docs.append("REST docs unavailable for ");
            docs.append(docPath);
        } else {
            final Object restService = this.bundleContext.getService(reference);
            RestDocsServlet.findRestAnnotation(restService.getClass()).fold((Option.Match)new Option.Match<RestService, Void>(){

                public Void some(RestService annotation) {
                    RestDocsServlet.this.globalMacro.put("SERVICE_CLASS_SIMPLE_NAME", restService.getClass().getSimpleName());
                    RestDocData data = new RestDocData(annotation.name(), annotation.title(), docPath, annotation.notes());
                    data.setAbstract(annotation.abstractText());
                    Produces producesClass = restService.getClass().getAnnotation(Produces.class);
                    for (Method m : restService.getClass().getMethods()) {
                        RestQuery rq = m.getAnnotation(RestQuery.class);
                        String httpMethodString = null;
                        for (Annotation a : m.getAnnotations()) {
                            HttpMethod httpMethod = a.annotationType().getAnnotation(HttpMethod.class);
                            if (httpMethod == null) continue;
                            httpMethodString = httpMethod.value();
                        }
                        Produces produces = m.getAnnotation(Produces.class);
                        if (produces == null) {
                            produces = producesClass;
                        }
                        Path path = m.getAnnotation(Path.class);
                        Class<?> returnType = m.getReturnType();
                        if (rq == null || httpMethodString == null || path == null) continue;
                        data.addEndpoint(rq, returnType, produces, httpMethodString, path);
                    }
                    String template = DocUtil.loadTemplate((String)"/ui/restdocs/template.xhtml");
                    docs.append(DocUtil.generate((DocData)data, (String)template));
                    return null;
                }

                public Void none() {
                    docs.append("No documentation has been found for ").append(restService.getClass().getSimpleName());
                    return null;
                }
            });
        }
        resp.setContentType("text/html");
        resp.getWriter().write(docs.toString());
    }

    private ServiceReference[] getRestEndpointServices() {
        try {
            return this.bundleContext.getAllServiceReferences(null, "(&(!(objectClass=javax.servlet.Servlet))(opencast.service.path=*))");
        }
        catch (InvalidSyntaxException e) {
            logger.warn("Unable to query the OSGI service registry for all registered rest endpoints");
            return new ServiceReference[0];
        }
    }

    public static Option<RestService> findRestAnnotation(Class<?> endpointClass) {
        if (endpointClass == null) {
            return Option.none();
        }
        RestService rs = endpointClass.getAnnotation(RestService.class);
        if (rs == null) {
            return RestDocsServlet.findRestAnnotation(endpointClass.getSuperclass());
        }
        return Option.some((Object)rs);
    }
}

