/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.plugin.command;

import java.util.ArrayList;
import java.util.Set;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opencastproject.plugin.PluginManager;

@Service
@Command(scope="opencast", name="plugin-list", description="List available plugins")
public class PluginList
implements Action {
    @Reference
    private FeaturesService featuresService;
    @Reference
    private PluginManager pluginManager;
    @Option(name="--installed", description="Show only installed plugins", required=false, multiValued=false)
    private boolean installed;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    private boolean noFormat;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("State");
        Set<String> plugins = this.installed ? this.pluginManager.listInstalledPlugins() : this.pluginManager.listAvailablePlugins();
        for (String plugin : plugins) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(plugin);
            rowData.add((String)this.featuresService.getState(this.featuresService.getFeature(plugin).getId()));
            Row row = table.addRow();
            row.addContent(rowData);
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

