/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.plugin.command;

import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.karaf.config.core.ConfigRepository;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opencastproject.plugin.PluginManager;
import org.opencastproject.plugin.command.completers.PluginNameCompleter;
import org.opencastproject.plugin.impl.PluginManagerImpl;
import org.osgi.service.cm.Configuration;

@Service
@Command(scope="opencast", name="plugin-disable", description="Disable a plugin with the specified name")
public class PluginDisable
implements Action {
    @Reference
    private ConfigRepository configRepository;
    @Reference
    private PluginManager pluginManager;
    @Argument(name="plugins", description="The name of the plugin to disable.", required=true, multiValued=true)
    @Completion(value=PluginNameCompleter.class)
    private List<String> plugins;
    @Option(name="--persist", description="Persist changes", required=false, multiValued=false)
    private boolean persist = false;

    public Object execute() throws Exception {
        Dictionary properties = this.configRepository.getConfigAdmin().getConfiguration(PluginManagerImpl.class.getName()).getProperties();
        Set<String> available = this.pluginManager.listAvailablePlugins();
        for (String plugin : this.plugins) {
            if (!available.contains(plugin)) {
                throw new IllegalArgumentException("Plugin " + plugin + " is invalid");
            }
            properties.put(plugin, "off");
        }
        if (this.persist) {
            Map propertiesMap = Collections.list(properties.keys()).stream().collect(Collectors.toMap(Function.identity(), properties::get));
            this.configRepository.update(PluginManagerImpl.class.getName(), propertiesMap);
        } else {
            Configuration c = this.configRepository.getConfigAdmin().getConfiguration(PluginManagerImpl.class.getName());
            c.update(properties);
        }
        return null;
    }
}

