/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists.serialization;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.playlists.PlaylistEntry;
import org.opencastproject.playlists.PlaylistEntryType;

@XmlType(name="playlist-entry", namespace="http://playlist.opencastproject.org")
@XmlRootElement(name="playlist-entry", namespace="http://playlist.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class JaxbPlaylistEntry {
    @XmlAttribute
    private long id;
    @XmlElement(name="contentId")
    private String contentId;
    @XmlElement(name="type")
    private PlaylistEntryType type;
    @XmlElementWrapper(name="publications")
    @XmlElement(name="publication")
    private List<Publication> publications = new ArrayList<Publication>();

    void beforeMarshal(Marshaller u) {
        if (this.publications != null && this.publications.isEmpty()) {
            this.publications = null;
        }
    }

    public JaxbPlaylistEntry() {
    }

    public JaxbPlaylistEntry(PlaylistEntry playlistEntry) {
        this();
        this.id = playlistEntry.getId();
        this.contentId = playlistEntry.getContentId();
        this.type = playlistEntry.getType();
    }

    public PlaylistEntry toPlaylistEntry() {
        return new PlaylistEntry(this.id, this.contentId, this.type);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getContentId() {
        return this.contentId;
    }

    public PlaylistEntryType getType() {
        return this.type;
    }

    public void setType(PlaylistEntryType type) {
        this.type = type;
    }

    public List<Publication> getPublications() {
        return this.publications;
    }

    public void setPublications(List<Publication> publications) {
        this.publications = publications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaxbPlaylistEntry jaxbPlaylistEntry = (JaxbPlaylistEntry)o;
        return new EqualsBuilder().append(this.id, jaxbPlaylistEntry.id).append((Object)this.contentId, (Object)jaxbPlaylistEntry.contentId).append((Object)this.type, (Object)jaxbPlaylistEntry.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.contentId).append((Object)this.type).toHashCode();
    }
}

