/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists.serialization;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.playlists.serialization.JaxbPlaylistAccessControlEntry;
import org.opencastproject.playlists.serialization.JaxbPlaylistEntry;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="playlist", namespace="http://playlist.opencastproject.org")
@XmlRootElement(name="playlist", namespace="http://playlist.opencastproject.org")
public class JaxbPlaylist {
    @XmlAttribute
    private String id;
    @XmlElement(name="organization")
    private String organization;
    private List<JaxbPlaylistEntry> entries;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="creator")
    private String creator;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement
    private Date updated;
    private List<JaxbPlaylistAccessControlEntry> accessControlEntries;

    void beforeMarshal(Marshaller u) {
        if (this.entries != null && this.entries.isEmpty()) {
            this.entries = null;
        }
        if (this.accessControlEntries != null && this.accessControlEntries.isEmpty()) {
            this.accessControlEntries = null;
        }
    }

    public JaxbPlaylist() {
    }

    public JaxbPlaylist(Playlist playlist) {
        this();
        this.id = playlist.getId();
        this.organization = playlist.getOrganization();
        this.entries = playlist.getEntries().stream().map(JaxbPlaylistEntry::new).collect(Collectors.toList());
        this.title = playlist.getTitle();
        this.description = playlist.getDescription();
        this.creator = playlist.getCreator();
        this.updated = playlist.getUpdated();
        this.accessControlEntries = playlist.getAccessControlEntries().stream().map(JaxbPlaylistAccessControlEntry::new).collect(Collectors.toList());
    }

    public Playlist toPlaylist() {
        return new Playlist(this.id, this.organization, Optional.ofNullable(this.entries).orElseGet(Collections::emptyList).stream().map(JaxbPlaylistEntry::toPlaylistEntry).collect(Collectors.toList()), this.title, this.description, this.creator, this.updated, Optional.ofNullable(this.accessControlEntries).orElseGet(Collections::emptyList).stream().map(JaxbPlaylistAccessControlEntry::toPlaylistAccessControlEntry).collect(Collectors.toList()));
    }

    public List<JaxbPlaylistEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<JaxbPlaylistEntry> entries) {
        for (JaxbPlaylistEntry entry : entries) {
            if (this.entries.contains(entry)) continue;
            entry.setId(0L);
        }
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaxbPlaylist jaxbPlaylist = (JaxbPlaylist)o;
        return new EqualsBuilder().append((Object)this.id, (Object)jaxbPlaylist.id).append((Object)this.organization, (Object)jaxbPlaylist.organization).append(this.entries, jaxbPlaylist.entries).append((Object)this.title, (Object)jaxbPlaylist.title).append((Object)this.description, (Object)jaxbPlaylist.description).append((Object)this.creator, (Object)jaxbPlaylist.creator).append((Object)this.updated, (Object)jaxbPlaylist.updated).append(this.accessControlEntries, jaxbPlaylist.accessControlEntries).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.organization).append(this.entries).append((Object)this.title).append((Object)this.description).append((Object)this.creator).append((Object)this.updated).append(this.accessControlEntries).toHashCode();
    }

    static class DateAdapter
    extends XmlAdapter<Long, Date> {
        DateAdapter() {
        }

        public Long marshal(Date v) throws Exception {
            return v == null ? null : Long.valueOf(v.getTime());
        }

        public Date unmarshal(Long v) throws Exception {
            return v == null ? null : new Date(v);
        }
    }
}

