/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists.persistence;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.playlists.persistence.PlaylistDatabaseException;
import org.opencastproject.playlists.persistence.PlaylistDatabaseService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PlaylistDatabaseService.class}, property={"service.description=Playlist Database Service"})
public class PlaylistDatabaseServiceImpl
implements PlaylistDatabaseService {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.playlists";
    private static final Logger logger = LoggerFactory.getLogger(PlaylistDatabaseServiceImpl.class);
    private EntityManagerFactory emf;
    private DBSessionFactory dbSessionFactory;
    private DBSession db;
    protected SecurityService securityService;

    @Reference(target="(osgi.unit.name=org.opencastproject.playlists)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference(name="security-service")
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for playlists");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Override
    public Playlist getPlaylist(String playlistId) throws NotFoundException, PlaylistDatabaseException {
        return this.getPlaylist(playlistId, this.securityService.getOrganization().getId());
    }

    @Override
    public Playlist getPlaylist(String playlistId, String orgId) throws NotFoundException, PlaylistDatabaseException {
        try {
            return (Playlist)this.db.execTxChecked(em -> {
                Optional<Playlist> playlist = this.getPlaylistById(playlistId, orgId).apply((EntityManager)em);
                if (playlist.isEmpty()) {
                    throw new NotFoundException("No playlist with id=" + playlistId + " exists");
                }
                return playlist.get();
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not retrieve playlist with ID '{}'", (Object)playlistId, (Object)e);
            throw new PlaylistDatabaseException(e);
        }
    }

    @Override
    public List<Playlist> getPlaylists(int limit, int offset, SortCriterion sortCriterion) throws PlaylistDatabaseException {
        try {
            return (List)this.db.exec(em -> {
                CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Playlist.class);
                Root from = criteriaQuery.from(Playlist.class);
                CriteriaQuery select = criteriaQuery.select((Selection)from).where((Expression)criteriaBuilder.isNull((Expression)from.get("deletionDate")));
                if (sortCriterion.getOrder().equals((Object)SortCriterion.Order.Ascending)) {
                    criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)from.get(sortCriterion.getFieldName()))});
                } else if (sortCriterion.getOrder().equals((Object)SortCriterion.Order.Descending)) {
                    criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)from.get(sortCriterion.getFieldName()))});
                }
                TypedQuery allQuery = em.createQuery(select);
                allQuery.setMaxResults(limit);
                allQuery.setFirstResult(offset);
                return allQuery.getResultList();
            });
        }
        catch (Exception e) {
            throw new PlaylistDatabaseException("Error fetching playlists from database", e);
        }
    }

    @Override
    public List<Playlist> getAllForAdministrativeRead(Date startDate, Date endDate, int limit) throws PlaylistDatabaseException {
        try {
            return (List)this.db.exec(em -> {
                CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Playlist.class);
                Root from = criteriaQuery.from(Playlist.class);
                String org = this.securityService.getOrganization().getId();
                CriteriaQuery select = criteriaQuery.select((Selection)from).where(new Predicate[]{criteriaBuilder.greaterThanOrEqualTo((Expression)from.get("updated"), (Comparable)startDate), criteriaBuilder.lessThan((Expression)from.get("updated"), (Comparable)endDate), criteriaBuilder.equal((Expression)from.get("organization"), (Object)org)}).orderBy(new Order[]{criteriaBuilder.asc((Expression)from.get("updated"))});
                return em.createQuery(select).setMaxResults(limit).getResultList();
            });
        }
        catch (Exception e) {
            throw new PlaylistDatabaseException("Error fetching playlists from database", e);
        }
    }

    @Override
    public Playlist updatePlaylist(Playlist playlist, String orgId) throws PlaylistDatabaseException {
        try {
            return (Playlist)this.db.execTx(em -> {
                Optional<Playlist> fromDb = this.getPlaylistById(playlist.getId(), orgId).apply((EntityManager)em);
                playlist.setUpdated(new Date());
                if (!fromDb.isEmpty()) {
                    return (Playlist)em.merge((Object)playlist);
                }
                em.persist((Object)playlist);
                return playlist;
            });
        }
        catch (Exception e) {
            throw new PlaylistDatabaseException("Could not update playlist with ID '" + playlist.getId() + "'", e);
        }
    }

    @Override
    public Playlist deletePlaylist(Playlist playlist, String orgId) throws PlaylistDatabaseException {
        try {
            return (Playlist)this.db.execTx(em -> {
                Optional<Playlist> fromDb = this.getPlaylistById(playlist.getId(), orgId).apply((EntityManager)em);
                if (fromDb.isPresent()) {
                    Date now = new Date();
                    playlist.setUpdated(now);
                    playlist.setDeletionDate(now);
                    em.merge((Object)playlist);
                }
                logger.debug("Playlist with id {} was deleted.", (Object)playlist.getId());
                return playlist;
            });
        }
        catch (Exception e) {
            throw new PlaylistDatabaseException("Could not delete playlist with ID '" + playlist.getId() + "'", e);
        }
    }

    protected Function<EntityManager, Optional<Playlist>> getPlaylistById(String playlistId, String orgId) {
        return em -> this.getPotentiallyDeletedPlaylist(playlistId, orgId).apply((EntityManager)em).filter(e -> !e.isDeleted());
    }

    protected Function<EntityManager, Optional<Playlist>> getPotentiallyDeletedPlaylist(String playlistId, String orgId) {
        return Queries.namedQuery.findOpt("Playlist.findById", Playlist.class, new Object[]{Pair.of((Object)"id", (Object)playlistId), Pair.of((Object)"organizationId", (Object)orgId)});
    }
}

