/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.playlists.PlaylistEntryType;

@Entity(name="PlaylistEntry")
@Table(name="oc_playlist_entry")
public class PlaylistEntry {
    @Id
    @GeneratedValue
    @Column(name="id")
    private long id;
    @Column(name="content_id")
    private String contentId;
    @Column(name="type")
    private PlaylistEntryType type;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="playlist_id", nullable=false)
    private Playlist playlist;

    public PlaylistEntry() {
    }

    public PlaylistEntry(String contentId, PlaylistEntryType type) {
        this.contentId = contentId;
        this.type = type;
    }

    public PlaylistEntry(long id, String contentId, PlaylistEntryType type) {
        this.id = id;
        this.contentId = contentId;
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public PlaylistEntryType getType() {
        return this.type;
    }

    public void setType(PlaylistEntryType type) {
        this.type = type;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaylistEntry that = (PlaylistEntry)o;
        return this.getId() != 0L && this.getId() == that.getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

