/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.oaipmh.server.remote;

import java.io.IOException;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.opencastproject.oaipmh.server.OaiPmhServerInfo;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.HttpUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.functions.Misc;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={OaiPmhServerInfo.class}, property={"service.description=OAI-PMH server info remote proxy"})
public class OaiPmhServerInfoRemoteImpl
extends RemoteBase
implements OaiPmhServerInfo {
    private static final Logger logger = LoggerFactory.getLogger(OaiPmhServerInfoRemoteImpl.class);
    public static final String SERVICE_TYPE = "org.opencastproject.oaipmhinfo";

    public OaiPmhServerInfoRemoteImpl() {
        super(SERVICE_TYPE);
    }

    public boolean hasRepo(String id) {
        for (HttpResponse r : Option.option((Object)this.getResponse((HttpRequestBase)HttpUtil.get((String)UrlSupport.concat((String)"hasrepo", (String)id), (Tuple[])new Tuple[0]), new Integer[]{200}))) {
            try {
                return Boolean.parseBoolean(EntityUtils.toString((HttpEntity)r.getEntity()));
            }
            catch (IOException e) {
                logger.error("Cannot contact remote service", (Throwable)e);
                Misc.chuck((Throwable)e);
            }
        }
        return false;
    }

    public String getMountPoint() {
        Iterator iterator = Option.option((Object)this.getResponse((HttpRequestBase)HttpUtil.get((String)"mountpoint", (Tuple[])new Tuple[0]), new Integer[]{200})).iterator();
        if (iterator.hasNext()) {
            HttpResponse r = (HttpResponse)iterator.next();
            try {
                return EntityUtils.toString((HttpEntity)r.getEntity());
            }
            catch (IOException e) {
                logger.error("Cannot contact remote service", (Throwable)e);
                return (String)Misc.chuck((Throwable)e);
            }
        }
        throw new RuntimeException("Cannot contact remote service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

