/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.notification;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Workflow Operation that POSTs MediaPackages via HTTP", "workflow.operation=post-mediapackage"})
public class MediaPackagePostOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MediaPackagePostOperationHandler.class);
    private SearchService searchService;

    @Reference
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage workflowMP;
        block11: {
            WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
            Configuration config = new Configuration(currentOperation);
            MediaPackage mp = workflowMP = workflowInstance.getMediaPackage();
            if (config.mpFromSearch()) {
                logger.info("Getting media package from search service");
                try {
                    mp = this.searchService.get(mp.getIdentifier().toString());
                }
                catch (UnauthorizedException | NotFoundException e) {
                    throw new WorkflowOperationException("could not get media package " + String.valueOf(mp) + " from search service.");
                }
            }
            logger.info("Submitting {} ({}) as {} to {}", new Object[]{mp.getTitle(), mp.getIdentifier(), config.getFormat().name(), config.getUrl()});
            try {
                CloseableHttpClient client;
                CloseableHttpResponse response;
                int status;
                String mpStr = config.getFormat() == Configuration.Format.JSON ? MediaPackageParser.getAsJSON((MediaPackage)mp) : MediaPackageParser.getAsXml((MediaPackage)mp);
                if (config.debug()) {
                    logger.info(mpStr);
                }
                ArrayList<Object> data = new ArrayList<Object>();
                data.add(new BasicNameValuePair("mediapackage", mpStr));
                data.addAll(config.getAdditionalFields());
                HttpPost post = new HttpPost(config.getUrl());
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(data, config.getEncoding()));
                HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                if (config.authenticate()) {
                    URL targetUrl = config.getUrl().toURL();
                    BasicCredentialsProvider provider = new BasicCredentialsProvider();
                    provider.setCredentials(new AuthScope(targetUrl.getHost(), targetUrl.getPort()), (Credentials)config.getCredentials());
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                }
                if ((status = (response = (client = clientBuilder.build()).execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) >= 200 && status < 300) {
                    if (config.debug()) {
                        logger.info("Successfully submitted '{}' ({}) to {}: {}", new Object[]{mp.getTitle(), mp.getIdentifier(), config.getUrl(), status});
                    }
                    break block11;
                }
                if (status == 418) {
                    logger.warn("Submitted '{}' ({}) to {}: The target claims to be a teapot. The Reason for this is probably an insane developer. Go and help that person!", new Object[]{mp.getTitle(), mp.getIdentifier(), config.getUrl()});
                    break block11;
                }
                throw new WorkflowOperationException("Failed to submit \"" + mp.getTitle() + "\" (" + mp.getIdentifier().toString() + "), " + config.getUrl().toString() + " answered with: " + Integer.toString(status));
            }
            catch (Exception e) {
                if (e instanceof WorkflowOperationException) {
                    throw (WorkflowOperationException)e;
                }
                throw new WorkflowOperationException((Throwable)e);
            }
        }
        return this.createResult(workflowMP, WorkflowOperationResult.Action.CONTINUE);
    }

    private static class Configuration {
        public static final String PROPERTY_URL = "url";
        public static final String PROPERTY_FORMAT = "format";
        public static final String PROPERTY_ENCODING = "encoding";
        public static final String PROPERTY_AUTH = "auth.enabled";
        public static final String PROPERTY_AUTHUSER = "auth.username";
        public static final String PROPERTY_AUTHPASSWD = "auth.password";
        public static final String PROPERTY_DEBUG = "debug";
        public static final String PROPERTY_MEDIAPACKAGE_TYPE = "mediapackage.type";
        private URI url;
        private Format format = Format.XML;
        private String encoding = "UTF-8";
        private boolean authenticate = false;
        private UsernamePasswordCredentials credentials = null;
        private List<NameValuePair> additionalFields = new ArrayList<NameValuePair>();
        private boolean debug = false;
        private boolean mpFromSearch = true;

        Configuration(WorkflowOperationInstance operation) throws WorkflowOperationException {
            try {
                String auth;
                Set keys = operation.getConfigurationKeys();
                if (!keys.contains(PROPERTY_URL)) {
                    throw new IllegalArgumentException("No target URL provided.");
                }
                this.url = new URI(operation.getConfiguration(PROPERTY_URL));
                if (keys.contains(PROPERTY_FORMAT)) {
                    this.format = Format.valueOf(operation.getConfiguration(PROPERTY_FORMAT).toUpperCase());
                }
                if (keys.contains(PROPERTY_ENCODING)) {
                    this.encoding = operation.getConfiguration(PROPERTY_ENCODING);
                }
                if (keys.contains(PROPERTY_AUTH) && !"NO".equals(auth = operation.getConfiguration(PROPERTY_AUTH).toUpperCase()) && !"FALSE".equals(auth)) {
                    String username = operation.getConfiguration(PROPERTY_AUTHUSER);
                    String password = operation.getConfiguration(PROPERTY_AUTHPASSWD);
                    if (username == null || password == null) {
                        throw new WorkflowOperationException("Username and Password must be provided for authentication!");
                    }
                    this.credentials = new UsernamePasswordCredentials(username, password);
                    this.authenticate = true;
                }
                if (keys.contains(PROPERTY_DEBUG)) {
                    String debugstr = operation.getConfiguration(PROPERTY_DEBUG).trim().toUpperCase();
                    boolean bl = this.debug = "YES".equals(debugstr) || "TRUE".equals(debugstr);
                }
                if (keys.contains(PROPERTY_MEDIAPACKAGE_TYPE)) {
                    String cfgval = operation.getConfiguration(PROPERTY_MEDIAPACKAGE_TYPE).trim().toUpperCase();
                    this.mpFromSearch = "SEARCH".equals(cfgval);
                }
                for (String key : operation.getConfigurationKeys()) {
                    if (!key.startsWith("+")) continue;
                    String value = operation.getConfiguration(key);
                    this.additionalFields.add((NameValuePair)new BasicNameValuePair(key.substring(1), value));
                }
            }
            catch (Exception e) {
                throw new WorkflowOperationException("Faild to configure operation instance.", (Throwable)e);
            }
        }

        public URI getUrl() {
            return this.url;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean authenticate() {
            return this.authenticate;
        }

        public UsernamePasswordCredentials getCredentials() {
            return this.credentials;
        }

        public List<NameValuePair> getAdditionalFields() {
            return this.additionalFields;
        }

        public boolean debug() {
            return this.debug;
        }

        public boolean mpFromSearch() {
            return this.mpFromSearch;
        }

        public static enum Format {
            XML,
            JSON;

        }
    }
}

