/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opencastproject.metadata.mpeg7.MultimediaContent;
import org.opencastproject.metadata.mpeg7.MultimediaContentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultimediaContentImpl<T extends MultimediaContentType>
implements MultimediaContent<T> {
    protected Map<String, T> content = new HashMap<String, T>();
    protected MultimediaContent.Type type = null;

    public MultimediaContentImpl(MultimediaContent.Type type) {
        this.type = type;
    }

    public void add(T c) {
        if (c == null) {
            throw new IllegalArgumentException("Multimedia content must not be null");
        }
        if (this.content.containsKey(c.getId())) {
            throw new IllegalStateException("Duplicate content id detected: " + c.getId());
        }
        this.content.put(c.getId(), c);
    }

    public T remove(T c) {
        return (T)((MultimediaContentType)this.content.remove(c.getId()));
    }

    public T remove(String id) {
        return (T)((MultimediaContentType)this.content.remove(id));
    }

    @Override
    public Iterator<T> elements() {
        return this.content.values().iterator();
    }

    @Override
    public T getElementById(String id) {
        return (T)((MultimediaContentType)this.content.get(id));
    }

    @Override
    public MultimediaContent.Type getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.content.size();
    }

    public Node toXml(Document document) {
        Element node = document.createElement("MultimediaContent");
        node.setAttribute("xsi:type", this.type.toString());
        for (MultimediaContentType contentElement : this.content.values()) {
            node.appendChild(contentElement.toXml(document));
        }
        return node;
    }
}

