/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.Formatter;
import org.opencastproject.metadata.mpeg7.MediaDuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MediaDurationImpl
implements MediaDuration {
    private static final String TimeDelimiter = "T";
    private static final String DayDelimiter = "D";
    private static final String HourDelimiter = "H";
    private static final String MinuteDelimiter = "M";
    private static final String SecondsDelimiter = "S";
    private static final String FractionDelimiter = "N";
    private static final String FPSDelimiter = "F";
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_SECOND = 1000L;
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int fractions = 0;
    private int fractionsPerSecond = 0;

    public MediaDurationImpl() {
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.fractions = 0;
        this.fractionsPerSecond = 0;
    }

    public MediaDurationImpl(long milliseconds) {
        this.fractions = (int)(milliseconds % 1000L);
        this.seconds = (int)(milliseconds / 1000L % 60L);
        this.minutes = (int)(milliseconds / 60000L % 60L);
        this.hours = (int)(milliseconds / 3600000L % 24L);
        this.days = (int)(milliseconds / 86400000L);
        this.hours += this.days * 24;
        this.fractionsPerSecond = 1000;
    }

    public static MediaDuration parseDuration(String text) throws IllegalArgumentException {
        MediaDurationImpl mediaDuration = new MediaDurationImpl();
        mediaDuration.parse(text);
        return mediaDuration;
    }

    public void parse(String text) throws IllegalArgumentException {
        int index = 0;
        if (!text.startsWith("P") || !text.contains(TimeDelimiter)) {
            throw new IllegalArgumentException();
        }
        if (text.contains(DayDelimiter)) {
            this.days = Integer.parseInt(text.substring(1, text.indexOf(DayDelimiter)));
        }
        index = text.indexOf(TimeDelimiter);
        if (text.contains(HourDelimiter)) {
            this.hours = Short.parseShort(text.substring(index + 1, text.indexOf(HourDelimiter)));
            index = text.indexOf(HourDelimiter);
        }
        if (text.contains(MinuteDelimiter)) {
            this.minutes = Short.parseShort(text.substring(index + 1, text.indexOf(MinuteDelimiter)));
            index = text.indexOf(MinuteDelimiter);
        }
        if (text.contains(SecondsDelimiter)) {
            this.seconds = Short.parseShort(text.substring(index + 1, text.indexOf(SecondsDelimiter)));
            index = text.indexOf(SecondsDelimiter);
        }
        if (text.contains(FractionDelimiter)) {
            this.fractions = Integer.parseInt(text.substring(index + 1, text.indexOf(FractionDelimiter)));
            index = text.indexOf(FractionDelimiter);
        }
        if (text.contains(FPSDelimiter)) {
            this.fractionsPerSecond = Integer.parseInt(text.substring(index + 1, text.indexOf(FPSDelimiter)));
        }
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public int getFractions() {
        return this.fractions;
    }

    @Override
    public int getFractionsPerSecond() {
        return this.fractionsPerSecond;
    }

    @Override
    public int getHours() {
        return this.hours;
    }

    @Override
    public int getMinutes() {
        return this.minutes;
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    public void setDayDuration(int days) {
        this.days = days;
    }

    public void setFractionDuration(int fractions) {
        this.fractions = fractions;
    }

    public void setFractionsPerSecond(int fractionsPerSecond) {
        this.fractionsPerSecond = fractionsPerSecond;
    }

    public void setHourDuration(short hours) {
        this.hours = hours;
    }

    public void setMinuteDuration(short minutes) {
        this.minutes = minutes;
    }

    public void setSecondDuration(short seconds) {
        this.seconds = seconds;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("PT");
        Formatter f = new Formatter(returnString);
        if (this.hours != 0) {
            f.format("%02dH", this.hours);
        }
        if (this.minutes != 0) {
            f.format("%02dM", this.minutes);
        }
        if (this.seconds != 0) {
            f.format("%02dS", this.seconds);
        }
        if (this.fractionsPerSecond != 0) {
            f.format("%dN%dF", this.fractions, this.fractionsPerSecond);
        }
        f.close();
        return returnString.toString();
    }

    @Override
    public long getDurationInMilliseconds() {
        long s = (long)this.seconds * 1000L;
        s += (long)this.minutes * 60000L;
        s += (long)this.hours * 3600000L;
        s += (long)this.days * 86400000L;
        if (this.fractionsPerSecond > 0) {
            s += (long)this.fractions * 1000L / (long)this.fractionsPerSecond;
        }
        return s;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaDuration) {
            return ((MediaDuration)obj).getDurationInMilliseconds() == this.getDurationInMilliseconds();
        }
        return false;
    }

    public Node toXml(Document document) {
        Element node = document.createElement("MediaDuration");
        node.setTextContent(this.toString());
        return node;
    }
}

