/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.api.util;

import java.util.Date;

public abstract class Interval {
    private Interval() {
    }

    public static Interval boundedInterval(final Date leftBound, final Date rightBound) {
        return new Interval(){

            @Override
            public boolean isLeftInfinite() {
                return false;
            }

            @Override
            public boolean isRightInfinite() {
                return false;
            }

            @Override
            public <A> A fold(Match<A> visitor) {
                return visitor.bounded(leftBound, rightBound);
            }
        };
    }

    public static Interval rightBoundedInterval(final Date rightBound) {
        return new Interval(){

            @Override
            public boolean isLeftInfinite() {
                return true;
            }

            @Override
            public boolean isRightInfinite() {
                return false;
            }

            @Override
            public <A> A fold(Match<A> visitor) {
                return visitor.leftInfinite(rightBound);
            }
        };
    }

    public static Interval leftBoundedInterval(final Date leftBound) {
        return new Interval(){

            @Override
            public boolean isLeftInfinite() {
                return false;
            }

            @Override
            public boolean isRightInfinite() {
                return true;
            }

            @Override
            public <A> A fold(Match<A> visitor) {
                return visitor.rightInfinite(leftBound);
            }
        };
    }

    public static Interval fromValues(Date leftBound, Date rightBound) {
        if (leftBound != null && rightBound != null) {
            return Interval.boundedInterval(leftBound, rightBound);
        }
        if (leftBound != null) {
            return Interval.leftBoundedInterval(leftBound);
        }
        if (rightBound != null) {
            return Interval.rightBoundedInterval(rightBound);
        }
        throw new IllegalArgumentException("Please give at least one bound");
    }

    public boolean isBounded() {
        return !this.isLeftInfinite() && !this.isRightInfinite();
    }

    public abstract boolean isLeftInfinite();

    public abstract boolean isRightInfinite();

    public abstract <A> A fold(Match<A> var1);

    public static interface Match<A> {
        public A bounded(Date var1, Date var2);

        public A leftInfinite(Date var1);

        public A rightInfinite(Date var1);
    }
}

