/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.mattermost.notification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Mattermost Notification Operation Handler", "workflow.operation=mattermost-notify"})
public class MattermostNotificationWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    public static final String OPT_URL_PATH = "url";
    public static final String OPT_NOTIFICATION_MESSAGE = "message";
    public static final String OPT_METHOD = "method";
    public static final String OPT_MAX_RETRY = "max-retry";
    public static final String OPT_TIMEOUT = "timeout";
    public static final String HTTP_PARAM_PAYLOAD = "payload";
    public static final String POST = "post";
    public static final String PUT = "put";
    private static final Logger logger = LoggerFactory.getLogger(MattermostNotificationWorkflowOperationHandler.class);
    private static final int DEFAULT_MAX_RETRY = 5;
    private static final int DEFAULT_TIMEOUT = 10000;
    public static final int INITIAL_SLEEP_TIME = 10000;
    public static final int SLEEP_SCALE_FACTOR = 2;
    private static Gson gson = new GsonBuilder().create();

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        HttpPost request;
        logger.debug("Running HTTP notification workflow operation on workflow {}", (Object)workflowInstance.getId());
        int maxRetry = 5;
        int timeout = 10000;
        String urlPath = this.getConfig(workflowInstance, OPT_URL_PATH);
        String notificationMessage = this.getConfig(workflowInstance, OPT_NOTIFICATION_MESSAGE, null);
        String method = this.getConfig(workflowInstance, OPT_METHOD, POST);
        String maxRetryOpt = this.getConfig(workflowInstance, OPT_MAX_RETRY, null);
        String timeoutOpt = this.getConfig(workflowInstance, OPT_TIMEOUT, null);
        if (timeoutOpt != null) {
            timeout = Integer.parseInt(timeoutOpt) * 1000;
        }
        if (maxRetryOpt != null) {
            maxRetry = Integer.parseInt(maxRetryOpt);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)POST, (CharSequence)method)) {
            request = new HttpPost(urlPath);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)PUT, (CharSequence)method)) {
            request = new HttpPut(urlPath);
        } else {
            throw new WorkflowOperationException("The configuration key 'method' only supports 'post' and 'put'");
        }
        logger.debug("Request will be sent using the '{}' method", (Object)method);
        MediaPackage mp = workflowInstance.getMediaPackage();
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (notificationMessage != null) {
                params.add(new BasicNameValuePair(HTTP_PARAM_PAYLOAD, this.makeJson(notificationMessage, workflowInstance, mp)));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WorkflowOperationException("Error encoding the event parameter as form parameter", (Throwable)e);
        }
        if (!this.executeRequest((HttpUriRequest)request, maxRetry, timeout, 10000)) {
            throw new WorkflowOperationException(String.format("Notification could not be delivered to %s", urlPath));
        }
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    private String makeJson(String s, WorkflowInstance workflowInstance, MediaPackage mediaPackage) {
        s = s.replace("%t", this.checkIfNull(workflowInstance.getTitle(), "Title"));
        s = s.replace("%i", String.valueOf(workflowInstance.getId()));
        s = s.replace("%s", String.valueOf(workflowInstance.getState()));
        s = s.replace("%o", String.valueOf(workflowInstance.getCurrentOperation().getId()));
        s = s.replace("%I", this.checkIfNull(mediaPackage.getIdentifier(), "Mediapackage-ID"));
        s = s.replace("%T", this.checkIfNull(mediaPackage.getTitle(), "Mediapackage-Title"));
        s = s.replace("%c", this.checkIfNull(mediaPackage.getContributors(), "Contributors"));
        s = s.replace("%C", this.checkIfNull(mediaPackage.getCreators(), "Creators"));
        s = s.replace("%D", this.checkIfNull(mediaPackage.getDate(), "Date"));
        s = s.replace("%d", this.checkIfNull(mediaPackage.getDuration(), "Duration"));
        s = s.replace("%l", this.checkIfNull(mediaPackage.getLanguage(), "Language"));
        s = s.replace("%L", this.checkIfNull(mediaPackage.getLicense(), "License"));
        s = s.replace("%S", this.checkIfNull(mediaPackage.getSeriesTitle(), "Series-Title"));
        JsonObject json = new JsonObject();
        json.addProperty("text", s);
        return gson.toJson((JsonElement)json);
    }

    private String checkIfNull(Object o, String s) {
        if (o == null) {
            return s + "not defined";
        }
        if (o instanceof String[]) {
            return StringUtils.join((Object[])((String[])o), (char)',');
        }
        return o.toString();
    }

    private boolean executeRequest(HttpUriRequest request, int maxAttempts, int timeout, int sleepTime) {
        CloseableHttpResponse response;
        logger.debug("Executing notification request on target {}, {} attempts left", (Object)request.getURI(), (Object)maxAttempts);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(config).build();
        try {
            response = httpClient.execute(request);
        }
        catch (ClientProtocolException e) {
            logger.error("Protocol error during execution of query on target {}", (Object)request.getURI(), (Object)e);
            return false;
        }
        catch (IOException e) {
            logger.error("I/O error during execution of query on target {}", (Object)request.getURI(), (Object)e);
            return false;
        }
        Integer statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 204 || statusCode == 202) {
            logger.debug("Request successfully executed on target {}, status code: {}", (Object)request.getURI(), (Object)statusCode);
            return true;
        }
        if (maxAttempts > 1) {
            logger.debug("Request failed on target {}, status code: {}, will retry in {} seconds", new Object[]{request.getURI(), statusCode, sleepTime / 1000});
            try {
                Thread.sleep(sleepTime);
                return this.executeRequest(request, --maxAttempts, timeout, sleepTime * 2);
            }
            catch (InterruptedException e) {
                logger.error("Error during sleep time before new notification request try", (Throwable)e);
                return false;
            }
        }
        logger.error("Request failed on target {}, status code: {}, no more attempt.", (Object)request.getURI(), (Object)statusCode);
        return false;
    }
}

