/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.liveschedule.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.liveschedule.api.LiveScheduleException;
import org.opencastproject.liveschedule.api.LiveScheduleService;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.mediapackage.track.AbstractStreamImpl;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.mediapackage.track.VideoStreamImpl;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={LiveScheduleService.class}, property={"service.description=Live Schedule Service"})
public class LiveScheduleServiceImpl
implements LiveScheduleService {
    static final String SERVER_URL_PROPERTY = "org.opencastproject.server.url";
    static final String ENGAGE_URL_PROPERTY = "org.opencastproject.engage.ui.url";
    static final String PLAYER_PATH = "/play/";
    private static final String DEFAULT_STREAM_MIME_TYPE = "video/mp4";
    private static final String DEFAULT_STREAM_RESOLUTION = "1920x1080";
    private static final String DEFAULT_STREAM_NAME = "live-stream";
    private static final String DEFAULT_LIVE_TARGET_FLAVORS = "presenter/delivery";
    static final String DEFAULT_LIVE_DISTRIBUTION_SERVICE = "download";
    public static final String CA_PROPERTY_RESOLUTION_URL_PREFIX = "capture.device.live.resolution.";
    public static final String REPLACE_ID = "id";
    public static final String REPLACE_FLAVOR = "flavor";
    public static final String REPLACE_CA_NAME = "caName";
    public static final String REPLACE_RESOLUTION = "resolution";
    public static final String LIVE_STREAMING_URL = "live.streamingUrl";
    public static final String LIVE_STREAM_NAME = "live.streamName";
    public static final String LIVE_STREAM_MIME_TYPE = "live.mimeType";
    public static final String LIVE_STREAM_RESOLUTION = "live.resolution";
    public static final String LIVE_TARGET_FLAVORS = "live.targetFlavors";
    public static final String LIVE_DISTRIBUTION_SERVICE = "live.distributionService";
    public static final String LIVE_PUBLISH_STREAMING = "live.publishStreaming";
    private static final MediaPackageElementFlavor[] publishFlavors = new MediaPackageElementFlavor[]{MediaPackageElements.EPISODE, MediaPackageElements.SERIES, MediaPackageElements.XACML_POLICY_EPISODE, MediaPackageElements.XACML_POLICY_SERIES};
    private static final Logger logger = LoggerFactory.getLogger(LiveScheduleServiceImpl.class);
    private String liveStreamingUrl;
    private String streamName;
    private String streamMimeType;
    private String[] streamResolution;
    private MediaPackageElementFlavor[] liveFlavors;
    private String serverUrl;
    private Cache<String, Version> snapshotVersionCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private List<String> publishedStreamingFormats = null;
    private String systemUserName;
    private DownloadDistributionService downloadDistributionService;
    private SearchService searchService;
    private SeriesService seriesService;
    private DublinCoreCatalogService dublinCoreService;
    private CaptureAgentStateService captureAgentService;
    private ServiceRegistry serviceRegistry;
    private Workspace workspace;
    private AssetManager assetManager;
    private AuthorizationService authService;
    private OrganizationDirectoryService organizationService;
    private SecurityService securityService;
    private long jobPollingInterval = 5000L;
    private SimpleElementSelector publishElementSelector;

    @Activate
    protected void activate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        this.serverUrl = StringUtils.trimToNull((String)bundleContext.getProperty(SERVER_URL_PROPERTY));
        if (this.serverUrl == null) {
            logger.warn("Server url was not set in '{}'", (Object)SERVER_URL_PROPERTY);
        } else {
            logger.info("Server url is {}", (Object)this.serverUrl);
        }
        this.systemUserName = bundleContext.getProperty("org.opencastproject.security.digest.user");
        Dictionary properties = context.getProperties();
        if (!StringUtils.isBlank((CharSequence)((String)properties.get(LIVE_STREAMING_URL)))) {
            this.liveStreamingUrl = StringUtils.trimToEmpty((String)((String)properties.get(LIVE_STREAMING_URL)));
            logger.info("Live streaming server url is {}", (Object)this.liveStreamingUrl);
        } else {
            logger.info("Live streaming url not set in '{}'. Streaming urls must be provided by capture agent properties.", (Object)LIVE_STREAMING_URL);
        }
        this.streamName = !StringUtils.isBlank((CharSequence)((String)properties.get(LIVE_STREAM_NAME))) ? StringUtils.trimToEmpty((String)((String)properties.get(LIVE_STREAM_NAME))) : DEFAULT_STREAM_NAME;
        this.streamMimeType = !StringUtils.isBlank((CharSequence)((String)properties.get(LIVE_STREAM_MIME_TYPE))) ? StringUtils.trimToEmpty((String)((String)properties.get(LIVE_STREAM_MIME_TYPE))) : DEFAULT_STREAM_MIME_TYPE;
        String resolution = null;
        resolution = !StringUtils.isBlank((CharSequence)((String)properties.get(LIVE_STREAM_RESOLUTION))) ? StringUtils.trimToEmpty((String)((String)properties.get(LIVE_STREAM_RESOLUTION))) : DEFAULT_STREAM_RESOLUTION;
        this.streamResolution = resolution.split(",");
        String flavors = null;
        flavors = !StringUtils.isBlank((CharSequence)((String)properties.get(LIVE_TARGET_FLAVORS))) ? StringUtils.trimToEmpty((String)((String)properties.get(LIVE_TARGET_FLAVORS))) : DEFAULT_LIVE_TARGET_FLAVORS;
        String[] flavorArray = StringUtils.split((String)flavors, (String)",");
        this.liveFlavors = new MediaPackageElementFlavor[flavorArray.length];
        int i = 0;
        for (String string : flavorArray) {
            this.liveFlavors[i++] = MediaPackageElementFlavor.parseFlavor((String)string);
        }
        this.publishedStreamingFormats = Arrays.asList(Optional.ofNullable(StringUtils.split((String)((String)properties.get(LIVE_PUBLISH_STREAMING)), (String)",")).orElse(new String[0]));
        this.publishElementSelector = new SimpleElementSelector();
        for (String string : publishFlavors) {
            this.publishElementSelector.addFlavor((MediaPackageElementFlavor)string);
        }
        logger.info("Configured live stream name: {}, mime type: {}, resolution: {}, target flavors: {}", new Object[]{this.streamName, this.streamMimeType, resolution, flavors});
    }

    public boolean createOrUpdateLiveEvent(String mpId, DublinCoreCatalog episodeDC) throws LiveScheduleException {
        MediaPackage mp = this.getMediaPackageFromSearch(mpId);
        if (mp == null) {
            DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((String)episodeDC.getFirst(DublinCore.PROPERTY_TEMPORAL));
            if (period.getEnd().getTime() <= System.currentTimeMillis()) {
                logger.info("Live media package {} not created in search index because event is already past (end date: {})", (Object)mpId, (Object)period.getEnd());
                return false;
            }
            return this.createLiveEvent(mpId, episodeDC);
        }
        if (!mp.isLive()) {
            logger.info("Media package {} is in search index but not live so not updating it.", (Object)mpId);
            return false;
        }
        return this.updateLiveEvent(mp, episodeDC);
    }

    public boolean deleteLiveEvent(String mpId) throws LiveScheduleException {
        MediaPackage mp = this.getMediaPackageFromSearch(mpId);
        if (mp == null) {
            logger.debug("Live media package {} not found in search index", (Object)mpId);
            return false;
        }
        if (!mp.isLive()) {
            logger.info("Media package {} is not live. Not retracting.", (Object)mpId);
            return false;
        }
        return this.retractLiveEvent(mp);
    }

    public boolean updateLiveEventAcl(String mpId, AccessControlList acl) throws LiveScheduleException {
        MediaPackage previousMp = this.getMediaPackageFromSearch(mpId);
        if (previousMp != null) {
            if (!previousMp.isLive()) {
                logger.info("Media package {} is not live. Not updating acl.", (Object)mpId);
                return false;
            }
            MediaPackage newMp = this.replaceAndDistributeAcl(previousMp, acl);
            this.publishToSearch(newMp);
            this.retractPreviousElements(previousMp, newMp);
            logger.info("Updated live acl for media package {}", (Object)newMp);
            return true;
        }
        return false;
    }

    boolean createLiveEvent(String mpId, DublinCoreCatalog episodeDC) throws LiveScheduleException {
        try {
            logger.info("Creating live media package {}", (Object)mpId);
            Snapshot snapshot = this.getSnapshotFromArchive(mpId);
            MediaPackage tmpMp = (MediaPackage)snapshot.getMediaPackage().clone();
            this.setDurationForMediaPackage(tmpMp, episodeDC);
            Map<String, Track> liveTracks = this.addLiveTracksToMediaPackage(tmpMp, episodeDC);
            MediaPackage mpForSearch = this.distributeAclsAndCatalogs(snapshot);
            for (Track t : tmpMp.getTracks()) {
                mpForSearch.add(t);
            }
            this.publishToSearch(mpForSearch);
            MediaPackage updatedArchivedMp = this.addLivePublicationToMediaPackage(snapshot, liveTracks);
            this.snapshotVersionCache.put((Object)mpId, (Object)this.assetManager.takeSnapshot(updatedArchivedMp).getVersion());
            return true;
        }
        catch (Exception e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    boolean updateLiveEvent(MediaPackage mpFromSearch, DublinCoreCatalog episodeDC) throws LiveScheduleException {
        String mpId = mpFromSearch.getIdentifier().toString();
        Snapshot snapshot = this.getSnapshotFromArchive(mpId);
        if (snapshot.getVersion().equals(this.snapshotVersionCache.getIfPresent((Object)mpId))) {
            logger.debug("Snapshot version {} was created by us so this change is ignored.", (Object)snapshot.getVersion());
            return false;
        }
        MediaPackage tmpMp = (MediaPackage)snapshot.getMediaPackage().clone();
        Collection elements = this.publishElementSelector.select(tmpMp, false);
        Arrays.stream(tmpMp.getElements()).filter(Predicate.not(elements::contains)).collect(Collectors.toList()).forEach(arg_0 -> ((MediaPackage)tmpMp).remove(arg_0));
        this.setDurationForMediaPackage(tmpMp, episodeDC);
        Map<String, Track> liveTracks = this.addLiveTracksToMediaPackage(tmpMp, episodeDC);
        if (this.isSameMediaPackage(mpFromSearch, tmpMp)) {
            logger.debug("Live media package {} seems to be the same. Not updating.", (Object)mpFromSearch);
            return false;
        }
        logger.info("Updating live media package {}", (Object)mpFromSearch);
        MediaPackage mpForSearch = this.distributeAclsAndCatalogs(snapshot);
        for (Track t : tmpMp.getTracks()) {
            mpForSearch.add(t);
        }
        this.removeLivePublicationChannel(mpForSearch);
        this.publishToSearch(mpForSearch);
        this.retractPreviousElements(mpFromSearch, mpForSearch);
        MediaPackage updatedArchivedMp = this.updateLivePublication(snapshot.getMediaPackage(), liveTracks);
        this.snapshotVersionCache.put((Object)mpId, (Object)this.assetManager.takeSnapshot(updatedArchivedMp).getVersion());
        return true;
    }

    private void createOrUpdatePublicationTracks(Publication publication, Map<String, Track> generatedTracks) {
        if (publication.getTracks().length > 0) {
            publication.clearTracks();
        }
        for (String publishedStreamingFormat : this.publishedStreamingFormats) {
            Track track = generatedTracks.get(publishedStreamingFormat);
            if (track == null) continue;
            publication.addTrack(track);
        }
    }

    private MediaPackage updateLivePublication(MediaPackage mediaPackage, Map<String, Track> generatedTracks) {
        Publication[] publications;
        for (Publication publication : publications = mediaPackage.getPublications()) {
            if (!publication.getChannel().equals("engage-live")) continue;
            this.createOrUpdatePublicationTracks(publication, generatedTracks);
        }
        return mediaPackage;
    }

    boolean retractLiveEvent(MediaPackage mp) throws LiveScheduleException {
        this.retract(mp);
        try {
            String mpId = mp.getIdentifier().toString();
            Snapshot snapshot = this.getSnapshotFromArchive(mpId);
            MediaPackage archivedMp = snapshot.getMediaPackage();
            this.removeLivePublicationChannel(archivedMp);
            logger.debug("Removed live pub channel from archived media package {}", (Object)mp);
            this.snapshotVersionCache.put((Object)mpId, (Object)this.assetManager.takeSnapshot(archivedMp).getVersion());
        }
        catch (LiveScheduleException liveScheduleException) {
            // empty catch block
        }
        return true;
    }

    void publishToSearch(MediaPackage mp) throws LiveScheduleException {
        try {
            logger.info("Publishing LIVE media package {} to search index", (Object)mp);
            Job publishJob = this.searchService.add(mp);
            if (!this.waitForStatus(publishJob).isSuccess()) {
                throw new LiveScheduleException("Live media package " + mp.getIdentifier() + " could not be published");
            }
        }
        catch (LiveScheduleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    void retract(MediaPackage mp) throws LiveScheduleException {
        Organization org = this.securityService.getOrganization();
        User prevUser = org != null ? this.securityService.getUser() : null;
        try {
            Job distributionRetractJob;
            this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)org));
            HashSet<String> elementIds = new HashSet<String>();
            String mpId = mp.getIdentifier().toString();
            logger.info("Removing LIVE media package {} from the search index", (Object)mpId);
            for (MediaPackageElement mpe : mp.getElements()) {
                if (MediaPackageElement.Type.Publication.equals((Object)mpe.getElementType())) continue;
                elementIds.add(mpe.getIdentifier());
            }
            ArrayList<String> failedJobs = new ArrayList<String>();
            Job searchDeleteJob = this.searchService.delete(mpId);
            if (!this.waitForStatus(searchDeleteJob).isSuccess()) {
                failedJobs.add("Search Index");
            }
            if (!this.waitForStatus(distributionRetractJob = this.downloadDistributionService.retract("engage-live", mp, elementIds)).isSuccess()) {
                failedJobs.add("Distribution");
            }
            if (!failedJobs.isEmpty()) {
                throw new LiveScheduleException(String.format("Removing live media package %s from %s failed", mpId, String.join((CharSequence)" and ", failedJobs)));
            }
        }
        catch (LiveScheduleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiveScheduleException((Throwable)e);
        }
        finally {
            this.securityService.setUser(prevUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaPackage getMediaPackageFromSearch(String mediaPackageId) throws LiveScheduleException {
        Organization org = this.securityService.getOrganization();
        User prevUser = org != null ? this.securityService.getUser() : null;
        this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)org));
        try {
            MediaPackage mediaPackage = this.searchService.get(mediaPackageId);
            return mediaPackage;
        }
        catch (UnauthorizedException e) {
            logger.warn("Unexpected unauthorized exception when querying the search index for mp {}", (Object)mediaPackageId, (Object)e);
            MediaPackage mediaPackage = null;
            return mediaPackage;
        }
        catch (NotFoundException e) {
            MediaPackage mediaPackage = null;
            return mediaPackage;
        }
        finally {
            this.securityService.setUser(prevUser);
        }
    }

    void setDurationForMediaPackage(MediaPackage mp, DublinCoreCatalog dc) {
        DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((String)dc.getFirst(DublinCore.PROPERTY_TEMPORAL));
        long duration = period.getEnd().getTime() - period.getStart().getTime();
        mp.setDuration(Long.valueOf(duration));
        logger.debug("Live media package {} has start {} and duration {}", new Object[]{mp.getIdentifier(), mp.getDate(), mp.getDuration()});
    }

    Map<String, Track> addLiveTracksToMediaPackage(MediaPackage mp, DublinCoreCatalog episodeDC) throws LiveScheduleException {
        String caName = episodeDC.getFirst(DublinCore.PROPERTY_SPATIAL);
        HashMap<String, Track> generatedTracks = new HashMap<String, Track>();
        String mpId = mp.getIdentifier().toString();
        try {
            try {
                MediaPackageElementFlavor[] caProps = this.captureAgentService.getAgentCapabilities(caName);
                if (caProps != null) {
                    Enumeration<Object> en = caProps.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        if (!key.startsWith(CA_PROPERTY_RESOLUTION_URL_PREFIX)) continue;
                        String resolution = key.substring(CA_PROPERTY_RESOLUTION_URL_PREFIX.length());
                        String url = caProps.getProperty(key);
                        MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)DEFAULT_LIVE_TARGET_FLAVORS);
                        String replacedUrl = this.replaceVariables(mpId, caName, url, flavor, resolution);
                        mp.add(this.buildStreamingTrack(replacedUrl, flavor, this.streamMimeType, resolution, mp.getDuration()));
                    }
                }
            }
            catch (NotFoundException caProps) {
                // empty catch block
            }
            if (mp.getTracks().length == 0) {
                if (this.liveStreamingUrl == null) {
                    throw new LiveScheduleException("Cannot build live tracks because 'live.streamingUrl' configuration was not set.");
                }
                for (MediaPackageElementFlavor flavor : this.liveFlavors) {
                    for (int i = 0; i < this.streamResolution.length; ++i) {
                        String uri = this.replaceVariables(mpId, caName, UrlSupport.concat((String)this.liveStreamingUrl.toString(), (String)this.streamName), flavor, this.streamResolution[i]);
                        Track track = this.buildStreamingTrack(uri, flavor, this.streamMimeType, this.streamResolution[i], mp.getDuration());
                        mp.add(track);
                        generatedTracks.put(flavor + ":" + this.streamResolution[i], track);
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            throw new LiveScheduleException((Throwable)e);
        }
        return generatedTracks;
    }

    Track buildStreamingTrack(String uriString, MediaPackageElementFlavor flavor, String mimeType, String resolution, long duration) throws URISyntaxException {
        URI uri = new URI(uriString);
        MediaPackageElementBuilder elementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        MediaPackageElement element = elementBuilder.elementFromURI(uri, MediaPackageElement.Type.Track, flavor);
        TrackImpl track = (TrackImpl)element;
        track.setDuration(Long.valueOf(duration));
        track.setLive(true);
        track.setMimeType(MimeTypes.parseMimeType((String)mimeType));
        VideoStreamImpl video = new VideoStreamImpl("video-" + flavor.getType() + "-" + flavor.getSubtype());
        String[] dimensions = resolution.split("x");
        video.setFrameWidth(Integer.valueOf(Integer.parseInt(dimensions[0])));
        video.setFrameHeight(Integer.valueOf(Integer.parseInt(dimensions[1])));
        track.addStream((AbstractStreamImpl)video);
        logger.debug("Creating live track element of flavor {}, resolution {}, and url {}", new Object[]{flavor, resolution, uriString});
        return track;
    }

    String replaceVariables(String mpId, String caName, String toBeReplaced, MediaPackageElementFlavor flavor, String resolution) {
        Pattern pat = Pattern.compile("#\\{(\\w+)\\}");
        Matcher matcher = pat.matcher(toBeReplaced);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1).equals(REPLACE_ID)) {
                matcher.appendReplacement(sb, mpId);
                continue;
            }
            if (matcher.group(1).equals(REPLACE_FLAVOR)) {
                matcher.appendReplacement(sb, flavor.getType() + "-" + flavor.getSubtype());
                continue;
            }
            if (matcher.group(1).equals(REPLACE_CA_NAME)) {
                matcher.appendReplacement(sb, caName);
                continue;
            }
            if (!matcher.group(1).equals(REPLACE_RESOLUTION)) continue;
            matcher.appendReplacement(sb, resolution);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private JobBarrier.Result waitForStatus(Job ... jobs) throws IllegalStateException, IllegalArgumentException {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Can't wait for job status without providing a service registry first");
        }
        JobBarrier barrier = new JobBarrier(null, this.serviceRegistry, this.jobPollingInterval, jobs);
        return barrier.waitForJobs();
    }

    Snapshot getSnapshotFromArchive(String mpId) throws LiveScheduleException {
        AQueryBuilder query = this.assetManager.createQuery();
        AResult result = query.select(new Target[]{query.snapshot()}).where(query.mediaPackageId(mpId).and(query.version().isLatest())).run();
        if (result.getSize() == 0L) {
            throw new LiveScheduleException(String.format("Unexpected error: media package %s has not been archived.", mpId));
        }
        Optional record = result.getRecords().stream().findFirst();
        if (record.isEmpty()) {
            throw new LiveScheduleException(String.format("Unexpected error: media package %s has not been archived.", mpId));
        }
        return (Snapshot)((ARecord)record.get()).getSnapshot().get();
    }

    MediaPackage distributeAclsAndCatalogs(Snapshot snapshot) throws LiveScheduleException {
        try {
            MediaPackage mp = (MediaPackage)snapshot.getMediaPackage().clone();
            Collection elements = this.publishElementSelector.select(mp, false);
            Set elementIds = elements.stream().map(MediaPackageElement::getIdentifier).collect(Collectors.toSet());
            Job distributionJob = this.downloadDistributionService.distribute("engage-live", mp, elementIds, false);
            if (!this.waitForStatus(distributionJob).isSuccess()) {
                throw new LiveScheduleException("Element(s) for live media package " + mp.getIdentifier() + " could not be distributed");
            }
            for (MediaPackageElement e : mp.getElements()) {
                mp.remove(e);
            }
            List distributedElements = MediaPackageElementParser.getArrayFromXml((String)distributionJob.getPayload());
            for (MediaPackageElement distributedElement : distributedElements) {
                mp.add(distributedElement);
            }
            for (String id : elementIds) {
                MediaPackageElement e;
                e = mp.getElementById(id);
                this.workspace.delete(e.getURI());
            }
            return mp;
        }
        catch (LiveScheduleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    MediaPackage replaceAndDistributeAcl(MediaPackage previousMp, AccessControlList acl) throws LiveScheduleException {
        try {
            MediaPackage mp = (MediaPackage)previousMp.clone();
            Attachment[] atts = mp.getAttachments(MediaPackageElements.XACML_POLICY_EPISODE);
            if (atts.length > 0) {
                mp.remove(atts[0]);
            }
            this.authService.setAcl(mp, AclScope.Episode, acl);
            atts = mp.getAttachments(MediaPackageElements.XACML_POLICY_EPISODE);
            if (atts.length > 0) {
                String aclId = atts[0].getIdentifier();
                Job distributionJob = this.downloadDistributionService.distribute("engage-live", mp, aclId, false);
                if (!this.waitForStatus(distributionJob).isSuccess()) {
                    throw new LiveScheduleException("Acl for live media package " + mp.getIdentifier() + " could not be distributed");
                }
                MediaPackageElement e = mp.getElementById(aclId);
                mp.remove(e);
                this.workspace.delete(e.getURI());
                mp.add(MediaPackageElementParser.getFromXml((String)distributionJob.getPayload()));
            }
            return mp;
        }
        catch (LiveScheduleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    MediaPackage addLivePublicationToMediaPackage(Snapshot snapshot, Map<String, Track> generatedTracks) throws LiveScheduleException {
        MediaPackage mp = snapshot.getMediaPackage();
        Organization currentOrg = null;
        try {
            currentOrg = this.organizationService.getOrganization(snapshot.getOrganizationId());
        }
        catch (NotFoundException e) {
            logger.warn("Organization in snapshot not found: {}", (Object)snapshot.getOrganizationId());
        }
        logger.debug("Adding live channel publication element to media package {}", (Object)mp);
        String engageUrlString = null;
        if (currentOrg != null) {
            engageUrlString = StringUtils.trimToNull((String)((String)currentOrg.getProperties().get(ENGAGE_URL_PROPERTY)));
        }
        if (engageUrlString == null) {
            engageUrlString = this.serverUrl;
            logger.info("Using 'server.url' as a fallback for the non-existing organization level key '{}' for the publication url", (Object)ENGAGE_URL_PROPERTY);
        }
        try {
            URI engageUri = URIUtils.resolve((URI)new URI(engageUrlString), (String)(PLAYER_PATH + mp.getIdentifier().toString()));
            Publication publicationElement = PublicationImpl.publication((String)UUID.randomUUID().toString(), (String)"engage-live", (URI)engageUri, (MimeType)MimeTypes.parseMimeType((String)"text/html"));
            mp.add((MediaPackageElement)publicationElement);
            this.createOrUpdatePublicationTracks(publicationElement, generatedTracks);
            return mp;
        }
        catch (URISyntaxException e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    void removeLivePublicationChannel(MediaPackage mp) {
        Publication[] publications = mp.getPublications();
        if (publications != null) {
            for (Publication publication : publications) {
                if (!"engage-live".equals(publication.getChannel())) continue;
                mp.remove((MediaPackageElement)publication);
            }
        }
    }

    boolean isSameMediaPackage(MediaPackage previous, MediaPackage current) {
        Equator<Track> liveTrackEquator = new Equator<Track>(){

            public boolean equate(Track track1, Track track2) {
                VideoStream videostream1 = (VideoStream)track1.getStreams()[0];
                VideoStream videostream2 = (VideoStream)track2.getStreams()[0];
                return Objects.equals(track1.getURI(), track2.getURI()) && Objects.equals(track1.getFlavor(), track2.getFlavor()) && Objects.equals(track1.getMimeType(), track2.getMimeType()) && Objects.equals(track1.getDuration(), track2.getDuration()) && Objects.equals(videostream1.getFrameWidth(), videostream2.getFrameWidth()) && Objects.equals(videostream1.getFrameHeight(), videostream2.getFrameHeight());
            }

            public int hash(Track track) {
                VideoStream videostream = (VideoStream)track.getStreams()[0];
                return Objects.hash(track.getURI(), track.getFlavor(), track.getMimeType(), track.getDuration(), videostream.getFrameWidth(), videostream.getFrameHeight());
            }
        };
        Equator<MediaPackageElement> catalogAndAttachmentEquator = new Equator<MediaPackageElement>(){

            public boolean equate(MediaPackageElement mpe1, MediaPackageElement mpe2) {
                return Objects.equals(mpe1.getIdentifier(), mpe2.getIdentifier()) && Objects.equals(mpe1.getElementType(), mpe2.getElementType()) && Objects.equals(mpe1.getChecksum(), mpe2.getChecksum()) && Objects.equals(mpe1.getFlavor(), mpe2.getFlavor());
            }

            public int hash(MediaPackageElement mpe) {
                return Objects.hash(mpe.getIdentifier(), mpe.getElementType(), mpe.getChecksum(), mpe.getFlavor());
            }
        };
        if (!CollectionUtils.isEqualCollection(Arrays.asList(previous.getTracks()), Arrays.asList(current.getTracks()), (Equator)liveTrackEquator)) {
            return false;
        }
        if (!CollectionUtils.isEqualCollection(Arrays.asList(previous.getCatalogs()), Arrays.asList(current.getCatalogs()), (Equator)catalogAndAttachmentEquator)) {
            return false;
        }
        return CollectionUtils.isEqualCollection(Arrays.asList(previous.getAttachments()), Arrays.asList(current.getAttachments()), (Equator)catalogAndAttachmentEquator);
    }

    void retractPreviousElements(MediaPackage previousMp, MediaPackage newMp) throws LiveScheduleException {
        try {
            HashSet<String> elementIds = new HashSet<String>();
            for (MediaPackageElement element : previousMp.getElements()) {
                if (Track.TYPE.equals((Object)element.getElementType())) continue;
                boolean canBeDeleted = true;
                for (MediaPackageElement newElement : newMp.getElements()) {
                    if (!element.getURI().equals(newElement.getURI())) continue;
                    logger.debug("Not retracting element {} with URI {} from download distribution because it is still used by updated live media package", (Object)element.getIdentifier(), (Object)element.getURI());
                    canBeDeleted = false;
                    break;
                }
                if (!canBeDeleted) continue;
                elementIds.add(element.getIdentifier());
            }
            if (elementIds.size() > 0) {
                Job job = this.downloadDistributionService.retract("engage-live", previousMp, elementIds);
                if (!this.waitForStatus(job).isSuccess()) {
                    logger.warn("One of the download retract jobs did not complete successfully");
                } else {
                    logger.debug("Retraction of previously published elements complete");
                }
            }
        }
        catch (DistributionException e) {
            throw new LiveScheduleException((Throwable)e);
        }
    }

    @Reference
    public void setDublinCoreService(DublinCoreCatalogService service) {
        this.dublinCoreService = service;
    }

    @Reference
    public void setSearchService(SearchService service) {
        this.searchService = service;
    }

    @Reference
    public void setSeriesService(SeriesService service) {
        this.seriesService = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry service) {
        this.serviceRegistry = service;
    }

    @Reference
    public void setCaptureAgentService(CaptureAgentStateService service) {
        this.captureAgentService = service;
    }

    @Reference(name="DownloadDistributionService", target="(distribution.channel=download)")
    public void setDownloadDistributionService(DownloadDistributionService service) {
        this.downloadDistributionService = service;
        logger.info("Distribution service with type '{}' set.", (Object)this.downloadDistributionService.getDistributionType());
    }

    @Reference
    public void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService service) {
        this.authService = service;
    }

    @Reference
    public void setOrganizationService(OrganizationDirectoryService service) {
        this.organizationService = service;
    }

    @Reference
    public void setSecurityService(SecurityService service) {
        this.securityService = service;
    }

    void setJobPollingInterval(long jobPollingInterval) {
        this.jobPollingInterval = jobPollingInterval;
    }

    Cache<String, Version> getSnapshotVersionCache() {
        return this.snapshotVersionCache;
    }
}

