/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security.persistence;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.kernel.security.persistence.OrganizationDatabase;
import org.opencastproject.kernel.security.persistence.OrganizationDatabaseException;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Organization Persistence"}, immediate=true, service={OrganizationDatabase.class})
public class OrganizationDatabaseImpl
implements OrganizationDatabase {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationDatabaseImpl.class);
    static final String PERSISTENCE_UNIT = "org.opencastproject.common";
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;

    @Reference(target="(osgi.unit.name=org.opencastproject.common)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for kernel");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public void deleteOrganization(String orgId) throws OrganizationDatabaseException, NotFoundException {
        try {
            this.db.execTxChecked(em -> {
                Optional<JpaOrganization> organization = this.getOrganizationEntityQuery(orgId).apply((EntityManager)em);
                if (organization.isEmpty()) {
                    throw new NotFoundException("Organization " + orgId + " does not exist");
                }
                em.remove((Object)organization.get());
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not delete organization: {}", (Object)e.getMessage());
            throw new OrganizationDatabaseException(e);
        }
    }

    @Override
    public void storeOrganization(Organization org) throws OrganizationDatabaseException {
        try {
            this.db.execTx(em -> {
                Optional<JpaOrganization> organizationEntity = this.getOrganizationEntityQuery(org.getId()).apply((EntityManager)em);
                if (organizationEntity.isEmpty()) {
                    JpaOrganization organization = new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
                    em.persist((Object)organization);
                } else {
                    organizationEntity.get().setName(org.getName());
                    organizationEntity.get().setAdminRole(org.getAdminRole());
                    organizationEntity.get().setAnonymousRole(org.getAnonymousRole());
                    for (Map.Entry servers : org.getServers().entrySet()) {
                        organizationEntity.get().addServer((String)servers.getKey(), (Integer)servers.getValue());
                    }
                    organizationEntity.get().setServers(org.getServers());
                    organizationEntity.get().setProperties(org.getProperties());
                    em.merge((Object)organizationEntity.get());
                }
            });
        }
        catch (Exception e) {
            logger.error("Could not update organization: {}", (Object)e.getMessage());
            throw new OrganizationDatabaseException(e);
        }
    }

    @Override
    public Organization getOrganization(String id) throws NotFoundException, OrganizationDatabaseException {
        return (Organization)((Optional)this.db.exec(this.getOrganizationEntityQuery(id))).orElseThrow(NotFoundException::new);
    }

    @Override
    public int countOrganizations() throws OrganizationDatabaseException {
        try {
            return ((Long)this.db.exec(Queries.namedQuery.find("Organization.getCount", Long.class, new Object[0]))).intValue();
        }
        catch (Exception e) {
            logger.error("Could not find number of organizations.", (Throwable)e);
            throw new OrganizationDatabaseException(e);
        }
    }

    @Override
    public Organization getOrganizationByHost(String host, int port) throws OrganizationDatabaseException, NotFoundException {
        try {
            return (Organization)((Optional)this.db.exec(Queries.namedQuery.findOpt("Organization.findByHost", JpaOrganization.class, new Object[]{Pair.of((Object)"serverName", (Object)host), Pair.of((Object)"port", (Object)port)}))).orElseThrow(NotFoundException::new);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OrganizationDatabaseException(e);
        }
    }

    @Override
    public List<Organization> getOrganizations() throws OrganizationDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("Organization.findAll", Organization.class, new Object[0]));
        }
        catch (Exception e) {
            throw new OrganizationDatabaseException(e);
        }
    }

    @Override
    public boolean containsOrganization(String orgId) throws OrganizationDatabaseException {
        return ((Optional)this.db.exec(this.getOrganizationEntityQuery(orgId))).isPresent();
    }

    private Function<EntityManager, Optional<JpaOrganization>> getOrganizationEntityQuery(String id) {
        return Queries.namedQuery.findOpt("Organization.findById", JpaOrganization.class, new Object[]{Pair.of((Object)"id", (Object)id)});
    }
}

