/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.opencastproject.kernel.security.HttpConnectionMXBean;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.TrustedHttpClientException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.security.util.HttpResponseWrapper;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.urlsigning.utils.ResourceRequestUtil;
import org.opencastproject.util.data.Collections;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides Trusted Http Clients (for use with digest authentication)"}, immediate=true, service={TrustedHttpClient.class})
public class TrustedHttpClientImpl
implements TrustedHttpClient,
HttpConnectionMXBean {
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final Logger logger = LoggerFactory.getLogger(TrustedHttpClientImpl.class);
    public static final String DIGEST_AUTH_USER_KEY = "org.opencastproject.security.digest.user";
    public static final String DIGEST_AUTH_PASS_KEY = "org.opencastproject.security.digest.pass";
    public static final String NONCE_TIMEOUT_RETRY_KEY = "org.opencastproject.security.digest.nonce.retries";
    protected static final String INTERNAL_URL_SIGNING_DURATION_KEY = "org.opencastproject.security.internal.url.signing.duration";
    public static final String NONCE_TIMEOUT_RETRY_BASE_TIME_KEY = "org.opencastproject.security.digest.nonce.base.time";
    public static final String NONCE_TIMEOUT_RETRY_MAXIMUM_VARIABLE_TIME_KEY = "org.opencastproject.security.digest.nonce.variable.time";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 300000;
    public static final int DEFAULT_NONCE_TIMEOUT_RETRIES = 12;
    private static final int MILLISECONDS_IN_SECONDS = 1000;
    public static final int DEFAULT_RETRY_BASE_TIME = 300;
    public static final int DEFAULT_RETRY_MAXIMUM_VARIABLE_TIME = 300;
    protected static final long DEFAULT_URL_SIGNING_EXPIRES_DURATION = 60L;
    protected String user = null;
    protected String pass = null;
    private int nonceTimeoutRetries = 12;
    protected Map<HttpResponse, CloseableHttpClient> responseMap = new ConcurrentHashMap<HttpResponse, CloseableHttpClient>();
    private final Random generator = new Random();
    private int retryBaseDelay = 300;
    private int retryMaximumVariableTime = 300;
    private long signedUrlExpiresDuration = 60L;
    private ServiceRegistry serviceRegistry = null;
    protected SecurityService securityService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected UrlSigningService urlSigningService = null;
    private HostCache hosts = null;

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("activate");
        this.user = cc.getBundleContext().getProperty(DIGEST_AUTH_USER_KEY);
        this.pass = cc.getBundleContext().getProperty(DIGEST_AUTH_PASS_KEY);
        if (this.user == null || this.pass == null) {
            throw new IllegalStateException("trusted communication is not properly configured");
        }
        this.getRetryNumber(cc);
        this.getRetryBaseTime(cc);
        this.getRetryMaximumVariableTime(cc);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("org.opencastproject.security.api.TrustedHttpClient:type=HttpConnections");
            TrustedHttpClientImpl mbean = this;
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to register {} as an mbean", (Object)this, (Object)e);
        }
        Long expiration = NumberUtils.createLong((String)StringUtils.trimToNull((String)cc.getBundleContext().getProperty(INTERNAL_URL_SIGNING_DURATION_KEY)));
        this.signedUrlExpiresDuration = expiration != null ? expiration : 60L;
        logger.debug("Expire signed URLs in {} seconds.", (Object)this.signedUrlExpiresDuration);
    }

    private HostCache getHostCache() {
        if (null == this.hosts) {
            this.hosts = new HostCache(60000L, this.organizationDirectoryService, this.serviceRegistry);
        }
        return this.hosts;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetServiceRegistry")
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void unsetServiceRegistry(ServiceRegistry serviceRegistry) {
        if (this.serviceRegistry == serviceRegistry) {
            this.serviceRegistry = null;
        }
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setUrlSigningService(UrlSigningService urlSigningService) {
        this.urlSigningService = urlSigningService;
    }

    private void getRetryNumber(ComponentContext cc) {
        this.nonceTimeoutRetries = this.getIntFromComponentContext(cc, NONCE_TIMEOUT_RETRY_KEY, 12);
    }

    private void getRetryBaseTime(ComponentContext cc) {
        this.retryBaseDelay = this.getIntFromComponentContext(cc, NONCE_TIMEOUT_RETRY_BASE_TIME_KEY, 300);
    }

    private void getRetryMaximumVariableTime(ComponentContext cc) {
        this.retryMaximumVariableTime = this.getIntFromComponentContext(cc, NONCE_TIMEOUT_RETRY_MAXIMUM_VARIABLE_TIME_KEY, 300);
    }

    private int getIntFromComponentContext(ComponentContext cc, String key, int defaultValue) {
        int result;
        try {
            String stringValue = cc.getBundleContext().getProperty(key);
            result = Integer.parseInt(StringUtils.trimToNull((String)stringValue));
        }
        catch (Exception e) {
            if (cc != null && cc.getBundleContext() != null && cc.getBundleContext().getProperty(key) != null) {
                logger.info("Unable to get property with key " + key + " with value " + cc.getBundleContext().getProperty(key) + " so using default of " + defaultValue + " because of " + e.getMessage());
            } else {
                logger.info("Unable to get property with key " + key + " so using default of " + defaultValue + " because of " + e.getMessage());
            }
            result = defaultValue;
        }
        return result;
    }

    @Deactivate
    public void deactivate() {
        logger.debug("deactivate");
    }

    public TrustedHttpClientImpl() {
    }

    public TrustedHttpClientImpl(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    public HttpClientBuilder makeHttpClientBuilder(int connectionTimeout, int socketTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws TrustedHttpClientException {
        return this.execute(httpUriRequest, 60000, 300000);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, int connectionTimeout, int socketTimeout) throws TrustedHttpClientException {
        if (this.serviceRegistry != null && this.serviceRegistry.getCurrentJob() != null) {
            httpUriRequest.setHeader("X-Opencast-Matterhorn-Current-Job-Id", Long.toString(this.serviceRegistry.getCurrentJob().getId()));
        }
        boolean enableDigest = this.getHostCache().contains(httpUriRequest.getURI().getHost());
        logger.debug("Digest auth enabled for this request: " + enableDigest);
        if (enableDigest) {
            httpUriRequest.setHeader("X-Requested-Auth", "Digest");
        }
        logger.debug("Adding security context to request");
        Organization organization = this.securityService.getOrganization();
        if (organization != null) {
            httpUriRequest.setHeader("X-Opencast-Matterhorn-Organization", organization.getId());
            User currentUser = this.securityService.getUser();
            if (enableDigest && currentUser != null) {
                httpUriRequest.setHeader("X-Opencast-Matterhorn-User", currentUser.getUsername());
            }
        }
        HttpClientBuilder clientBuilder = this.makeHttpClientBuilder(connectionTimeout, socketTimeout);
        if ("GET".equalsIgnoreCase(httpUriRequest.getMethod()) || "HEAD".equalsIgnoreCase(httpUriRequest.getMethod())) {
            CloseableHttpClient httpClient;
            if (enableDigest) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(this.user, this.pass));
                httpClient = clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            } else {
                httpClient = clientBuilder.build();
            }
            try {
                httpUriRequest = this.getSignedUrl(httpUriRequest);
                HttpResponseWrapper response = new HttpResponseWrapper((HttpResponse)httpClient.execute(httpUriRequest));
                this.responseMap.put((HttpResponse)response, httpClient);
                return response;
            }
            catch (IOException e) {
                try {
                    httpClient.close();
                }
                catch (IOException ioException) {
                    throw new TrustedHttpClientException((Throwable)e);
                }
                throw new TrustedHttpClientException((Throwable)e);
            }
        }
        if (enableDigest) {
            CloseableHttpClient httpClient = clientBuilder.build();
            this.manuallyHandleDigestAuthentication(httpUriRequest, httpClient);
            HttpResponseWrapper response = null;
            try {
                response = new HttpResponseWrapper((HttpResponse)httpClient.execute(httpUriRequest));
                if (this.nonceTimeoutRetries > 0 && this.hadNonceTimeoutResponse((HttpResponse)response)) {
                    httpClient.close();
                    response = this.retryAuthAndRequestAfterNonceTimeout(httpUriRequest, (HttpResponse)response);
                }
                this.responseMap.put((HttpResponse)response, httpClient);
                return response;
            }
            catch (Exception e) {
                if (response != null) {
                    this.responseMap.remove(response);
                }
                try {
                    httpClient.close();
                }
                catch (IOException ioException) {
                    throw new TrustedHttpClientException((Throwable)e);
                }
                throw new TrustedHttpClientException((Throwable)e);
            }
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute(httpUriRequest);
            return response;
        }
        catch (Exception e) {
            try {
                httpClient.close();
            }
            catch (IOException ioException) {
                throw new TrustedHttpClientException((Throwable)e);
            }
            throw new TrustedHttpClientException((Throwable)e);
        }
    }

    protected HttpUriRequest getSignedUrl(HttpUriRequest httpUriRequest) throws TrustedHttpClientException {
        if (("GET".equalsIgnoreCase(httpUriRequest.getMethod()) || "HEAD".equalsIgnoreCase(httpUriRequest.getMethod())) && ResourceRequestUtil.isNotSigned((URI)httpUriRequest.getURI()) && this.urlSigningService.accepts(httpUriRequest.getURI().toString())) {
            logger.trace("Signing request with method: {} and URI: {}", (Object)httpUriRequest.getMethod(), (Object)httpUriRequest.getURI());
            try {
                String signedUrl = this.urlSigningService.sign(httpUriRequest.getURI().toString(), Long.valueOf(this.signedUrlExpiresDuration), null, null);
                Object signedRequest = "GET".equalsIgnoreCase(httpUriRequest.getMethod()) ? new HttpGet(signedUrl) : new HttpHead(signedUrl);
                signedRequest.setProtocolVersion(httpUriRequest.getProtocolVersion());
                for (Header header : httpUriRequest.getAllHeaders()) {
                    signedRequest.addHeader(header);
                }
                return signedRequest;
            }
            catch (UrlSigningException e) {
                throw new TrustedHttpClientException((Throwable)e);
            }
        }
        return httpUriRequest;
    }

    private HttpResponse retryAuthAndRequestAfterNonceTimeout(HttpUriRequest httpUriRequest, HttpResponse response) throws TrustedHttpClientException, IOException, ClientProtocolException {
        httpUriRequest.removeHeaders(AUTHORIZATION_HEADER_NAME);
        for (int i = 0; i < this.nonceTimeoutRetries; ++i) {
            long totalDelay;
            CloseableHttpClient httpClient = this.makeHttpClientBuilder(60000, 300000).build();
            int variableDelay = 0;
            if (this.retryMaximumVariableTime > 0) {
                variableDelay = this.generator.nextInt(this.retryMaximumVariableTime * 1000);
            }
            if ((totalDelay = (long)(this.retryBaseDelay * 1000 + variableDelay)) > 0L) {
                logger.info("Sleeping " + totalDelay + "ms before trying request " + String.valueOf(httpUriRequest.getURI()) + " again due to a " + String.valueOf(response.getStatusLine()));
                try {
                    Thread.sleep(totalDelay);
                }
                catch (InterruptedException e) {
                    logger.error("Suffered InteruptedException while trying to sleep until next retry.", (Throwable)e);
                }
            }
            this.manuallyHandleDigestAuthentication(httpUriRequest, httpClient);
            response = new HttpResponseWrapper((HttpResponse)httpClient.execute(httpUriRequest));
            if (!this.hadNonceTimeoutResponse(response)) {
                this.responseMap.put(response, httpClient);
                break;
            }
            httpClient.close();
        }
        return response;
    }

    private boolean hadNonceTimeoutResponse(HttpResponse response) {
        return 401 == response.getStatusLine().getStatusCode() && "Nonce has expired/timed out".equals(response.getStatusLine().getReasonPhrase());
    }

    private void manuallyHandleDigestAuthentication(HttpUriRequest httpUriRequest, CloseableHttpClient httpClient) throws TrustedHttpClientException {
        HttpRequestBase digestRequest;
        try {
            digestRequest = (HttpRequestBase)httpUriRequest.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create a new " + httpUriRequest.getClass().getName());
        }
        digestRequest.setURI(httpUriRequest.getURI());
        digestRequest.setHeader("X-Requested-Auth", "Digest");
        String[] realmAndNonce = this.getRealmAndNonce(digestRequest);
        if (realmAndNonce != null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, this.pass);
            DigestScheme digestAuth = new DigestScheme();
            digestAuth.overrideParamter("realm", realmAndNonce[0]);
            digestAuth.overrideParamter("nonce", realmAndNonce[1]);
            try {
                httpUriRequest.setHeader(digestAuth.authenticate((Credentials)creds, (HttpRequest)httpUriRequest));
            }
            catch (Exception e) {
                try {
                    httpClient.close();
                }
                catch (IOException ex) {
                    throw new TrustedHttpClientException((Throwable)ex);
                }
                throw new TrustedHttpClientException((Throwable)e);
            }
        }
    }

    public void close(HttpResponse response) throws IOException {
        if (response != null) {
            CloseableHttpClient httpClient = this.responseMap.remove(response);
            if (httpClient != null) {
                httpClient.close();
            }
        } else {
            logger.debug("Can not close a null response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] getRealmAndNonce(HttpRequestBase request) throws TrustedHttpClientException {
        CloseableHttpClient httpClient = this.makeHttpClientBuilder(60000, 300000).build();
        try {
            try {
                HttpResponseWrapper response = new HttpResponseWrapper((HttpResponse)httpClient.execute((HttpUriRequest)request));
                Header[] headers = response.getHeaders("WWW-Authenticate");
                if (headers == null || headers.length == 0) {
                    logger.warn("URI {} does not support digest authentication", (Object)request.getURI());
                    String[] stringArray = null;
                    return stringArray;
                }
                Header authRequiredResponseHeader = headers[0];
                String nonce = null;
                String realm = null;
                for (HeaderElement element : authRequiredResponseHeader.getElements()) {
                    if ("nonce".equals(element.getName())) {
                        nonce = element.getValue();
                        continue;
                    }
                    if (!"Digest realm".equals(element.getName())) continue;
                    realm = element.getValue();
                }
                String[] stringArray = new String[]{realm, nonce};
                return stringArray;
            }
            finally {
                httpClient.close();
            }
        }
        catch (IOException e) {
            throw new TrustedHttpClientException((Throwable)e);
        }
    }

    @Override
    public int getOpenConnections() {
        return this.responseMap.size();
    }

    public int getNonceTimeoutRetries() {
        return this.nonceTimeoutRetries;
    }

    public int getRetryBaseDelay() {
        return this.retryBaseDelay;
    }

    public int getRetryMaximumVariableTime() {
        return this.retryMaximumVariableTime;
    }

    private static final class HostCache {
        private final Object lock = new Object();
        private final Set<String> hosts = Collections.set((Object[])new String[0]);
        private final long refreshInterval;
        private long lastRefresh;
        private final OrganizationDirectoryService organizationDirectoryService;
        private final ServiceRegistry serviceRegistry;

        HostCache(long refreshInterval, OrganizationDirectoryService orgDirSrv, ServiceRegistry serviceReg) {
            this.refreshInterval = refreshInterval;
            this.organizationDirectoryService = orgDirSrv;
            this.serviceRegistry = serviceReg;
            this.invalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String host) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.refresh();
                }
                catch (ServiceRegistryException e) {
                    logger.error("Unable to update host cache due to service registry exception!", (Throwable)e);
                }
                return this.hosts.contains(host);
            }
        }

        public void invalidate() {
            this.lastRefresh = System.currentTimeMillis() - 2L * this.refreshInterval;
        }

        private void refresh() throws ServiceRegistryException {
            long now = System.currentTimeMillis();
            if (now - this.lastRefresh > this.refreshInterval) {
                this.hosts.clear();
                this.hosts.addAll(this.serviceRegistry.getHostRegistrations().stream().map(HostRegistration::getBaseUrl).map(URI::create).map(URI::getHost).collect(Collectors.toSet()));
                this.hosts.addAll(this.organizationDirectoryService.getOrganizations().stream().map(Organization::getServers).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet()));
                this.lastRefresh = now;
            }
        }
    }
}

