/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.util.Collection;
import java.util.HashSet;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Component(property={"service.description=Provides username and role information for the current user"}, service={SecurityService.class})
public class SecurityServiceSpringImpl
implements SecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceSpringImpl.class);
    private static final ThreadLocal<User> delegatedUserHolder = new ThreadLocal();
    private static final ThreadLocal<String> delegatedUserIPHolder = new ThreadLocal();
    private static final ThreadLocal<Organization> organization = new ThreadLocal();
    private UserDirectoryService userDirectory;

    public Organization getOrganization() {
        return organization.get();
    }

    public void setOrganization(Organization organization) {
        SecurityServiceSpringImpl.organization.set(organization);
    }

    public User getUser() throws IllegalStateException {
        Object principal;
        Organization org = this.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set in security context");
        }
        User delegatedUser = delegatedUserHolder.get();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof AnonymousAuthenticationToken) {
            return SecurityUtil.createAnonymousUser((Organization)org);
        }
        if (delegatedUser != null) {
            return delegatedUser;
        }
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)org);
        if (auth != null && (principal = auth.getPrincipal()) instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)principal;
            User user = null;
            if (this.userDirectory != null) {
                user = this.userDirectory.loadUser(userDetails.getUsername());
                if (user == null) {
                    logger.debug("Authenticated user '{}' could not be found in any of the current UserProviders. Continuing anyway...", (Object)userDetails.getUsername());
                }
            } else {
                logger.debug("No UserDirectory was found when trying to search for user '{}'", (Object)userDetails.getUsername());
            }
            HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
            Collection authorities = auth.getAuthorities();
            if (authorities != null) {
                for (GrantedAuthority ga : authorities) {
                    roles.add(new JaxbRole(ga.getAuthority(), jaxbOrganization));
                }
            }
            user = user == null ? new JaxbUser(userDetails.getUsername(), null, jaxbOrganization, roles) : JaxbUser.fromUser((User)user, roles);
            delegatedUserHolder.set(user);
            return user;
        }
        return SecurityUtil.createAnonymousUser((Organization)jaxbOrganization);
    }

    public void setUser(User user) {
        delegatedUserHolder.set(user);
    }

    public String getUserIP() {
        return delegatedUserIPHolder.get();
    }

    public void setUserIP(String userIP) {
        delegatedUserIPHolder.set(userIP);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="removeUserDirectory")
    void setUserDirectory(UserDirectoryService userDirectory) {
        this.userDirectory = userDirectory;
    }

    void removeUserDirectory(UserDirectoryService unused) {
        if (this.userDirectory == unused) {
            this.userDirectory = null;
        }
    }
}

