/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth.common.OAuthException;
import org.springframework.security.oauth.common.signature.SharedConsumerSecretImpl;
import org.springframework.security.oauth.provider.BaseConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetailsService;
import org.springframework.security.oauth.provider.ExtraTrustConsumerDetails;

@Component(immediate=true, service={ManagedService.class, ConsumerDetailsService.class}, property={"service.description=OAuth consumer details service"})
public class OAuthConsumerDetailsService
implements ConsumerDetailsService,
UserDetailsService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(OAuthConsumerDetailsService.class);
    private static final String CONSUMER_NAME_PREFIX = "oauth.consumer.name.";
    private static final String CONSUMER_KEY_PREFIX = "oauth.consumer.key.";
    private static final String CONSUMER_SECRET_PREFIX = "oauth.consumer.secret.";
    private UserDetailsService delegate;
    private Map<String, ConsumerDetails> consumers = new HashMap<String, ConsumerDetails>();

    @Reference
    public void setDelegate(UserDetailsService delegate) {
        this.delegate = delegate;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String consumerName;
        logger.debug("Updating OAuthConsumerDetailsService");
        this.consumers.clear();
        if (properties == null) {
            logger.warn("OAuthConsumerDetailsService has no configured OAuth consumers");
            return;
        }
        int i = 1;
        while (true) {
            logger.debug("Looking for configuration of {}", (Object)(CONSUMER_NAME_PREFIX + i));
            consumerName = StringUtils.trimToNull((String)((String)properties.get(CONSUMER_NAME_PREFIX + i)));
            String consumerKey = StringUtils.trimToNull((String)((String)properties.get(CONSUMER_KEY_PREFIX + i)));
            String consumerSecret = StringUtils.trimToNull((String)((String)properties.get(CONSUMER_SECRET_PREFIX + i)));
            if (consumerName == null || consumerKey == null || consumerSecret == null) break;
            this.consumers.put(consumerKey, this.createConsumerDetails(consumerName, consumerKey, consumerSecret));
            ++i;
        }
        logger.debug("Unable to configure OAuth consumer with name'{}' because the name, key or secret is missing. Stopping to look for new consumers.", (Object)consumerName);
    }

    private ExtraTrustConsumerDetails createConsumerDetails(String consumerName, String consumerKey, String consumerSecret) {
        SharedConsumerSecretImpl secret = new SharedConsumerSecretImpl(consumerSecret);
        BaseConsumerDetails bcd = new BaseConsumerDetails();
        bcd.setConsumerKey(consumerKey);
        bcd.setConsumerName(consumerName);
        bcd.setSignatureSecret(secret);
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_OAUTH_USER"));
        bcd.setAuthorities(authorities);
        bcd.setRequiredToObtainAuthenticatedToken(false);
        return bcd;
    }

    @Override
    public ConsumerDetails loadConsumerByConsumerKey(String key) throws OAuthException {
        logger.debug("Request received to find consumer for consumerKey=[" + key + "]");
        ConsumerDetails consumer = this.consumers.get(key);
        if (consumer == null) {
            logger.debug("Result: No consumer found for [" + key + "]");
            throw new OAuthException("No consumer found for key " + key);
        }
        logger.debug("Result: Found consumer [" + consumer.getConsumerName() + "]");
        return consumer;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.delegate.loadUserByUsername(username);
    }
}

