/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"service.description=Clean Digest Sessions and Set Max Inactive Interval Filter"})
@ServiceRanking(value=1000)
@HttpWhiteboardFilterName(value="CleanSessionsFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class CleanSessionsFilter
implements Filter {
    private static final int NO_MAX_INACTIVE_INTERVAL_SET = -1;
    private static final Logger logger = LoggerFactory.getLogger(CleanSessionsFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (request != null && request.getSession(false) != null && request.getSession().getMaxInactiveInterval() == -1) {
            logger.trace("Setting maxInactiveInterval to 1800 on request @" + String.valueOf(request.getRequestURL()));
            request.getSession().setMaxInactiveInterval(1800);
        }
        chain.doFilter(req, resp);
        if (request != null && "DIGEST".equals(request.getAuthType())) {
            logger.trace("Invalidating digest request.");
            request.getSession().invalidate();
        } else if (request.getHeader("Authorization") != null) {
            logger.trace("Invalidating digest request.");
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            } else {
                logger.trace("Too late to run invalidate, the request is already committed ({}).", (Object)request.getRequestURI());
            }
        }
    }
}

