/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;

public class RedirectQueryParamAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private String loginQueryParam;

    public RedirectQueryParamAuthenticationEntryPoint(String loginFormUrl, String loginQueryParam) {
        super(loginFormUrl);
        if (loginQueryParam == null) {
            throw new IllegalArgumentException("loginQueryParam cannot be null");
        }
        this.loginQueryParam = loginQueryParam;
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        return UriBuilder.fromPath((String)super.determineUrlToUseForThisRequest(request, response, exception)).queryParam(this.loginQueryParam, new Object[]{UrlUtils.buildRequestUrl((HttpServletRequest)request)}).build(new Object[0]).toString();
    }
}

