/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.scanner;

import java.text.ParseException;
import java.util.Iterator;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.util.SecurityContext;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NeedleEye;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.data.Option;
import org.osgi.service.component.ComponentContext;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanner {
    private static final Logger logger = LoggerFactory.getLogger(AbstractScanner.class);
    public static final String JOB_PARAM_PARENT = "parent";
    public static final String PARAM_KEY_ENABLED = "enabled";
    public static final String PARAM_KEY_CRON_EXPR = "cron-expression";
    protected Scheduler quartz;
    private boolean enabled = false;
    private String cronExpression = "0 0 2 * * ?";
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private OrganizationDirectoryService directoryService;
    private String systemUserName;

    public abstract String getJobGroup();

    public abstract String getJobName();

    public abstract String getTriggerGroupName();

    public abstract String getTriggerName();

    public abstract String getScannerName();

    public abstract void scan();

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    protected Scheduler getQuartz() {
        return this.quartz;
    }

    protected void setQuartz(Scheduler quartz) {
        this.quartz = quartz;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void schedule() {
        if (!this.isEnabled()) {
            logger.info(this.getScannerName() + " is disabled");
            return;
        }
        if (this.quartz == null) {
            logger.warn("No quartz scheduler available to schedule scanner.");
            return;
        }
        logger.info("Schedule " + this.getScannerName() + " as a cron job ({})", (Object)this.getCronExpression());
        try {
            CronTrigger trigger = new CronTrigger();
            trigger.setCronExpression(this.getCronExpression());
            trigger.setName(this.getTriggerName());
            trigger.setGroup(this.getTriggerGroupName());
            trigger.setJobName(this.getJobName());
            trigger.setJobGroup(this.getJobGroup());
            if (this.getQuartz().getTriggersOfJob(this.getJobName(), this.getJobGroup()).length == 0) {
                this.getQuartz().scheduleJob((Trigger)trigger);
            } else {
                this.getQuartz().rescheduleJob(this.getTriggerName(), this.getTriggerGroupName(), (Trigger)trigger);
            }
        }
        catch (ParseException e) {
            logger.error("Error scheduling " + this.getScannerName() + ", the cron expression '{}' could not be parsed: {}", (Object)this.getCronExpression(), (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Error scheduling " + this.getScannerName(), (Throwable)e);
        }
    }

    public void unschedule() {
        try {
            if (this.quartz != null) {
                this.quartz.unscheduleJob(this.getTriggerName(), this.getTriggerGroupName());
            }
        }
        catch (SchedulerException e) {
            logger.error("Error unscheduling " + this.getScannerName(), (Throwable)e);
        }
    }

    protected void bindOrganizationDirectoryService(OrganizationDirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    protected void bindSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected void bindServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.directoryService;
    }

    public SecurityContext getAdminContextFor(String orgId) {
        try {
            Organization org = this.directoryService.getOrganization(orgId);
            return new SecurityContext(this.securityService, org, SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)org));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public String getSystemUserName() {
        return this.systemUserName;
    }

    protected void activate(ComponentContext cc) {
        this.systemUserName = cc.getBundleContext().getProperty("org.opencastproject.security.digest.user");
    }

    public void deactivate() {
        this.shutdown();
    }

    public void shutdown() {
        try {
            if (this.quartz != null) {
                this.quartz.shutdown();
            }
        }
        catch (SchedulerException e) {
            logger.debug("Exception while shutting down quartz scheduler this will be ignored:", (Throwable)e);
        }
    }

    public void trigger() {
        try {
            this.quartz.triggerJobWithVolatileTrigger(this.getJobName(), this.getJobGroup());
        }
        catch (Exception e) {
            logger.error("Error triggering Quartz job", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public static abstract class TypedQuartzJob<A>
    implements Job {
        private final Option<NeedleEye> allowParallel;

        protected TypedQuartzJob(Option<NeedleEye> allowParallel) {
            this.allowParallel = allowParallel;
        }

        public final void execute(JobExecutionContext ctx) throws JobExecutionException {
            Iterator iterator = this.allowParallel.iterator();
            if (iterator.hasNext()) {
                NeedleEye eye = (NeedleEye)iterator.next();
                eye.apply(this.executeF(ctx));
                return;
            }
            this.executeF(ctx).apply();
        }

        protected abstract void execute(A var1, JobExecutionContext var2);

        private Function0<Integer> executeF(final JobExecutionContext ctx) {
            return new Function0.X<Integer>(){

                public Integer xapply() throws Exception {
                    try {
                        this.execute(ctx.getJobDetail().getJobDataMap().get((Object)AbstractScanner.JOB_PARAM_PARENT), ctx);
                        return 0;
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while harvesting schedule", (Throwable)e);
                        throw new JobExecutionException("An error occurred while harvesting schedule", (Throwable)e);
                    }
                }
            };
        }
    }
}

