/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.scanner;

import java.util.Dictionary;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.scanner.AbstractScanner;
import org.osgi.service.cm.ConfigurationException;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBufferScanner
extends AbstractScanner {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBufferScanner.class);
    protected static final String PARAM_KEY_BUFFER = "buffer";
    protected long buffer = -1L;

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.unschedule();
        if (properties != null) {
            logger.debug("Updating configuration...");
            boolean enabled = BooleanUtils.toBoolean((String)((String)properties.get("enabled")));
            this.setEnabled(enabled);
            logger.debug("enabled = " + enabled);
            String cronExpression = (String)properties.get("cron-expression");
            if (StringUtils.isBlank((CharSequence)cronExpression) || !CronExpression.isValidExpression((String)cronExpression)) {
                throw new ConfigurationException("cron-expression", "Cron expression must be valid");
            }
            this.setCronExpression(cronExpression);
            logger.debug("cronExpression = '" + cronExpression + "'");
            try {
                this.buffer = Long.valueOf((String)properties.get(PARAM_KEY_BUFFER));
                if (this.buffer < 0L) {
                    throw new ConfigurationException(PARAM_KEY_BUFFER, "Buffer must be 0 or greater");
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_BUFFER, "Buffer must be a valid integer", (Throwable)e);
            }
            logger.debug("buffer = " + this.buffer);
        }
        this.schedule();
    }

    public long getBuffer() {
        return this.buffer;
    }

    public void setBuffer(long buffer) {
        this.buffer = buffer;
    }
}

