/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.filter.proxy;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.filter.proxy.TransparentProxyRequestWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=Transparent Proxy Filter"})
@ServiceRanking(value=6)
@HttpWhiteboardFilterName(value="TransparentProxyFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class TransparentProxyFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TransparentProxyFilter.class);
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object httpReqquest = (HttpServletRequest)request;
        if (StringUtils.isNotBlank((CharSequence)httpReqquest.getHeader(X_FORWARDED_FOR))) {
            logger.debug("Found X-Forwarded-For header. Resetting source IP");
            httpReqquest = new TransparentProxyRequestWrapper((HttpServletRequest)httpReqquest);
        }
        chain.doFilter((ServletRequest)httpReqquest, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

