/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.filter.https;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opencastproject.kernel.filter.https.HttpsRequestWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=Https Filter"})
@ServiceRanking(value=990)
@HttpWhiteboardFilterName(value="HttpsFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class HttpsFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HttpsFilter.class);
    private static final String X_FORWARDED_SSL = "X-Forwarded-SSL";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_SSL_VALUE = "on";
    private static final String X_FORWARDED_PROTO_VALUE = "https";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object httpReqquest = (HttpServletRequest)request;
        if (X_FORWARDED_SSL_VALUE.equalsIgnoreCase(httpReqquest.getHeader(X_FORWARDED_SSL))) {
            logger.debug("Found forwarded SSL header");
            httpReqquest = new HttpsRequestWrapper((HttpServletRequest)httpReqquest);
        } else if (X_FORWARDED_PROTO_VALUE.equalsIgnoreCase(httpReqquest.getHeader(X_FORWARDED_PROTO))) {
            logger.debug("Found forwarded proto HTTPS header");
            httpReqquest = new HttpsRequestWrapper((HttpServletRequest)httpReqquest);
        }
        chain.doFilter((ServletRequest)httpReqquest, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

