/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.bundleinfo;

import java.util.List;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.opencastproject.kernel.bundleinfo.BundleInfo;
import org.opencastproject.kernel.bundleinfo.BundleInfoDb;
import org.opencastproject.kernel.bundleinfo.BundleVersion;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestService(name="systemInfo", title="System Bundle Info", notes={"This is used to display the version information on the login page."}, abstractText="The system bundle info endpoint yields information about the running OSGi bundles of Opencast.")
public abstract class BundleInfoRestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(BundleInfoRestEndpoint.class);
    private static final String DEFAULT_BUNDLE_PREFIX = "opencast";
    private long lastModified = 0L;
    public static final Function<BundleVersion, Jsons.Obj> fullVersionJson = new Function<BundleVersion, Jsons.Obj>(){

        public Jsons.Obj apply(BundleVersion version) {
            return Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"version", (String)version.getBundleVersion()), Jsons.p((String)"buildNumber", (Option)version.getBuildNumber().map(Jsons.stringVal))});
        }
    };
    public static final Function<BundleInfo, Jsons.Obj> bundleInfo = new Function<BundleInfo, Jsons.Obj>(){

        public Jsons.Obj apply(BundleInfo bundle) {
            return BundleInfoRestEndpoint.bundleInfoJson(bundle);
        }
    };

    protected abstract BundleInfoDb getDb();

    @Activate
    public void activate(ComponentContext cc) {
        this.lastModified = cc.getBundleContext().getBundle().getLastModified();
    }

    @GET
    @Path(value="bundles/list")
    @Produces(value={"application/json"})
    @RestQuery(name="list", description="Return a list of all running bundles on the whole cluster.", responses={@RestResponse(description="A list of bundles.", responseCode=200)}, returnDescription="The search results, expressed as xml or json.")
    public Response getVersions() {
        Monadics.ListMonadic bundleInfos = Monadics.mlist(this.getDb().getBundles()).map(Functions.co(bundleInfo));
        return RestUtil.R.ok((Jsons.Obj)Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"bundleInfos", (Jsons.Val)Jsons.arr((Monadics.ListMonadic)bundleInfos)), Jsons.p((String)"count", (Number)bundleInfos.value().size())}));
    }

    @GET
    @Path(value="bundles/check")
    @RestQuery(name="check", description="Check if all bundles throughout the cluster have the same OSGi bundle version and build number.", restParameters={@RestParameter(name="prefix", description="The bundle name prefixes to check. Defaults to 'opencast'.", isRequired=false, defaultValue="opencast", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="true/false", responseCode=200), @RestResponse(description="cannot find any bundles with the given prefix", responseCode=404)}, returnDescription="The search results, expressed as xml or json.")
    public Response checkBundles(@DefaultValue(value="opencast") @QueryParam(value="prefix") List<String> prefixes) {
        return this.withBundles(prefixes, new Function<List<BundleInfo>, Response>(){

            public Response apply(List<BundleInfo> infos) {
                String bundleVersion = infos.get(0).getBundleVersion();
                Option<String> buildNumber = infos.get(0).getBuildNumber();
                for (BundleInfo a : infos) {
                    if (!EqualsUtil.ne((Object)a.getBundleVersion(), (Object)bundleVersion) && !EqualsUtil.ne(a.getBuildNumber(), buildNumber)) continue;
                    return RestUtil.R.ok((MediaType)MediaType.TEXT_PLAIN_TYPE, (Object)"false");
                }
                return RestUtil.R.ok((MediaType)MediaType.TEXT_PLAIN_TYPE, (Object)"true");
            }
        });
    }

    @GET
    @Path(value="bundles/version")
    @Produces(value={"application/json"})
    @RestQuery(name="bundleVersion", description="Return the common OSGi build version and build number of all bundles matching the given prefix.", restParameters={@RestParameter(name="prefix", description="The bundle name prefixes to check. Defaults to 'opencast'.", isRequired=false, defaultValue="opencast", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Version structure", responseCode=200), @RestResponse(description="No bundles with the given prefix", responseCode=404)}, returnDescription="The search results as json.")
    public Response getBundleVersion(@DefaultValue(value="opencast") @QueryParam(value="prefix") List<String> prefixes) {
        return this.withBundles(prefixes, new Function<List<BundleInfo>, Response>(){

            public Response apply(List<BundleInfo> infos) {
                Set versions = Collections.set((Object[])new BundleVersion[0]);
                for (BundleInfo bundle : infos) {
                    versions.add(bundle.getVersion());
                }
                BundleInfo example = infos.get(0);
                switch (versions.size()) {
                    case 0: {
                        throw new Error("bug");
                    }
                    case 1: {
                        return RestUtil.R.ok((Jsons.Obj)Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"consistent", (Boolean)true)}).append((Jsons.Obj)fullVersionJson.apply((Object)example.getVersion())).append(Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"last-modified", (Number)BundleInfoRestEndpoint.this.lastModified)})));
                    }
                }
                return RestUtil.R.ok((Jsons.Obj)Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"consistent", (Boolean)false), Jsons.p((String)"versions", (Jsons.Val)Jsons.arr((Monadics.ListMonadic)Monadics.mlist(versions.iterator()).map(Functions.co(fullVersionJson))))}));
            }
        });
    }

    @DELETE
    @Path(value="bundles/host")
    @RestQuery(name="clearHost", description="Removes the tracked bundles for a host. This is done automatically when you shut down Opencast. But this endpoint can be used to force this in case e.g. a machine got dropped. Make sure the host is actually gone! The database will be automatically rebuilt when Opencast on that host is (re)started.", restParameters={@RestParameter(name="host", description="The name of the host to clear", isRequired=true, type=RestParameter.Type.STRING, defaultValue="")}, responses={@RestResponse(description="Version structure", responseCode=204)}, returnDescription="No data is returned.")
    public Response clearHost(@QueryParam(value="host") String host) {
        logger.debug("Removing tracked bundles of host: {}", (Object)host);
        this.getDb().clear(host);
        return Response.noContent().build();
    }

    public static Jsons.Obj bundleInfoJson(BundleInfo bundle) {
        return Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"host", (String)bundle.getHost()), Jsons.p((String)"bundleSymbolicName", (String)bundle.getBundleSymbolicName()), Jsons.p((String)"bundleId", (Number)bundle.getBundleId())}).append((Jsons.Obj)fullVersionJson.apply((Object)bundle.getVersion()));
    }

    private Response withBundles(List<String> prefixes, Function<List<BundleInfo>, Response> f) {
        List<BundleInfo> info = this.getDb().getBundles((String[])Collections.toArray(String.class, prefixes));
        if (info.size() > 0) {
            return (Response)f.apply(info);
        }
        return RestUtil.R.notFound((Object)"No bundles match one of the given prefixes");
    }
}

