/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.bundleinfo;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.Queries;
import org.opencastproject.kernel.bundleinfo.BundleInfo;
import org.opencastproject.kernel.bundleinfo.BundleInfoDb;
import org.opencastproject.kernel.bundleinfo.BundleInfoDbException;
import org.opencastproject.kernel.bundleinfo.BundleInfoJpa;

public abstract class AbstractBundleInfoDb
implements BundleInfoDb {
    protected abstract DBSession getDBSession();

    @Override
    public void store(BundleInfo info) {
        this.tx(Queries.namedQuery.persist((Object)BundleInfoJpa.create(info)));
    }

    @Override
    public void delete(String host, long bundleId) {
        this.tx(BundleInfoJpa.delete(host, bundleId));
    }

    @Override
    public void clear(String host) {
        this.tx(BundleInfoJpa.deleteByHost(host));
    }

    @Override
    public void clearAll() throws BundleInfoDbException {
        this.tx(BundleInfoJpa.deleteAll);
    }

    @Override
    public List<BundleInfo> getBundles() {
        return this.tx(BundleInfoJpa.findAll).stream().map(BundleInfoJpa::toBundleInfo).collect(Collectors.toList());
    }

    @Override
    public List<BundleInfo> getBundles(String ... prefixes) throws BundleInfoDbException {
        return this.tx(BundleInfoJpa.findAll(prefixes)).stream().map(BundleInfoJpa::toBundleInfo).collect(Collectors.toList());
    }

    private <A> A tx(Function<EntityManager, A> fn) {
        try {
            return (A)this.getDBSession().execTx(fn);
        }
        catch (Exception e) {
            throw new BundleInfoDbException(e);
        }
    }
}

