/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.scanner;

import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.security.util.SecurityContext;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ingestor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Ingestor.class);
    private final IngestService ingestService;
    private final SecurityContext secCtx;
    private final String workflowDefinition;
    private final Map<String, String> workflowConfig;
    private final MediaPackageElementFlavor mediaFlavor;
    private final File inbox;
    private final SeriesService seriesService;
    private final SchedulerService schedulerService;
    private final Workspace workspace;
    private final int maxTries;
    private final int secondsBetweenTries;
    private RateLimiter throttle = RateLimiter.create((double)1.0);
    private final Optional<Pattern> metadataPattern;
    private final DateTimeFormatter dateFormatter;
    private final String ffprobe;
    private final Gson gson = new Gson();
    private final boolean matchSchedule;
    private final float matchThreshold;
    private final ExecutorService executorService;
    private final CompletionService<RetriableIngestJob> completionService;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Future<RetriableIngestJob> f;
                    RetriableIngestJob task;
                    if (!(task = (f = this.completionService.take()).get()).hasFailed()) {
                        continue;
                    }
                    if (task.getRetryCount() < this.maxTries) {
                        this.throttle.acquire();
                        logger.warn("Retrying inbox ingest of {}", (Object)task.getArtifact().getAbsolutePath());
                        this.completionService.submit(task);
                        continue;
                    }
                    logger.error("Inbox ingest failed after {} tries for {}", (Object)this.maxTries, (Object)task.getArtifact().getAbsolutePath());
                }
            }
            catch (InterruptedException e) {
                logger.debug("Ingestor check interrupted", (Throwable)e);
                return;
            }
            catch (ExecutionException e) {
                logger.error("Ingestor check interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public Ingestor(IngestService ingestService, SecurityContext secCtx, String workflowDefinition, Map<String, String> workflowConfig, String mediaFlavor, File inbox, int maxThreads, SeriesService seriesService, int maxTries, int secondsBetweenTries, Optional<Pattern> metadataPattern, DateTimeFormatter dateFormatter, SchedulerService schedulerService, String ffprobe, boolean matchSchedule, float matchThreshold, Workspace workspace) {
        this.ingestService = ingestService;
        this.secCtx = secCtx;
        this.workflowDefinition = workflowDefinition;
        this.workflowConfig = workflowConfig;
        this.mediaFlavor = MediaPackageElementFlavor.parseFlavor((String)mediaFlavor);
        this.inbox = inbox;
        this.executorService = Executors.newFixedThreadPool(maxThreads);
        this.completionService = new ExecutorCompletionService<RetriableIngestJob>(this.executorService);
        this.seriesService = seriesService;
        this.maxTries = maxTries;
        this.secondsBetweenTries = secondsBetweenTries;
        this.metadataPattern = metadataPattern;
        this.dateFormatter = dateFormatter;
        this.schedulerService = schedulerService;
        this.ffprobe = ffprobe;
        this.matchSchedule = matchSchedule;
        this.matchThreshold = matchThreshold;
        this.workspace = workspace;
    }

    public void ingest(File artifact) {
        logger.info("Try ingest of file {}", (Object)artifact.getName());
        this.completionService.submit(new RetriableIngestJob(artifact, this.secondsBetweenTries));
    }

    public boolean canHandle(File artifact) {
        logger.trace("canHandle() {}, {}", (Object)this.myInfo(), (Object)artifact.getAbsolutePath());
        File dir = artifact.getParentFile();
        try {
            return dir != null && !artifact.getName().startsWith(".") && FileUtils.directoryContains((File)this.inbox, (File)artifact) && artifact.canRead() && artifact.length() > 0L;
        }
        catch (IOException e) {
            logger.warn("Unable to determine canonical path of {}", (Object)artifact.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void cleanup(File artifact) {
        try {
            String[] filesList;
            File parentDir = artifact.getParentFile();
            if (FileUtils.directoryContains((File)this.inbox, (File)parentDir) && ((filesList = parentDir.list()) == null || filesList.length == 0)) {
                logger.info("Delete empty inbox for series {}", (Object)StringUtils.substring((String)parentDir.getCanonicalPath(), (int)(this.inbox.getCanonicalPath().length() + 1)));
                FileUtils.deleteDirectory((File)parentDir);
            }
        }
        catch (Exception e) {
            logger.error("Unable to cleanup inbox for the artifact {}", (Object)artifact, (Object)e);
        }
    }

    private MediaPackage updateDublincCoreCatalog(MediaPackage mp, DublinCoreCatalog dc) throws IOException, MediaPackageException {
        block7: {
            try (InputStream inputStream = IOUtils.toInputStream((String)dc.toXmlString(), (String)"UTF-8");){
                Catalog[] catalogs = mp.getCatalogs(MediaPackageElements.EPISODE);
                if (catalogs.length > 0) {
                    Catalog catalog = catalogs[0];
                    URI uri = this.workspace.put(mp.getIdentifier().toString(), catalog.getIdentifier(), "dublincore.xml", inputStream);
                    catalog.setURI(uri);
                    catalog.setChecksum(null);
                    break block7;
                }
                throw new MediaPackageException("Unable to find catalog");
            }
        }
        return mp;
    }

    public String myInfo() {
        return String.format("[%x thread=%x]", this.hashCode(), Thread.currentThread().getId());
    }

    class JsonTags {
        @SerializedName(value="creation_time")
        private String creationTime;

        JsonTags() {
        }

        Date getCreationTime() throws ParseException {
            if (this.creationTime == null) {
                return null;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
            return format.parse(this.creationTime.replaceAll("000Z$", "+0000"));
        }

        public String toString() {
            return String.format("{creation_time=%s}", this.creationTime);
        }
    }

    class JsonFormat {
        private String duration;
        protected JsonTags tags;

        JsonFormat() {
        }

        Float getDuration() {
            return this.duration == null ? null : Float.valueOf(Float.parseFloat(this.duration));
        }

        public String toString() {
            return String.format("{duration=%s,tags=%s}", this.duration, this.tags);
        }
    }

    class JsonFFprobe {
        protected JsonFormat format;

        JsonFFprobe() {
        }
    }

    private class RetriableIngestJob
    implements Callable<RetriableIngestJob> {
        private final File artifact;
        private int retryCount;
        private boolean failed;
        private RateLimiter throttle;

        RetriableIngestJob(File artifact, int secondsBetweenTries) {
            this.artifact = artifact;
            this.retryCount = 0;
            this.failed = false;
            this.throttle = RateLimiter.create((double)(1.0 / (double)secondsBetweenTries));
        }

        public boolean hasFailed() {
            return this.failed;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public File getArtifact() {
            return this.artifact;
        }

        @Override
        public RetriableIngestJob call() {
            return (RetriableIngestJob)Ingestor.this.secCtx.runInContext(() -> {
                block49: {
                    if (this.hasFailed()) {
                        logger.warn("This is retry number {} for file {}. We will wait for {} seconds before trying again", new Object[]{this.retryCount, this.artifact.getName(), Ingestor.this.secondsBetweenTries});
                        this.throttle.acquire();
                    }
                    try (FileInputStream in = new FileInputStream(this.artifact);){
                        this.failed = false;
                        ++this.retryCount;
                        if ("zip".equalsIgnoreCase(FilenameUtils.getExtension((String)this.artifact.getName()))) {
                            logger.info("Start ingest inbox file {} as a zipped mediapackage", (Object)this.artifact.getName());
                            WorkflowInstance workflowInstance = Ingestor.this.ingestService.addZippedMediaPackage((InputStream)in, Ingestor.this.workflowDefinition, Ingestor.this.workflowConfig);
                            logger.info("Ingested {} as a zipped mediapackage from inbox as {}. Started workflow {}.", new Object[]{this.artifact.getName(), workflowInstance.getMediaPackage().getIdentifier().toString(), workflowInstance.getId()});
                            break block49;
                        }
                        logger.info("Start ingest track from file {}", (Object)this.artifact.getName());
                        String title = this.artifact.getName();
                        String spatial = null;
                        Date created = null;
                        Float duration = null;
                        if (Ingestor.this.metadataPattern.isPresent()) {
                            Matcher matcher = Ingestor.this.metadataPattern.get().matcher(this.artifact.getName());
                            if (matcher.find()) {
                                try {
                                    title = matcher.group("title");
                                }
                                catch (IllegalArgumentException e2) {
                                    logger.debug("{} matches no 'title' in {}", new Object[]{Ingestor.this.metadataPattern.get(), this.artifact.getName(), e2});
                                }
                                try {
                                    spatial = matcher.group("spatial");
                                }
                                catch (IllegalArgumentException e3) {
                                    logger.debug("{} matches no 'spatial' in {}", new Object[]{Ingestor.this.metadataPattern.get(), this.artifact.getName(), e3});
                                }
                                try {
                                    String value = matcher.group("created");
                                    logger.debug("Trying to parse matched date '{}' with formatter {}", (Object)value, (Object)Ingestor.this.dateFormatter);
                                    created = Timestamp.valueOf(LocalDateTime.parse(value, Ingestor.this.dateFormatter));
                                }
                                catch (DateTimeParseException e4) {
                                    logger.warn("Matched date does not match configured date-time format", (Throwable)e4);
                                }
                                catch (IllegalArgumentException e5) {
                                    logger.debug("{} matches no 'created' in {}", new Object[]{Ingestor.this.metadataPattern.get(), this.artifact.getName(), e5});
                                }
                            } else {
                                logger.debug("Regular expression {} does not match {}", (Object)Ingestor.this.metadataPattern.get(), (Object)this.artifact.getName());
                            }
                        }
                        if (Ingestor.this.ffprobe != null) {
                            JsonFormat json = this.probeMedia((String)this.artifact.getAbsolutePath()).format;
                            created = json.tags.getCreationTime() == null ? created : json.tags.getCreationTime();
                            duration = json.getDuration();
                            logger.debug("Extracted metadata from file: {}", (Object)json);
                        }
                        MediaPackage mediaPackage = null;
                        String currentWorkflowDefinition = Ingestor.this.workflowDefinition;
                        Map<String, String> currentWorkflowConfig = Ingestor.this.workflowConfig;
                        if (Ingestor.this.matchSchedule && spatial != null && created != null) {
                            logger.debug("Try finding scheduled event for agent {} at time {}", (Object)spatial, (Object)created);
                            Date end = duration == null ? created : DateUtils.addSeconds((Date)created, (int)duration.intValue());
                            ArrayList<MediaPackage> mediaPackages = Ingestor.this.schedulerService.findConflictingEvents(spatial, created, end);
                            if (Ingestor.this.matchThreshold > 0.0f && mediaPackages.size() > 1) {
                                ArrayList<MediaPackage> filteredMediaPackages = new ArrayList<MediaPackage>();
                                for (MediaPackage mp : mediaPackages) {
                                    TechnicalMetadata schedule = Ingestor.this.schedulerService.getTechnicalMetadata(mp.getIdentifier().toString());
                                    if (!(this.overlap(schedule.getStartDate(), schedule.getEndDate(), created, end) > Ingestor.this.matchThreshold)) continue;
                                    filteredMediaPackages.add(mp);
                                }
                                mediaPackages = filteredMediaPackages;
                            }
                            if (mediaPackages.size() > 1) {
                                logger.warn("Metadata match multiple events. Not using any!");
                            } else if (mediaPackages.size() == 1) {
                                mediaPackage = (MediaPackage)mediaPackages.get(0);
                                String id = mediaPackage.getIdentifier().toString();
                                Map eventConfiguration = Ingestor.this.schedulerService.getCaptureAgentConfiguration(id);
                                try {
                                    Recording recordingState = Ingestor.this.schedulerService.getRecordingState(id);
                                    if (recordingState.getState().equals("upload_finished")) {
                                        String referenceId = mediaPackage.getIdentifier().toString();
                                        mediaPackage = (MediaPackage)mediaPackage.clone();
                                        mediaPackage.setIdentifier(IdImpl.fromUUID());
                                        for (Track track : mediaPackage.getTracks()) {
                                            logger.info("Remove track: " + track);
                                            mediaPackage.remove(track);
                                        }
                                        try {
                                            DublinCoreCatalog dc = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)Ingestor.this.workspace, (MediaPackage)mediaPackage).get();
                                            String newTitle = ((DublinCoreValue)dc.get(DublinCore.PROPERTY_TITLE).get(0)).getValue() + " (" + Instant.now().getEpochSecond() + ")";
                                            dc.set(DublinCore.PROPERTY_TITLE, newTitle);
                                            dc.set(DublinCore.PROPERTY_REFERENCES, referenceId);
                                            mediaPackage = Ingestor.this.updateDublincCoreCatalog(mediaPackage, dc);
                                            mediaPackage.setTitle(newTitle);
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                catch (NotFoundException notFoundException) {
                                    // empty catch block
                                }
                                currentWorkflowDefinition = eventConfiguration.getOrDefault("org.opencastproject.workflow.definition", Ingestor.this.workflowDefinition);
                                currentWorkflowConfig = eventConfiguration.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("org.opencastproject.workflow.config.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(36), Map.Entry::getValue));
                                Ingestor.this.schedulerService.updateRecordingState(id, "upload_finished");
                                logger.info("Found matching scheduled event {}", (Object)mediaPackage);
                            } else {
                                logger.debug("No matching event found.");
                            }
                        }
                        if (mediaPackage == null) {
                            String seriesID;
                            mediaPackage = Ingestor.this.ingestService.createMediaPackage();
                            DublinCoreCatalog dcc = DublinCores.mkOpencastEpisode().getCatalog();
                            if (spatial != null) {
                                dcc.add(DublinCore.PROPERTY_SPATIAL, spatial);
                            }
                            if (created != null) {
                                dcc.add(DublinCore.PROPERTY_CREATED, EncodingSchemeUtils.encodeDate((Date)created, (Precision)Precision.Second));
                            }
                            dcc.add(DublinCore.PROPERTY_TITLE, title);
                            File dir = this.artifact.getParentFile();
                            if (FileUtils.directoryContains((File)Ingestor.this.inbox, (File)dir) && Ingestor.this.seriesService.getSeries(seriesID = dir.getName()) != null) {
                                logger.info("Ingest from inbox into series with id {}", (Object)seriesID);
                                dcc.add(DublinCore.PROPERTY_IS_PART_OF, seriesID);
                            }
                            try (ByteArrayOutputStream dcout = new ByteArrayOutputStream();){
                                dcc.toXml((OutputStream)dcout, true);
                                try (ByteArrayInputStream dcin = new ByteArrayInputStream(dcout.toByteArray());){
                                    mediaPackage = Ingestor.this.ingestService.addCatalog((InputStream)dcin, "dublincore.xml", MediaPackageElements.EPISODE, mediaPackage);
                                    logger.info("Added DC catalog to media package for ingest from inbox");
                                }
                            }
                        }
                        mediaPackage = Ingestor.this.ingestService.addTrack((InputStream)in, this.artifact.getName(), Ingestor.this.mediaFlavor, mediaPackage);
                        logger.info("Ingested track from file {} to media package {}", (Object)this.artifact.getName(), (Object)mediaPackage.getIdentifier().toString());
                        WorkflowInstance workflowInstance = Ingestor.this.ingestService.ingest(mediaPackage, currentWorkflowDefinition, currentWorkflowConfig);
                        logger.info("Ingested {} from inbox, workflow {} started", (Object)this.artifact.getName(), (Object)workflowInstance.getId());
                    }
                    catch (Exception e6) {
                        logger.error("Error ingesting inbox file {}", (Object)this.artifact.getName(), (Object)e6);
                        this.failed = true;
                        return this;
                    }
                }
                try {
                    FileUtils.forceDelete((File)this.artifact);
                }
                catch (IOException e7) {
                    logger.error("Unable to delete file {}", (Object)this.artifact.getAbsolutePath(), (Object)e7);
                }
                return this;
            });
        }

        private JsonFFprobe probeMedia(String file) throws IOException {
            String output;
            String[] command = new String[]{Ingestor.this.ffprobe, "-show_format", "-of", "json", file};
            logger.debug("Running ffprobe: {}", (Object)command);
            Process process = null;
            try {
                process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                try (InputStream in = process.getInputStream();){
                    output = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                }
                if (process.waitFor() != 0) {
                    throw new IOException("FFprobe exited abnormally");
                }
            }
            catch (InterruptedException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    IoSupport.closeQuietly(process);
                    throw throwable;
                }
            }
            IoSupport.closeQuietly((Process)process);
            return (JsonFFprobe)Ingestor.this.gson.fromJson(output, JsonFFprobe.class);
        }

        private float overlap(Date aStart, Date aEnd, Date bStart, Date bEnd) {
            long min = Math.min(aStart.getTime(), bStart.getTime());
            long max = Math.max(aEnd.getTime(), bEnd.getTime());
            long aLen = aEnd.getTime() - aStart.getTime();
            long bLen = bEnd.getTime() - bStart.getTime();
            long overlap = aLen + bLen - (max - min);
            logger.debug("Detected overlap of {} ({})", (Object)overlap, (Object)Float.valueOf((float)overlap / (float)aLen));
            if ((float)aLen == 0.0f) {
                return 1.0f;
            }
            if ((float)overlap > 0.0f) {
                return (float)overlap / (float)aLen;
            }
            return 0.0f;
        }
    }
}

