/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.impl.jmx;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.opencastproject.ingest.impl.jmx.IngestStatisticsMXBean;

public class IngestStatistics
implements IngestStatisticsMXBean {
    private long totalNumBytesRead = 0L;
    private int successful = 0;
    private int failed = 0;
    private Cache<Long, Long> bytesCounter = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();

    @Override
    public int getSuccessfulIngestOperations() {
        return this.successful;
    }

    @Override
    public int getFailedIngestOperations() {
        return this.failed;
    }

    @Override
    public long getTotalBytes() {
        return this.totalNumBytesRead;
    }

    @Override
    public long getBytesInLastMinute() {
        long key = this.getKeyByTime(new DateTime().minusMinutes(1).getMillis());
        return key != 0L ? this.totalNumBytesRead - (Long)this.bytesCounter.getIfPresent((Object)key) : 0L;
    }

    @Override
    public long getBytesInLastFiveMinutes() {
        long key = this.getKeyByTime(new DateTime().minusMinutes(5).getMillis());
        return key != 0L ? this.totalNumBytesRead - (Long)this.bytesCounter.getIfPresent((Object)key) : 0L;
    }

    @Override
    public long getBytesInLastFifteenMinutes() {
        long key = this.getKeyByTime(new DateTime().minusMinutes(15).getMillis());
        return key != 0L ? this.totalNumBytesRead - (Long)this.bytesCounter.getIfPresent((Object)key) : 0L;
    }

    private long getKeyByTime(long timeBeforeFiveMinute) {
        long key = 0L;
        ArrayList bytes = new ArrayList(this.bytesCounter.asMap().keySet());
        Collections.sort(bytes);
        for (Long milis : bytes) {
            if (milis <= timeBeforeFiveMinute) continue;
            key = milis;
            break;
        }
        return key;
    }

    public void add(long bytes) {
        if (this.totalNumBytesRead == 0L) {
            this.bytesCounter.put((Object)System.currentTimeMillis(), (Object)0L);
        }
        this.totalNumBytesRead += bytes;
        this.bytesCounter.put((Object)System.currentTimeMillis(), (Object)this.totalNumBytesRead);
    }

    public void successful() {
        ++this.successful;
    }

    public void failed() {
        ++this.failed;
    }
}

