/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.File;
import de.schlichtherle.io.swing.tree.FileTreeCellRenderer;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JFileTree
extends JTree {
    private static final String PROPERTY_DISPLAYING_SUFFIXES = "displayingSuffixes";
    private static final String PROPERTY_EDITING_SUFFIXES = "editingSuffixes";
    private static final String PROPERTY_DEFAULT_SUFFIX = "defaultSuffix";
    private final Controller controller = new Controller();
    private boolean displayingSuffixes = true;
    private boolean editingSuffixes = true;
    private String defaultSuffix;
    private java.io.File editedNode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JFileTree() {
        this(new FileTreeModel());
    }

    public JFileTree(java.io.File root) {
        this(new FileTreeModel(root));
    }

    public JFileTree(FileTreeModel model) {
        super(model);
        super.setCellRenderer(this.createTreeCellRenderer());
        super.addTreeExpansionListener(this.controller);
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        return new FileTreeCellRenderer(this);
    }

    public void setModel(TreeModel model) {
        super.setModel((FileTreeModel)model);
    }

    public void setEditable(boolean editable) {
        if (editable) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor ce = this.getCellEditor();
            if (ce != null) {
                ce.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingSuffixes() {
        return this.displayingSuffixes;
    }

    public void setDisplayingSuffixes(boolean displayingSuffixes) {
        boolean oldDisplayingSuffixes = this.displayingSuffixes;
        this.displayingSuffixes = displayingSuffixes;
        this.firePropertyChange(PROPERTY_DISPLAYING_SUFFIXES, oldDisplayingSuffixes, displayingSuffixes);
    }

    public boolean isEditingSuffixes() {
        return this.editingSuffixes;
    }

    public void setEditingSuffixes(boolean editingSuffixes) {
        boolean oldEditingSuffixes = this.editingSuffixes;
        this.editingSuffixes = editingSuffixes;
        this.firePropertyChange(PROPERTY_EDITING_SUFFIXES, oldEditingSuffixes, editingSuffixes);
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String defaultSuffix) {
        String oldDefaultSuffix = this.defaultSuffix;
        if (defaultSuffix != null) {
            if ((defaultSuffix = defaultSuffix.trim()).length() <= 0) {
                defaultSuffix = null;
            } else if (defaultSuffix.charAt(0) != '.') {
                defaultSuffix = "." + defaultSuffix;
            }
        }
        this.defaultSuffix = defaultSuffix;
        this.firePropertyChange(PROPERTY_DEFAULT_SUFFIX, oldDefaultSuffix, defaultSuffix);
    }

    public java.io.File getEditedNode() {
        return this.editedNode;
    }

    public boolean isEditing() {
        return this.editedNode != null;
    }

    public void startEditingAtPath(TreePath path) {
        this.editedNode = (java.io.File)path.getLastPathComponent();
        super.startEditingAtPath(path);
    }

    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    public boolean stopEditing() {
        boolean stop = super.stopEditing();
        if (stop) {
            this.editedNode = null;
        }
        return stop;
    }

    protected void onEditingStopped(ChangeEvent evt) {
        File node;
        TreeCellEditor tce = (TreeCellEditor)evt.getSource();
        String base = tce.getCellEditorValue().toString().trim();
        java.io.File oldNode = (java.io.File)this.getLeadSelectionPath().getLastPathComponent();
        java.io.File parent = oldNode.getParentFile();
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!oldNode.isDirectory()) {
            String suffix;
            if (this.isDisplayingSuffixes() && this.isEditingSuffixes()) {
                String defaultSuffix;
                suffix = this.getSuffix(base);
                if (suffix == null && (defaultSuffix = this.getDefaultSuffix()) != null) {
                    base = base + defaultSuffix;
                }
            } else {
                suffix = this.getSuffix(oldNode.getName());
                if (suffix != null) {
                    base = base + suffix;
                }
            }
        }
        if (!this.renameTo(oldNode, node = new File(parent, base))) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String getSuffix(String base) {
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(i) : null;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        java.io.File node = (java.io.File)value;
        java.io.File editedNode = this.getEditedNode();
        if (node != editedNode && !node.exists()) {
            return "?";
        }
        String base = node.getName();
        if (base.length() <= 0) {
            return node.getPath();
        }
        if (node.isDirectory() || this.isDisplayingSuffixes() && (!node.equals(editedNode) || this.isEditingSuffixes())) {
            return base;
        }
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(0, i) : base;
    }

    public void refresh() {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath((java.io.File)ftm.getRoot());
        if (path != null) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(java.io.File node) {
        if (node == null) {
            throw new NullPointerException();
        }
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path != null) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TreePath[] paths) {
        if (paths == null || paths.length <= 0) {
            return;
        }
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath lead = this.getLeadSelectionPath();
        TreePath anchor = this.getAnchorSelectionPath();
        TreePath[] selections = this.getSelectionPaths();
        int l = paths.length;
        for (int i = 0; i < l; ++i) {
            TreePath path = paths[i];
            Enumeration<TreePath> expansions = this.getExpandedDescendants(path);
            ftm.refresh((java.io.File)path.getLastPathComponent());
            this.setExpandedDescendants(expansions);
        }
        this.setSelectionPaths(selections);
        this.setAnchorSelectionPath(anchor);
        this.setLeadSelectionPath(lead);
        this.scrollPathToVisible(lead);
    }

    private void setExpandedDescendants(Enumeration expansions) {
        if (expansions == null) {
            return;
        }
        while (expansions.hasMoreElements()) {
            this.setExpandedState((TreePath)expansions.nextElement(), true);
        }
    }

    public boolean createNewFile(java.io.File node) throws IOException {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.createNewFile(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean mkdir(java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.mkdir(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean mkdirs(java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.mkdirs(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyFrom(File node, InputStream in) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyFrom(node, in)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyTo(File oldNode, java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyAllTo(File oldNode, java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyAllTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean archiveCopyTo(File oldNode, java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.archiveCopyTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean archiveCopyAllTo(File oldNode, java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.archiveCopyAllTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean renameTo(java.io.File oldNode, java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        TreePath oldPath = ftm.createTreePath(oldNode);
        Enumeration<TreePath> expansions = oldPath != null ? this.getExpandedDescendants(oldPath) : null;
        if (!ftm.renameTo(oldNode, node)) {
            return false;
        }
        if (expansions != null) {
            while (expansions.hasMoreElements()) {
                this.setExpandedState(this.substPath(expansions.nextElement(), oldPath, path), true);
            }
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    private TreePath substPath(TreePath tp, TreePath oldPath, TreePath path) {
        java.io.File file = (java.io.File)tp.getLastPathComponent();
        if (file.equals(oldPath.getLastPathComponent())) {
            return path;
        }
        TreePath parent = this.substPath(tp.getParentPath(), oldPath, path);
        return parent.pathByAddingChild(new File((java.io.File)parent.getLastPathComponent(), file.getName()));
    }

    public boolean delete(java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        if (!ftm.delete(node)) {
            return false;
        }
        this.setSelectionRow(row);
        return true;
    }

    public boolean deleteAll(File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path == null) {
            return false;
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        if (!ftm.deleteAll(node)) {
            return false;
        }
        this.setSelectionRow(row);
        return true;
    }

    public void setSelectionNode(java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectionNodes(java.io.File[] nodes) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        TreePath lastPath = null;
        int l = nodes.length;
        for (int i = 0; i < l; ++i) {
            lastPath = ftm.createTreePath(nodes[i]);
            if (lastPath == null) continue;
            list.add(lastPath);
        }
        int size = list.size();
        if (size > 0) {
            TreePath[] paths = new TreePath[size];
            list.toArray(paths);
            this.setSelectionPaths(paths);
        }
    }

    public void scrollNodeToVisible(java.io.File node) {
        FileTreeModel ftm = (FileTreeModel)this.getModel();
        TreePath path = ftm.createTreePath(node);
        if (path != null) {
            this.scrollPathToVisible(path);
        }
    }

    static {
        $assertionsDisabled = !JFileTree.class.desiredAssertionStatus();
    }

    private class Controller
    implements TreeExpansionListener,
    CellEditorListener,
    Serializable {
        private Controller() {
        }

        public void treeCollapsed(TreeExpansionEvent evt) {
            ((FileTreeModel)JFileTree.this.getModel()).forget((java.io.File)evt.getPath().getLastPathComponent());
        }

        public void treeExpanded(TreeExpansionEvent evt) {
        }

        public void editingCanceled(ChangeEvent evt) {
        }

        public void editingStopped(ChangeEvent evt) {
            JFileTree.this.onEditingStopped(evt);
        }
    }
}

