/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fileupload.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opencastproject.fileupload.api.FileUploadService;
import org.opencastproject.fileupload.api.exception.FileUploadException;
import org.opencastproject.fileupload.api.job.Chunk;
import org.opencastproject.fileupload.api.job.FileUploadJob;
import org.opencastproject.fileupload.api.job.Payload;
import org.opencastproject.fileupload.service.FileUploadServiceCleaner;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.data.Function2;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Prelude;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Component(immediate=true, service={ManagedService.class, FileUploadService.class}, property={"service.description=Big File Upload Service"})
public class FileUploadServiceImpl
implements FileUploadService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceImpl.class);
    static final String PROPKEY_KARAF_DATA = "karaf.data";
    static final String PROPKEY_CLEANER_MAXTTL = "org.opencastproject.upload.cleaner.maxttl";
    static final String PROPKEY_UPLOAD_WORKDIR = "org.opencastproject.upload.workdir";
    static final String DEFAULT_UPLOAD_WORKDIR = "tmp/fileupload";
    static final String UPLOAD_COLLECTION = "uploaded";
    static final String FILEEXT_DATAFILE = ".payload";
    static final String FILENAME_CHUNKFILE = "chunk.part";
    static final String FILENAME_JOBFILE = "job.xml";
    static final int READ_BUFFER_LENGTH = 512;
    static final int DEFAULT_CLEANER_MAXTTL = 6;
    private File workRoot = null;
    private IngestService ingestService;
    private Workspace workspace;
    private Marshaller jobMarshaller;
    private Unmarshaller jobUnmarshaller;
    private HashMap<String, FileUploadJob> jobCache = new HashMap();
    private FileUploadServiceCleaner cleaner;
    private int jobMaxTTL = 6;
    private Function2<InputStream, File, Option<URI>> putInCollection = new Function2<InputStream, File, Option<URI>>(){

        public Option<URI> apply(InputStream is, File f) {
            try {
                URI uri = FileUploadServiceImpl.this.workspace.putInCollection(FileUploadServiceImpl.UPLOAD_COLLECTION, f.getName(), is);
                return Option.some((Object)uri);
            }
            catch (IOException e) {
                logger.error("Could not add file to collection.", (Throwable)e);
                return Option.none();
            }
        }
    };

    @Activate
    protected synchronized void activate(ComponentContext cc) throws Exception {
        if (this.workRoot == null) {
            String dir = cc.getBundleContext().getProperty(PROPKEY_KARAF_DATA);
            if (dir == null) {
                throw new RuntimeException("Storage directory not defined.");
            }
            this.workRoot = new File(dir, DEFAULT_UPLOAD_WORKDIR);
            logger.info("Chunk file upload directory set to {}.", (Object)this.workRoot.getAbsolutePath());
        }
        ClassLoader cl = FileUploadJob.class.getClassLoader();
        JAXBContext jctx = JAXBContext.newInstance((String)"org.opencastproject.fileupload.api.job", (ClassLoader)cl);
        this.jobMarshaller = jctx.createMarshaller();
        this.jobUnmarshaller = jctx.createUnmarshaller();
        this.cleaner = new FileUploadServiceCleaner(this);
        this.cleaner.schedule();
        logger.info("File Upload Service activated.");
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        logger.info("File Upload Service deactivated");
        this.cleaner.shutdown();
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        String dir = (String)properties.get(PROPKEY_UPLOAD_WORKDIR);
        if (dir != null) {
            this.workRoot = new File(dir);
            logger.info("Configuration updated. Upload working directory set to `{}`.", (Object)dir);
        }
        try {
            this.jobMaxTTL = Integer.parseInt(((String)properties.get(PROPKEY_CLEANER_MAXTTL)).trim());
        }
        catch (Exception e) {
            this.jobMaxTTL = 6;
            logger.warn("Unable to update configuration. {}", (Object)e.getMessage());
        }
        logger.info("Configuration updated. Jobs older than {} hours are deleted.", (Object)this.jobMaxTTL);
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Override
    public FileUploadJob createJob(String filename, long filesize, int chunksize, MediaPackage mp, MediaPackageElementFlavor flavor) throws FileUploadException {
        FileUploadJob job = new FileUploadJob(filename, filesize, chunksize, mp, flavor);
        logger.info("Creating new upload job: {}", (Object)job);
        try {
            File jobDir = this.getJobDir(job.getId());
            FileUtils.forceMkdir((File)jobDir);
            this.ensureExists(this.getPayloadFile(job.getId()));
            this.storeJob(job);
        }
        catch (FileUploadException e) {
            this.deleteJob(job.getId());
            throw this.fileUploadException(Severity.error, "Could not create job file in " + this.workRoot.getAbsolutePath(), e);
        }
        catch (IOException e) {
            this.deleteJob(job.getId());
            throw this.fileUploadException(Severity.error, "Could not create upload job directory in " + this.workRoot.getAbsolutePath(), e);
        }
        return job;
    }

    @Override
    public boolean hasJob(String id) {
        try {
            if (this.jobCache.containsKey(id)) {
                return true;
            }
            File jobFile = this.getJobFile(id);
            return jobFile.exists();
        }
        catch (Exception e) {
            logger.warn("Error while looking for upload job: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileUploadJob getJob(String id) throws FileUploadException {
        if (this.jobCache.containsKey(id)) {
            return this.jobCache.get(id);
        }
        try {
            FileUploadServiceImpl fileUploadServiceImpl = this;
            synchronized (fileUploadServiceImpl) {
                File jobFile = this.getJobFile(id);
                FileUploadJob job = null;
                try (FileInputStream jobFileStream = new FileInputStream(jobFile);){
                    job = (FileUploadJob)this.jobUnmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)jobFileStream));
                }
                job.setLastModified(jobFile.lastModified());
                return job;
            }
        }
        catch (Exception e) {
            throw this.fileUploadException(Severity.warn, "Failed to load job " + id + " from file.", e);
        }
    }

    @Override
    public void cleanOutdatedJobs() throws IOException {
        File[] workRootFiles = this.workRoot.listFiles();
        if (workRootFiles == null) {
            logger.trace("No outdated files found in {}", (Object)this.workRoot.getAbsolutePath());
            return;
        }
        for (File dir : this.workRoot.listFiles()) {
            if (!dir.getParentFile().equals(this.workRoot) || !dir.isDirectory()) continue;
            try {
                String id = dir.getName();
                if (this.isLocked(id)) continue;
                FileUploadJob job = this.getJob(id);
                Calendar cal = Calendar.getInstance();
                cal.add(10, -this.jobMaxTTL);
                if (job.lastModified() >= cal.getTimeInMillis()) continue;
                FileUtils.forceDelete((File)dir);
                this.jobCache.remove(id);
                logger.info("Deleted outdated job {}", (Object)id);
            }
            catch (Exception e) {
                FileUtils.forceDelete((File)dir);
                logger.info("Deleted corrupted job {}", (Object)dir.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeJob(FileUploadJob job) throws FileUploadException {
        try {
            FileUploadServiceImpl fileUploadServiceImpl = this;
            synchronized (fileUploadServiceImpl) {
                logger.debug("Attempting to store job {}", (Object)job.getId());
                File jobFile = this.ensureExists(this.getJobFile(job.getId()));
                this.jobMarshaller.marshal((Object)job, jobFile);
            }
        }
        catch (Exception e) {
            throw this.fileUploadException(Severity.error, "Failed to write job file.", e);
        }
    }

    @Override
    public void deleteJob(String id) throws FileUploadException {
        try {
            logger.debug("Attempting to delete job " + id);
            if (this.isLocked(id)) {
                this.jobCache.remove(id);
            }
            File jobDir = this.getJobDir(id);
            FileUtils.forceDelete((File)jobDir);
        }
        catch (Exception e) {
            throw this.fileUploadException(Severity.error, "Error deleting job", e);
        }
    }

    @Override
    public void acceptChunk(FileUploadJob job, long chunkNumber, InputStream content) throws FileUploadException {
        FileInputStream in;
        FileOutputStream out;
        block18: {
            long supposedSize;
            long actualSize;
            block17: {
                if (job.getState().equals((Object)FileUploadJob.JobState.COMPLETE)) {
                    this.removeFromCache(job);
                    throw this.fileUploadException(Severity.warn, "Job is already complete.");
                }
                if (this.isLocked(job.getId())) {
                    throw this.fileUploadException(Severity.error, "Job is locked. Seems like a concurrent upload to this job is in progress.");
                }
                this.lock(job);
                int supposedChunk = job.getCurrentChunk().getNumber() + 1;
                if (chunkNumber != (long)supposedChunk) {
                    this.removeFromCache(job);
                    throw this.fileUploadException(Severity.error, String.format("Wrong chunk number. Awaiting #%d but #%d was offered.", supposedChunk, chunkNumber));
                }
                logger.debug("Receiving chunk #" + chunkNumber + " of job {}", (Object)job);
                job.getCurrentChunk().incrementNumber();
                File chunkFile = null;
                try {
                    chunkFile = this.ensureExists(this.getChunkFile(job.getId()));
                }
                catch (IOException e) {
                    throw this.fileUploadException(Severity.error, "Cannot create chunk file", e);
                }
                out = null;
                try {
                    byte[] readBuffer = new byte[512];
                    out = new FileOutputStream(chunkFile, false);
                    int bytesRead = 0;
                    long bytesReadTotal = 0L;
                    Chunk currentChunk = job.getCurrentChunk();
                    do {
                        if ((bytesRead = content.read(readBuffer)) <= 0) continue;
                        ((OutputStream)out).write(readBuffer, 0, bytesRead);
                        currentChunk.setReceived(bytesReadTotal += (long)bytesRead);
                    } while (bytesRead != -1);
                    if (job.getPayload().getTotalSize() == -1L && job.getChunksTotal() == 1L) {
                        job.getPayload().setTotalSize(bytesReadTotal);
                    }
                }
                catch (Exception e) {
                    try {
                        this.removeFromCache(job);
                        throw this.fileUploadException(Severity.error, "Failed to store chunk data", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)content);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)content);
                IOUtils.closeQuietly((OutputStream)out);
                actualSize = chunkFile.length();
                supposedSize = chunkNumber == job.getChunksTotal() - 1L ? ((supposedSize = job.getPayload().getTotalSize() % (long)job.getChunksize()) == 0L ? (long)job.getChunksize() : supposedSize) : (long)job.getChunksize();
                if (actualSize != supposedSize && (job.getChunksTotal() != 1L || job.getChunksize() != -1)) break block17;
                in = null;
                try {
                    File payloadFile = this.getPayloadFile(job.getId());
                    in = new FileInputStream(chunkFile);
                    out = new FileOutputStream(payloadFile, true);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    Payload payload = job.getPayload();
                    payload.setCurrentSize(payload.getCurrentSize() + actualSize);
                }
                catch (IOException e) {
                    try {
                        this.removeFromCache(job);
                        throw this.fileUploadException(Severity.error, "Failed to append chunk data", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly((OutputStream)out);
                        this.deleteChunkFile(job.getId());
                        throw throwable;
                    }
                }
                break block18;
            }
            this.removeFromCache(job);
            throw this.fileUploadException(Severity.warn, String.format("Chunk has wrong size. Awaited: %d bytes, received: %d bytes.", supposedSize, actualSize));
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        this.deleteChunkFile(job.getId());
        if (chunkNumber == job.getChunksTotal() - 1L) {
            this.finalizeJob(job);
            logger.info("Upload job completed: {}", (Object)job);
        } else {
            job.setState(FileUploadJob.JobState.READY);
        }
        this.storeJob(job);
        this.removeFromCache(job);
    }

    @Override
    public InputStream getPayload(FileUploadJob job) throws FileUploadException {
        if (this.isLocked(job.getId())) {
            throw this.fileUploadException(Severity.warn, "Job is locked. Download is only permitted while no upload to this job is in progress.");
        }
        try {
            FileInputStream payload = new FileInputStream(this.getPayloadFile(job.getId()));
            return payload;
        }
        catch (FileNotFoundException e) {
            throw this.fileUploadException(Severity.error, "Failed to retrieve file from job " + job.getId(), e);
        }
    }

    private void lock(FileUploadJob job) {
        this.jobCache.put(job.getId(), job);
        job.setState(FileUploadJob.JobState.INPROGRESS);
    }

    private boolean isLocked(String id) {
        if (this.jobCache.containsKey(id)) {
            FileUploadJob job = this.jobCache.get(id);
            return job.getState().equals((Object)FileUploadJob.JobState.INPROGRESS) || job.getState().equals((Object)FileUploadJob.JobState.FINALIZING);
        }
        return false;
    }

    private void removeFromCache(FileUploadJob job) {
        this.jobCache.remove(job.getId());
    }

    private void finalizeJob(FileUploadJob job) throws FileUploadException {
        job.setState(FileUploadJob.JobState.FINALIZING);
        if (job.getPayload().getMediaPackage() == null) {
            job.getPayload().setUrl(this.putPayloadIntoCollection(job));
        } else {
            job.getPayload().setUrl(this.putPayloadIntoMediaPackage(job));
        }
        this.deletePayloadFile(job.getId());
        job.setState(FileUploadJob.JobState.COMPLETE);
    }

    private URL putPayloadIntoCollection(FileUploadJob job) throws FileUploadException {
        logger.info("Moving payload of job " + job.getId() + " to collection uploaded");
        Option result = IoSupport.withFile((File)this.getPayloadFile(job.getId()), this.putInCollection).flatMap(Functions.identity());
        if (result.isSome()) {
            try {
                return ((URI)result.get()).toURL();
            }
            catch (MalformedURLException e) {
                throw this.fileUploadException(Severity.error, "Unable to return URL of payloads final destination.", e);
            }
        }
        throw this.fileUploadException(Severity.error, "Failed to put payload in collection.");
    }

    private URL putPayloadIntoMediaPackage(FileUploadJob job) throws FileUploadException {
        URL uRL;
        MediaPackage mediaPackage = job.getPayload().getMediaPackage();
        MediaPackageElementFlavor flavor = job.getPayload().getFlavor();
        List<Track> excludeTracks = Arrays.asList(mediaPackage.getTracks(flavor));
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getPayloadFile(job.getId()));
            MediaPackage mp = this.ingestService.addTrack((InputStream)fileInputStream, job.getPayload().getFilename(), job.getPayload().getFlavor(), mediaPackage);
            ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(mp.getTracks(flavor)));
            tracks.removeAll(excludeTracks);
            if (tracks.size() != 1) {
                throw new FileUploadException("Ingested track not found");
            }
            uRL = ((Track)tracks.get(0)).getURI().toURL();
        }
        catch (Exception e) {
            try {
                throw this.fileUploadException(Severity.error, "Failed to add payload to MediaPackage.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return uRL;
    }

    private void deleteChunkFile(String id) {
        File chunkFile = this.getChunkFile(id);
        logger.debug("Attempting to delete chunk file of job " + id);
        if (!chunkFile.delete()) {
            logger.warn("Could not delete chunk file " + chunkFile.getAbsolutePath());
        }
    }

    private void deletePayloadFile(String id) {
        File payloadFile = this.getPayloadFile(id);
        logger.debug("Attempting to delete payload file of job " + id);
        if (!payloadFile.delete()) {
            logger.warn("Could not delete payload file " + payloadFile.getAbsolutePath());
        }
    }

    private File ensureExists(File file) throws IOException {
        file.createNewFile();
        return file;
    }

    private File getJobDir(String id) {
        StringBuilder sb = new StringBuilder().append(this.workRoot.getAbsolutePath()).append(File.separator).append(id);
        return new File(sb.toString());
    }

    private File getJobFile(String id) {
        StringBuilder sb = new StringBuilder().append(this.workRoot.getAbsolutePath()).append(File.separator).append(id).append(File.separator).append(FILENAME_JOBFILE);
        return new File(sb.toString());
    }

    private File getChunkFile(String id) {
        StringBuilder sb = new StringBuilder().append(this.workRoot.getAbsolutePath()).append(File.separator).append(id).append(File.separator).append(FILENAME_CHUNKFILE);
        return new File(sb.toString());
    }

    private File getPayloadFile(String id) {
        StringBuilder sb = new StringBuilder().append(this.workRoot.getAbsolutePath()).append(File.separator).append(id).append(File.separator).append(id).append(FILEEXT_DATAFILE);
        return new File(sb.toString());
    }

    private FileUploadException fileUploadException(Severity severity, String msg) throws FileUploadException {
        switch (severity) {
            case warn: {
                logger.warn(msg);
                break;
            }
            case error: {
                logger.error(msg);
                break;
            }
            default: {
                Prelude.unexhaustiveMatch();
            }
        }
        throw new FileUploadException(msg);
    }

    private FileUploadException fileUploadException(Severity severity, String msg, Exception cause) throws FileUploadException {
        switch (severity) {
            case warn: {
                logger.warn(msg, (Throwable)cause);
                break;
            }
            case error: {
                logger.error(msg, (Throwable)cause);
                break;
            }
            default: {
                Prelude.unexhaustiveMatch();
            }
        }
        throw new FileUploadException(msg, cause);
    }

    private static enum Severity {
        warn,
        error;

    }
}

