/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.util;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;

public final class AclUtils {
    private static final String ACTION_JSON_KEY = "action";
    private static final String ALLOW_JSON_KEY = "allow";
    private static final String ROLE_JSON_KEY = "role";

    private AclUtils() {
    }

    public static AccessControlList deserializeJsonToAcl(String json, boolean assumeAllow) throws IllegalArgumentException, ParseException {
        JSONParser parser = new JSONParser();
        JSONArray aclJson = (JSONArray)parser.parse(json);
        ListIterator iterator = aclJson.listIterator();
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        while (iterator.hasNext()) {
            String role;
            String action;
            JSONObject aceJson = (JSONObject)iterator.next();
            String string = action = aceJson.get((Object)ACTION_JSON_KEY) != null ? aceJson.get((Object)ACTION_JSON_KEY).toString() : "";
            String allow = assumeAllow ? "true" : (aceJson.get((Object)ALLOW_JSON_KEY) != null ? aceJson.get((Object)ALLOW_JSON_KEY).toString() : "");
            String string2 = role = aceJson.get((Object)ROLE_JSON_KEY) != null ? aceJson.get((Object)ROLE_JSON_KEY).toString() : "";
            if (StringUtils.trimToNull((String)action) != null && StringUtils.trimToNull((String)allow) != null && StringUtils.trimToNull((String)role) != null) {
                AccessControlEntry ace = new AccessControlEntry(role, action, Boolean.parseBoolean(allow));
                entries.add(ace);
                continue;
            }
            throw new IllegalArgumentException(String.format("One of the access control elements is missing a property. The action was '%s', allow was '%s' and the role was '%s'", action, allow, role));
        }
        return new AccessControlList(entries);
    }

    public static List<JValue> serializeAclToJson(AccessControlList acl) {
        ArrayList<JValue> entries = new ArrayList<JValue>();
        for (AccessControlEntry ace : acl.getEntries()) {
            entries.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)ALLOW_JSON_KEY, (JValue)Jsons.v((Boolean)ace.isAllow())), Jsons.f((String)ACTION_JSON_KEY, (JValue)Jsons.v((Object)ace.getAction(), (JValue)Jsons.BLANK)), Jsons.f((String)ROLE_JSON_KEY, (JValue)Jsons.v((Object)ace.getRole(), (JValue)Jsons.BLANK))}));
        }
        return entries;
    }
}

