/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.external.common.ApiMediaType;
import org.opencastproject.external.common.ApiResponseBuilder;
import org.opencastproject.external.common.ApiVersion;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.userdirectory.ConflictException;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/groups")
@Produces(value={"application/json", "application/v1.0.0+json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapigroups", title="External API Groups Service", notes={}, abstractText="Provides resources and operations related to the groups")
@Component(immediate=true, service={GroupsEndpoint.class}, property={"service.description=External API - Groups Endpoint", "opencast.service.type=org.opencastproject.external.groups", "opencast.service.path=/api/groups"})
@JaxrsResource
public class GroupsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(GroupsEndpoint.class);
    private ElasticsearchIndex elasticsearchIndex;
    private JpaGroupRoleProvider jpaGroupRoleProvider;
    private SecurityService securityService;

    @Reference
    void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setGroupRoleProvider(JpaGroupRoleProvider jpaGroupRoleProvider) {
        this.jpaGroupRoleProvider = jpaGroupRoleProvider;
    }

    @Activate
    void activate() {
        logger.info("Activating External API - Groups Endpoint");
    }

    @GET
    @Path(value="")
    @RestQuery(name="getgroups", description="Returns a list of groups.", returnDescription="", restParameters={@RestParameter(name="filter", isRequired=false, description="A comma seperated list of filters to limit the results with. A filter is the filter's name followed by a colon \":\" and then the value to filter with so it is the form [Filter Name]:[Value to Filter With].", type=RestParameter.Type.STRING), @RestParameter(name="sort", description="Sort the results based upon a list of comma seperated sorting criteria. In the comma seperated list each type of sorting is specified as a pair such as: <Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending or descending order and is mandatory.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of results to return for a single request.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The index of the first result to return.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="A (potentially empty) list of groups.", responseCode=200)})
    public Response getGroups(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        Optional<Integer> optLimit = Optional.ofNullable(limit);
        Optional<Integer> optOffset = Optional.ofNullable(offset);
        if (optLimit.isPresent() && limit <= 0) {
            optLimit = Optional.empty();
        }
        if (optOffset.isPresent() && offset < 0) {
            optOffset = Optional.empty();
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            for (String f : filter.split(",")) {
                String[] filterTuple = f.split(":");
                if (filterTuple.length < 2) {
                    logger.debug("No value for filter '{}' in filters list: {}", (Object)filterTuple[0], (Object)filter);
                    continue;
                }
                filters.put(filterTuple[0].trim(), f.substring(filterTuple[0].length() + 1).trim());
            }
        }
        Optional<String> optNameFilter = Optional.ofNullable((String)filters.get("Name"));
        ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)sort);
        Set<Object> deprecatedSortCriteria = new HashSet();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_6_0)) {
            deprecatedSortCriteria = sortCriteria.stream().filter(sortCriterion -> sortCriterion.getFieldName().equals("members") || sortCriterion.getFieldName().equals("roles")).collect(Collectors.toSet());
            sortCriteria.removeAll(deprecatedSortCriteria);
        }
        List results = this.jpaGroupRoleProvider.getGroups(optLimit, optOffset, optNameFilter, Optional.empty(), sortCriteria);
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_6_0)) {
            ArrayList<GroupComparator> comparators = new ArrayList<GroupComparator>();
            block9: for (SortCriterion sortCriterion2 : deprecatedSortCriteria) {
                Comparator<JpaGroup> comparator;
                switch (sortCriterion2.getFieldName()) {
                    case "members": {
                        comparator = new GroupComparator(this){

                            @Override
                            public Set<String> getGroupAttribute(JpaGroup jpaGroup) {
                                return jpaGroup.getMembers();
                            }
                        };
                        break;
                    }
                    case "roles": {
                        comparator = new GroupComparator(this){

                            @Override
                            public Set<String> getGroupAttribute(JpaGroup jpaGroup) {
                                return jpaGroup.getRoleNames();
                            }
                        };
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                if (sortCriterion2.getOrder() == SortCriterion.Order.Descending) {
                    comparator = comparator.reversed();
                }
                comparators.add((GroupComparator)comparator);
            }
            Collections.sort(results, ComparatorUtils.chainedComparator(comparators));
        }
        ArrayList<JObject> groupsJSON = new ArrayList<JObject>();
        for (JpaGroup jpaGroup : results) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((String)jpaGroup.getGroupId())));
            fields.add(Jsons.f((String)"organization", (JValue)Jsons.v((String)jpaGroup.getOrganization().getId())));
            fields.add(Jsons.f((String)"role", (JValue)Jsons.v((String)jpaGroup.getRole())));
            fields.add(Jsons.f((String)"name", (JValue)Jsons.v((Object)jpaGroup.getName(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)jpaGroup.getDescription(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"roles", (JValue)Jsons.v((Object)StringUtils.join((Iterable)jpaGroup.getRoleNames(), (String)","), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"members", (JValue)Jsons.v((Object)StringUtils.join((Iterable)jpaGroup.getMembers(), (String)","), (JValue)Jsons.BLANK)));
            groupsJSON.add(Jsons.obj(fields));
        }
        return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.arr(groupsJSON));
    }

    @GET
    @Path(value="{groupId}")
    @RestQuery(name="getgroup", description="Returns a single group.", returnDescription="", pathParameters={@RestParameter(name="groupId", description="The group id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The group is returned.", responseCode=200), @RestResponse(description="The specified group does not exist.", responseCode=404)})
    public Response getGroup(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="groupId") String id) {
        JpaGroup group = this.jpaGroupRoleProvider.getGroup(id);
        if (group == null) {
            return ApiResponseBuilder.notFound("Cannot find a group with id '%s'.", id);
        }
        return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)group.getGroupId())), Jsons.f((String)"organization", (JValue)Jsons.v((String)group.getOrganization().getId())), Jsons.f((String)"role", (JValue)Jsons.v((String)group.getRole())), Jsons.f((String)"name", (JValue)Jsons.v((Object)group.getName(), (JValue)Jsons.BLANK)), Jsons.f((String)"description", (JValue)Jsons.v((Object)group.getDescription(), (JValue)Jsons.BLANK)), Jsons.f((String)"roles", (JValue)Jsons.v((Object)StringUtils.join((Iterable)group.getRoleNames(), (String)","), (JValue)Jsons.BLANK)), Jsons.f((String)"members", (JValue)Jsons.v((Object)StringUtils.join((Iterable)group.getMembers(), (String)","), (JValue)Jsons.BLANK))}));
    }

    @DELETE
    @Path(value="{groupId}")
    @RestQuery(name="deletegroup", description="Deletes a group.", returnDescription="", pathParameters={@RestParameter(name="groupId", description="The group id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The group has been deleted.", responseCode=204), @RestResponse(description="The specified group does not exist.", responseCode=404)})
    public Response deleteGroup(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="groupId") String id) throws NotFoundException {
        try {
            this.jpaGroupRoleProvider.removeGroup(id);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            logger.error("Unable to delete group {}", (Object)id, (Object)e);
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    @PUT
    @Path(value="{groupId}")
    @RestQuery(name="updategroup", description="Updates a group.", returnDescription="", pathParameters={@RestParameter(name="groupId", description="The group id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="name", isRequired=false, description="Group Name", type=RestParameter.Type.STRING), @RestParameter(name="description", description="Group Description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="Comma-separated list of roles", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="members", description="Comma-separated list of members", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The group has been updated.", responseCode=201), @RestResponse(description="The specified group does not exist.", responseCode=400)})
    public Response updateGroup(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="groupId") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="members") String members) throws Exception {
        try {
            this.jpaGroupRoleProvider.updateGroup(id, name, description, roles, members);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to update group id {}: {}", (Object)id, (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((int)403).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="")
    @RestQuery(name="creategroup", description="Creates a group.", returnDescription="", restParameters={@RestParameter(name="name", isRequired=true, description="Group Name", type=RestParameter.Type.STRING), @RestParameter(name="description", description="Group Description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="Comma-separated list of roles", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="members", description="Comma-separated list of members", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A new group is created.", responseCode=201), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response createGroup(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="members") String members) {
        try {
            this.jpaGroupRoleProvider.createGroup(name, description, roles, members);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to create group {}: {}", (Object)name, (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (ConflictException e) {
            return Response.status((int)409).build();
        }
        return Response.status((int)201).build();
    }

    @POST
    @Path(value="{groupId}/members")
    @RestQuery(name="addgroupmember", description="Adds a member to a group.", returnDescription="", pathParameters={@RestParameter(name="groupId", description="The group id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="member", description="Member Name", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The member was already member of the group.", responseCode=200), @RestResponse(description="The member has been added.", responseCode=204), @RestResponse(description="The specified group does not exist.", responseCode=404)})
    public Response addGroupMember(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="groupId") String id, @FormParam(value="member") String member) {
        try {
            if (this.jpaGroupRoleProvider.addMemberToGroup(id, member)) {
                return Response.ok().build();
            }
            return ApiResponseBuilder.Json.ok(acceptHeader, "Member is already member of group.");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to add member to group id {}.", (Object)id, (Object)e);
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((int)403).build();
        }
        catch (NotFoundException e) {
            return ApiResponseBuilder.notFound("Cannot find group with id '%s'.", id);
        }
        catch (Exception e) {
            logger.warn("Could not update the group with id {}.", (Object)id, (Object)e);
            return ApiResponseBuilder.serverError("Could not update group with id '%s', reason: '%s'", id, ExceptionUtils.getMessage((Throwable)e));
        }
    }

    @DELETE
    @Path(value="{groupId}/members/{memberId}")
    @RestQuery(name="removegroupmember", description="Removes a member from a group", returnDescription="", pathParameters={@RestParameter(name="groupId", description="The group id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="memberId", description="The member id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The member has been removed.", responseCode=204), @RestResponse(description="The specified group or member does not exist.", responseCode=404)})
    public Response removeGroupMember(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="groupId") String id, @PathParam(value="memberId") String memberId) {
        try {
            if (this.jpaGroupRoleProvider.removeMemberFromGroup(id, memberId)) {
                return Response.ok().build();
            }
            return ApiResponseBuilder.Json.ok(acceptHeader, "Member is already not member of group.");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to remove member from group id {}.", (Object)id, (Object)e);
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((int)403).build();
        }
        catch (NotFoundException e) {
            return ApiResponseBuilder.notFound("Cannot find group with id '%s'.", id);
        }
        catch (Exception e) {
            logger.warn("Could not update the group with id {}.", (Object)id, (Object)e);
            return ApiResponseBuilder.serverError("Could not update group with id '%s', reason: '%s'", id, ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private abstract class GroupComparator
    implements Comparator<JpaGroup> {
        private GroupComparator(GroupsEndpoint groupsEndpoint) {
        }

        public abstract Set<String> getGroupAttribute(JpaGroup var1);

        @Override
        public int compare(JpaGroup group1, JpaGroup group2) {
            ArrayList<String> members1 = new ArrayList<String>(this.getGroupAttribute(group1));
            ArrayList<String> members2 = new ArrayList<String>(this.getGroupAttribute(group2));
            for (int i = 0; i < members1.size() && i < members2.size(); ++i) {
                String member2;
                String member1 = (String)members1.get(i);
                int result = member1.compareTo(member2 = (String)members2.get(i));
                if (result == 0) continue;
                return result;
            }
            return members1.size() - members2.size();
        }
    }
}

