/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.util.statistics;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.external.util.statistics.DataResolutionUtils;
import org.opencastproject.external.util.statistics.DetailLevelUtils;
import org.opencastproject.external.util.statistics.ResourceTypeUtils;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.export.api.DetailLevel;
import org.opencastproject.util.data.Collections;

public final class StatisticsProviderUtils {
    private static final String PROVIDER_TYPE_TIME_SERIES = "timeseries";
    private static final String PROVIDER_TYPE_UNKNOWN = "unknown";
    private static final String PARAMETER_TYPE_DATETIME = "datetime";
    private static final String PARAMETER_TYPE_ENUMERATION = "enumeration";
    private static final String PARAMETER_TYPE_STRING = "string";

    private StatisticsProviderUtils() {
    }

    public static String typeOf(StatisticsProvider provider) {
        if (provider instanceof TimeSeriesProvider) {
            return PROVIDER_TYPE_TIME_SERIES;
        }
        return PROVIDER_TYPE_UNKNOWN;
    }

    public static JSONObject toJson(StatisticsProvider provider, Boolean withParameters) {
        JSONObject result = new JSONObject();
        result.put((Object)"identifier", (Object)provider.getId());
        result.put((Object)"title", (Object)provider.getTitle());
        result.put((Object)"description", (Object)provider.getDescription());
        result.put((Object)"type", (Object)StatisticsProviderUtils.typeOf(provider));
        result.put((Object)"resourceType", (Object)ResourceTypeUtils.toString(provider.getResourceType()));
        if (withParameters != null && withParameters.booleanValue() && provider instanceof TimeSeriesProvider) {
            JSONArray parameters = new JSONArray();
            StatisticsProviderUtils.addParameter(parameters, "resourceId", PARAMETER_TYPE_STRING, false);
            StatisticsProviderUtils.addParameter(parameters, "from", PARAMETER_TYPE_DATETIME, false);
            StatisticsProviderUtils.addParameter(parameters, "to", PARAMETER_TYPE_DATETIME, false);
            StatisticsProviderUtils.addEnumParameter(parameters, "dataResolution", DataResolutionUtils.toJson(((TimeSeriesProvider)provider).getDataResolutions()), false);
            StatisticsProviderUtils.addEnumParameter(parameters, "detailLevel", DetailLevelUtils.toJson(Collections.set((Object[])DetailLevel.values())), true);
            result.put((Object)"parameters", (Object)parameters);
        }
        return result;
    }

    private static JSONObject createParameter(String name, String type, Boolean optional) {
        JSONObject paramJson = new JSONObject();
        paramJson.put((Object)"name", (Object)name);
        paramJson.put((Object)"type", (Object)type);
        paramJson.put((Object)"optional", (Object)optional);
        return paramJson;
    }

    private static void addParameter(JSONArray parameters, String name, String type, Boolean optional) {
        parameters.add((Object)StatisticsProviderUtils.createParameter(name, type, optional));
    }

    private static void addEnumParameter(JSONArray parameters, String name, JSONArray values, Boolean optional) {
        JSONObject enumJson = StatisticsProviderUtils.createParameter(name, PARAMETER_TYPE_ENUMERATION, optional);
        enumJson.put((Object)"values", (Object)values);
        parameters.add((Object)enumJson);
    }
}

