/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.util;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulingUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingUtils.class);
    private static final String JSON_KEY_AGENT_ID = "agent_id";
    private static final String JSON_KEY_START_DATE = "start";
    private static final String JSON_KEY_END_DATE = "end";
    private static final String JSON_KEY_DURATION = "duration";
    private static final String JSON_KEY_INPUTS = "inputs";
    private static final String JSON_KEY_RRULE = "rrule";

    private SchedulingUtils() {
    }

    public static List<JValue> convertConflictingEvents(Optional<String> checkedEventId, List<MediaPackage> mediaPackages, IndexService indexService, ElasticsearchIndex elasticsearchIndex) throws SearchIndexException {
        ArrayList<JValue> result = new ArrayList<JValue>();
        for (MediaPackage mediaPackage : mediaPackages) {
            Opt eventOpt = indexService.getEvent(mediaPackage.getIdentifier().toString(), elasticsearchIndex);
            if (eventOpt.isSome()) {
                Event event = (Event)eventOpt.get();
                if (checkedEventId.isPresent() && checkedEventId.equals(event.getIdentifier())) continue;
                result.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)JSON_KEY_START_DATE, (JValue)Jsons.v((String)event.getTechnicalStartTime())), Jsons.f((String)JSON_KEY_END_DATE, (JValue)Jsons.v((String)event.getTechnicalEndTime())), Jsons.f((String)"title", (JValue)Jsons.v((String)event.getTitle()))}));
                continue;
            }
            logger.warn("Index out of sync! Conflicting event catalog {} not found on event index!", (Object)mediaPackage.getIdentifier().toString());
        }
        return result;
    }

    public static List<MediaPackage> getConflictingEvents(SchedulingInfo schedulingInfo, CaptureAgentStateService agentStateService, SchedulerService schedulerService) throws NotFoundException, UnauthorizedException, SchedulerException {
        if (schedulingInfo.getRrule().isSome()) {
            Agent agent = agentStateService.getAgent((String)schedulingInfo.getAgentId().get());
            String timezone = agent.getConfiguration().getProperty("capture.device.timezone");
            if (StringUtils.isBlank((CharSequence)timezone)) {
                timezone = TimeZone.getDefault().getID();
                logger.warn("No 'capture.device.timezone' set on agent {}. The default server timezone {} will be used.", schedulingInfo.getAgentId().get(), (Object)timezone);
            }
            return schedulerService.findConflictingEvents((String)schedulingInfo.getAgentId().get(), (RRule)schedulingInfo.getRrule().get(), (Date)schedulingInfo.getStartDate().get(), (Date)schedulingInfo.getEndDate().get(), ((Long)schedulingInfo.getDuration().get()).longValue(), TimeZone.getTimeZone(timezone));
        }
        return schedulerService.findConflictingEvents((String)schedulingInfo.getAgentId().get(), (Date)schedulingInfo.getStartDate().get(), (Date)schedulingInfo.getEndDate().get());
    }

    public static class SchedulingInfo {
        private Opt<Date> startDate = Opt.none();
        private Opt<Date> endDate = Opt.none();
        private Opt<Long> duration = Opt.none();
        private Opt<String> agentId = Opt.none();
        private Opt<String> inputs = Opt.none();
        private Opt<RRule> rrule = Opt.none();

        public SchedulingInfo() {
        }

        public SchedulingInfo(SchedulingInfo other) {
            this.startDate = other.startDate;
            this.endDate = other.endDate;
            this.duration = other.duration;
            this.agentId = other.agentId;
            this.inputs = other.inputs;
            this.rrule = other.rrule;
        }

        public Opt<Date> getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Opt<Date> startDate) {
            this.startDate = startDate;
        }

        public Opt<Date> getEndDate() {
            if (this.endDate.isSome()) {
                return this.endDate;
            }
            if (this.startDate.isSome() && this.duration.isSome()) {
                return Opt.some((Object)Date.from(((Date)this.startDate.get()).toInstant().plusMillis((Long)this.duration.get())));
            }
            return Opt.none();
        }

        public void setEndDate(Opt<Date> endDate) {
            this.endDate = endDate;
        }

        public Opt<Long> getDuration() {
            if (this.duration.isSome()) {
                return this.duration;
            }
            if (this.startDate.isSome() && this.endDate.isSome()) {
                return Opt.some((Object)(((Date)this.endDate.get()).getTime() - ((Date)this.startDate.get()).getTime()));
            }
            return Opt.none();
        }

        public void setDuration(Opt<Long> duration) {
            this.duration = duration;
        }

        public Opt<String> getAgentId() {
            return this.agentId;
        }

        public void setAgentId(Opt<String> agentId) {
            this.agentId = agentId;
        }

        public Opt<String> getInputs() {
            return this.inputs;
        }

        public void setInputs(Opt<String> inputs) {
            this.inputs = inputs;
        }

        public Opt<RRule> getRrule() {
            return this.rrule;
        }

        public void setRrule(Opt<RRule> rrule) {
            this.rrule = rrule;
        }

        public JObject toJson() {
            ArrayList<Field> fields = new ArrayList<Field>();
            DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE_TIME;
            if (this.startDate.isSome()) {
                fields.add(Jsons.f((String)SchedulingUtils.JSON_KEY_START_DATE, (String)dateFormatter.format(((Date)this.startDate.get()).toInstant().atZone(ZoneOffset.UTC))));
            }
            if (this.endDate.isSome()) {
                fields.add(Jsons.f((String)SchedulingUtils.JSON_KEY_END_DATE, (String)dateFormatter.format(((Date)this.endDate.get()).toInstant().atZone(ZoneOffset.UTC))));
            }
            if (this.agentId.isSome()) {
                fields.add(Jsons.f((String)SchedulingUtils.JSON_KEY_AGENT_ID, (String)((String)this.agentId.get())));
            }
            if (this.inputs.isSome()) {
                fields.add(Jsons.f((String)SchedulingUtils.JSON_KEY_INPUTS, (JValue)Jsons.arr((String[])((String)this.inputs.get()).split(","))));
            }
            return Jsons.obj(fields);
        }

        public JSONObject toSource() {
            JSONObject source = new JSONObject();
            if (this.rrule.isSome()) {
                source.put((Object)"type", (Object)"SCHEDULE_MULTIPLE");
            } else {
                source.put((Object)"type", (Object)"SCHEDULE_SINGLE");
            }
            JSONObject sourceMetadata = new JSONObject();
            DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE_TIME;
            if (this.startDate.isSome()) {
                sourceMetadata.put((Object)SchedulingUtils.JSON_KEY_START_DATE, (Object)dateFormatter.format(((Date)this.startDate.get()).toInstant().atZone(ZoneOffset.UTC)));
            }
            if (this.endDate.isSome()) {
                sourceMetadata.put((Object)SchedulingUtils.JSON_KEY_END_DATE, (Object)dateFormatter.format(((Date)this.endDate.get()).toInstant().atZone(ZoneOffset.UTC)));
            }
            if (this.agentId.isSome()) {
                sourceMetadata.put((Object)"device", this.agentId.get());
            }
            if (this.getDuration().isSome()) {
                sourceMetadata.put((Object)SchedulingUtils.JSON_KEY_DURATION, (Object)String.valueOf(this.getDuration().get()));
            }
            if (this.rrule.isSome()) {
                sourceMetadata.put((Object)SchedulingUtils.JSON_KEY_RRULE, (Object)((RRule)this.rrule.get()).getValue());
            }
            sourceMetadata.put((Object)SchedulingUtils.JSON_KEY_INPUTS, this.inputs.getOr((Object)""));
            source.put((Object)"metadata", (Object)sourceMetadata);
            return source;
        }

        public SchedulingInfo merge(TechnicalMetadata metadata) {
            SchedulingInfo result = new SchedulingInfo(this);
            if (result.startDate.isNone()) {
                result.startDate = Opt.some((Object)metadata.getStartDate());
            }
            if (result.endDate.isNone()) {
                result.endDate = Opt.some((Object)metadata.getEndDate());
            }
            if (result.agentId.isNone()) {
                result.agentId = Opt.some((Object)metadata.getAgentId());
            }
            return result;
        }

        public static SchedulingInfo of(JSONObject json) {
            DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE_TIME;
            SchedulingInfo schedulingInfo = new SchedulingInfo();
            String startDate = (String)json.get((Object)SchedulingUtils.JSON_KEY_START_DATE);
            String endDate = (String)json.get((Object)SchedulingUtils.JSON_KEY_END_DATE);
            String agentId = (String)json.get((Object)SchedulingUtils.JSON_KEY_AGENT_ID);
            JSONArray inputs = (JSONArray)json.get((Object)SchedulingUtils.JSON_KEY_INPUTS);
            String rrule = (String)json.get((Object)SchedulingUtils.JSON_KEY_RRULE);
            String durationString = Objects.toString(json.get((Object)SchedulingUtils.JSON_KEY_DURATION), null);
            if (StringUtils.isNotBlank((CharSequence)startDate)) {
                schedulingInfo.startDate = Opt.some((Object)Date.from(Instant.from(dateFormatter.parse(startDate))));
            }
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                schedulingInfo.endDate = Opt.some((Object)Date.from(Instant.from(dateFormatter.parse(endDate))));
            }
            if (StringUtils.isNotBlank((CharSequence)agentId)) {
                schedulingInfo.agentId = Opt.some((Object)agentId);
            }
            if (StringUtils.isNotBlank((CharSequence)durationString)) {
                try {
                    schedulingInfo.duration = Opt.some((Object)Long.parseLong(durationString));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid format of field 'duration'");
                }
            }
            if (StringUtils.isBlank((CharSequence)endDate) && StringUtils.isBlank((CharSequence)durationString)) {
                throw new IllegalArgumentException("Either 'end' or 'duration' must be specified");
            }
            if (inputs != null) {
                schedulingInfo.inputs = Opt.some((Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)inputs));
            }
            if (StringUtils.isNotBlank((CharSequence)rrule)) {
                try {
                    RRule parsedRrule = new RRule(rrule);
                    parsedRrule.validate();
                    schedulingInfo.rrule = Opt.some((Object)parsedRrule);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid RRule: " + rrule);
                }
                if (StringUtils.isBlank((CharSequence)durationString) || StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
                    throw new IllegalArgumentException("'start', 'end' and 'duration' must be specified when 'rrule' is specified");
                }
            }
            return schedulingInfo;
        }

        public static SchedulingInfo of(String eventId, SchedulerService schedulerService) throws UnauthorizedException, SchedulerException {
            SchedulingInfo result = new SchedulingInfo();
            try {
                TechnicalMetadata technicalMetadata = schedulerService.getTechnicalMetadata(eventId);
                result.startDate = Opt.some((Object)technicalMetadata.getStartDate());
                result.endDate = Opt.some((Object)technicalMetadata.getEndDate());
                result.agentId = Opt.some((Object)technicalMetadata.getAgentId());
                String inputs = (String)technicalMetadata.getCaptureAgentConfiguration().get("capture.device.names");
                if (StringUtils.isNotBlank((CharSequence)inputs)) {
                    result.inputs = Opt.some((Object)inputs);
                }
                return result;
            }
            catch (NotFoundException e) {
                return result;
            }
        }
    }
}

