/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.userdirectory;

import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.StreamOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides the External API roles"}, immediate=true, service={RoleProvider.class})
public class ExternalApiRoleProvider
implements RoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(ExternalApiRoleProvider.class);
    protected SecurityService securityService = null;
    private Set<String> roles;
    private static final Fn2<String, Organization, Role> toRole = new Fn2<String, Organization, Role>(){

        public Role apply(String role, Organization organization) {
            return new JaxbRole(role, JaxbOrganization.fromOrganization((Organization)organization), "External API Role", Role.Type.INTERNAL);
        }
    };
    private static final Fn2<String, String, Boolean> filterByName = new Fn2<String, String, Boolean>(){

        public Boolean apply(String role, String query) {
            return ExternalApiRoleProvider.like(role, query);
        }
    };

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        String rolesFile = "/roles" + File.separator + "external-applications";
        try (InputStream in = this.getClass().getResourceAsStream(rolesFile);){
            this.roles = new TreeSet<String>(IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Unable to read available roles", (Throwable)e);
        }
        logger.info("Activated External API role provider");
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (target == Role.Target.ACL) {
            return Collections.emptyIterator();
        }
        Organization organization = this.securityService.getOrganization();
        return Stream.$(this.roles).filter(filterByName._2((Object)query)).drop(offset).apply(limit > 0 ? StreamOp.id().take(limit) : StreamOp.id()).map(toRole._2((Object)organization)).iterator();
    }

    private static boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }
}

