/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapiworkflowdefinitions", title="External API Workflow Definitions Service", notes={}, abstractText="Provides resources and operations related to the workflow definitions")
@Component(immediate=true, service={WorkflowDefinitionsEndpoint.class}, property={"service.description=External API - Workflow Definitions Endpoint", "opencast.service.type=org.opencastproject.external.workflows.definitions", "opencast.service.path=/api/workflow-definitions"})
public class WorkflowDefinitionsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionsEndpoint.class);
    private WorkflowService workflowService;

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Workflow Definitions Endpoint");
    }

    @GET
    @Path(value="/")
    @RestQuery(name="getworkflowdefinitions", description="Returns a list of workflow definition.", returnDescription="", restParameters={@RestParameter(name="withoperations", description="Whether the workflow operations should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfigurationpanel", description="Whether the workflow configuration panel should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="filter", description="Usage [Filter Name]:[Value to Filter With]. Available filter: \"tag\"", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="sort", description="Sort the results based upon a list of comma seperated sorting criteria. In the comma seperated list each type of sorting is specified as a pair such as: <Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending or descending order and is mandatory.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of results to return for a single request.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The index of the first result to return.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="A (potentially empty) list of workflow definitions is returned.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response getWorkflowDefinitions(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="withoperations") boolean withOperations, @QueryParam(value="withconfigurationpanel") boolean withConfigurationPanel, @QueryParam(value="withconfigurationpaneljson") boolean withConfigurationPanelJson, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) {
        Stream<Object> workflowDefinitions;
        try {
            workflowDefinitions = this.workflowService.listAvailableWorkflowDefinitions().stream();
        }
        catch (WorkflowDatabaseException e) {
            logger.error("The workflow service was not able to get the workflow definitions:", (Throwable)e);
            return ApiResponses.serverError("Could not retrieve workflow definitions, reason: '%s'", ExceptionUtils.getMessage((Throwable)e));
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            for (String f : filter.split(",")) {
                int sepIdx = f.indexOf(58);
                if (sepIdx < 0 || sepIdx == f.length() - 1) {
                    logger.debug("No value for filter {} in filters list: {}", (Object)f, (Object)filter);
                    continue;
                }
                String name = f.substring(0, sepIdx);
                String value = f.substring(sepIdx + 1);
                if (!"tag".equals(name)) continue;
                workflowDefinitions = workflowDefinitions.filter(wd -> ArrayUtils.contains((Object[])wd.getTags(), (Object)value));
            }
        }
        ComparatorChain comparator = new ComparatorChain();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sort})) {
            Set sortCriteria = RestUtils.parseSortQueryParameter((String)sort);
            block13: for (SortCriterion criterion : sortCriteria) {
                switch (criterion.getFieldName()) {
                    case "identifier": {
                        comparator.addComparator((wd1, wd2) -> {
                            String s1 = StringUtils.defaultString((String)wd1.getId());
                            String s2 = StringUtils.defaultString((String)wd2.getId());
                            if (criterion.getOrder() == SortCriterion.Order.Descending) {
                                return s2.compareTo(s1);
                            }
                            return s1.compareTo(s2);
                        });
                        continue block13;
                    }
                    case "title": {
                        comparator.addComparator((wd1, wd2) -> {
                            String s1 = StringUtils.defaultString((String)wd1.getTitle());
                            String s2 = StringUtils.defaultString((String)wd2.getTitle());
                            if (criterion.getOrder() == SortCriterion.Order.Descending) {
                                return s2.compareTo(s1);
                            }
                            return s1.compareTo(s2);
                        });
                        continue block13;
                    }
                    case "displayorder": {
                        comparator.addComparator((wd1, wd2) -> {
                            if (criterion.getOrder() == SortCriterion.Order.Descending) {
                                return Integer.compare(wd2.getDisplayOrder(), wd1.getDisplayOrder());
                            }
                            return Integer.compare(wd1.getDisplayOrder(), wd2.getDisplayOrder());
                        });
                        continue block13;
                    }
                }
                return RestUtil.R.badRequest((String)String.format("Unknown search criterion in request: %s", criterion.getFieldName()));
            }
        }
        if (comparator.size() > 0) {
            workflowDefinitions = workflowDefinitions.sorted((Comparator<Object>)comparator);
        }
        if (offset != null && offset > 0) {
            workflowDefinitions = workflowDefinitions.skip(offset.intValue());
        }
        if (limit != null && limit > 0) {
            workflowDefinitions = workflowDefinitions.limit(limit.intValue());
        }
        List json = workflowDefinitions.map(wd -> this.workflowDefinitionToJSON((WorkflowDefinition)wd, withOperations, withConfigurationPanel, withConfigurationPanelJson)).collect(Collectors.toList());
        return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.arr(json));
    }

    @GET
    @Path(value="{workflowDefinitionId}")
    @RestQuery(name="getworkflowdefinition", description="Returns a single workflow definition.", returnDescription="", pathParameters={@RestParameter(name="workflowDefinitionId", description="The workflow definition id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="withoperations", description="Whether the workflow operations should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfigurationpaneljson", description="Whether the workflow configuration panel in JSON should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfigurationpanel", description="Whether the workflow configuration panel should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The workflow definition is returned.", responseCode=200), @RestResponse(description="The specified workflow definition does not exist.", responseCode=404)})
    public Response getWorkflowDefinition(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="workflowDefinitionId") String id, @QueryParam(value="withoperations") boolean withOperations, @QueryParam(value="withconfigurationpanel") boolean withConfigurationPanel, @QueryParam(value="withconfigurationpaneljson") boolean withConfigurationPanelJson) throws Exception {
        WorkflowDefinition wd;
        try {
            wd = this.workflowService.getWorkflowDefinitionById(id);
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find workflow definition with id '%s'.", id);
        }
        return ApiResponses.Json.ok(acceptHeader, this.workflowDefinitionToJSON(wd, withOperations, withConfigurationPanel, withConfigurationPanelJson));
    }

    private JValue workflowDefinitionToJSON(WorkflowDefinition wd, boolean withOperations, boolean withConfigurationPanel, boolean withConfigurationPanelJson) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((String)wd.getId())));
        fields.add(Jsons.f((String)"title", (JValue)Jsons.v((Object)wd.getTitle(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)wd.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"tags", (JValue)Jsons.arr((Iterable)Arrays.stream(wd.getTags()).map(Jsons::v).collect(Collectors.toList()))));
        if (withConfigurationPanel) {
            fields.add(Jsons.f((String)"configuration_panel", (JValue)Jsons.v((Object)wd.getConfigurationPanel(), (JValue)Jsons.BLANK)));
        }
        if (withConfigurationPanelJson) {
            fields.add(Jsons.f((String)"configuration_panel_json", (JValue)Jsons.v((Object)wd.getConfigurationPanelJson(), (JValue)Jsons.BLANK)));
        }
        if (withOperations) {
            fields.add(Jsons.f((String)"operations", (JValue)Jsons.arr((Iterable)wd.getOperations().stream().map(this::workflowOperationDefinitionToJSON).collect(Collectors.toList()))));
        }
        return Jsons.obj(fields);
    }

    private JValue workflowOperationDefinitionToJSON(WorkflowOperationDefinition wod) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"operation", (JValue)Jsons.v((String)wod.getId())));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)wod.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"configuration", (JValue)Jsons.obj((Iterable)wod.getConfigurationKeys().stream().map(key -> Jsons.f((String)key, (String)wod.getConfiguration(key))).collect(Collectors.toList()))));
        fields.add(Jsons.f((String)"if", (JValue)Jsons.v((Object)wod.getExecutionCondition(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"unless", (JValue)Jsons.v((Object)wod.getSkipCondition(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"fail_workflow_on_error", (JValue)Jsons.v((Boolean)wod.isFailWorkflowOnException())));
        fields.add(Jsons.f((String)"error_handler_workflow", (JValue)Jsons.v((Object)wod.getExceptionHandlingWorkflow(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"retry_strategy", (JValue)Jsons.v((Object)new RetryStrategy.Adapter().marshal(wod.getRetryStrategy()), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"max_attempts", (JValue)Jsons.v((Number)wod.getMaxAttempts())));
        return Jsons.obj(fields);
    }
}

