/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JString;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.QueryPreprocessor;
import org.opencastproject.elasticsearch.index.objects.IndexObject;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.external.common.ApiMediaType;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.external.common.ApiVersion;
import org.opencastproject.external.util.AclUtils;
import org.opencastproject.external.util.ExternalMetadataUtils;
import org.opencastproject.external.util.SchedulingUtils;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.DublinCoreMetadataUtil;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.impl.util.EventHttpServletRequest;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.index.service.util.RequestUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.EmptyResourceListQuery;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.AudioStream;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.0.0+json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapievents", title="External API Events Service", notes={}, abstractText="Provides resources and operations related to the events")
@Component(immediate=true, service={EventsEndpoint.class, ManagedService.class}, property={"service.description=External API - Events Endpoint", "opencast.service.type=org.opencastproject.external.events", "opencast.service.path=/api/events"})
public class EventsEndpoint
implements ManagedService {
    protected static final String URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY = "url.signing.expires.seconds";
    protected static final Long DEFAULT_URL_SIGNING_EXPIRE_DURATION = 7200L;
    private static final String PREVIEW_SUBTYPE = "preview.subtype";
    private static final String DEFAULT_PREVIEW_SUBTYPE = "preview";
    private static final String RETRACT_WORKFLOW = "retract.workflow.id";
    private static final String DEFAULT_RETRACT_WORKFLOW = "delete";
    private static final Logger logger = LoggerFactory.getLogger(EventsEndpoint.class);
    protected String endpointBaseUrl;
    private static long expireSeconds = DEFAULT_URL_SIGNING_EXPIRE_DURATION;
    private String previewSubtype = "preview";
    private Map<String, MetadataField> configuredMetadataFields = new TreeMap<String, MetadataField>();
    private String retractWorkflowId = "delete";
    private AssetManager assetManager;
    private ElasticsearchIndex elasticsearchIndex;
    private IndexService indexService;
    private IngestService ingestService;
    private SecurityService securityService;
    private final List<EventCatalogUIAdapter> catalogUIAdapters = new CopyOnWriteArrayList<EventCatalogUIAdapter>();
    private final Map<String, List<EventCatalogUIAdapter>> orgCatalogUIAdaptersMap = new ConcurrentHashMap<String, List<EventCatalogUIAdapter>>();
    private UrlSigningService urlSigningService;
    private SchedulerService schedulerService;
    private CaptureAgentStateService agentStateService;
    private WorkflowService workflowService;

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUrlSigningService(UrlSigningService urlSigningService) {
        this.urlSigningService = urlSigningService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.catalogUIAdapters.add(catalogUIAdapter);
        this.invalidateOrgCatalogUIAdaptersMapFor(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.catalogUIAdapters.remove(catalogUIAdapter);
        this.invalidateOrgCatalogUIAdaptersMapFor(catalogUIAdapter);
    }

    private void invalidateOrgCatalogUIAdaptersMapFor(EventCatalogUIAdapter catalogUIAdapter) {
        for (String orgName : this.orgCatalogUIAdaptersMap.keySet()) {
            if (!catalogUIAdapter.handlesOrganization(orgName)) continue;
            this.orgCatalogUIAdaptersMap.remove(orgName);
        }
    }

    public CaptureAgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    @Reference
    public void setAgentStateService(CaptureAgentStateService agentStateService) {
        this.agentStateService = agentStateService;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    private List<EventCatalogUIAdapter> getEventCatalogUIAdapters() {
        return this.getEventCatalogUIAdapters(this.getSecurityService().getOrganization().getId());
    }

    public List<EventCatalogUIAdapter> getEventCatalogUIAdapters(String organization) {
        List cachedCatalogUIAdapters = this.orgCatalogUIAdaptersMap.computeIfAbsent(organization, org -> new ArrayList(this.catalogUIAdapters.stream().filter(a -> a.handlesOrganization(org)).collect(Collectors.toList())));
        return new ArrayList<EventCatalogUIAdapter>(cachedCatalogUIAdapters);
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Events Endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc, (String)"org.opencastproject.external.api.url", (String)"opencast.service.path");
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
        logger.debug("Configured service endpoint is {}", (Object)this.endpointBaseUrl);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            properties = new Hashtable();
            logger.debug("No configuration set");
        }
        expireSeconds = Long.parseLong(Objects.toString(properties.get(URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY), DEFAULT_URL_SIGNING_EXPIRE_DURATION.toString()));
        logger.debug("URLs signatures are configured to expire in {}.", (Object)DateTimeSupport.humanReadableTime((long)expireSeconds));
        this.previewSubtype = StringUtils.defaultString((String)((String)properties.get(PREVIEW_SUBTYPE)), (String)DEFAULT_PREVIEW_SUBTYPE);
        logger.debug("Preview subtype is '{}'", (Object)this.previewSubtype);
        this.configuredMetadataFields = DublinCoreMetadataUtil.getDublinCoreProperties(properties);
        this.retractWorkflowId = StringUtils.defaultString((String)((String)properties.get(RETRACT_WORKFLOW)), (String)DEFAULT_RETRACT_WORKFLOW);
        logger.debug("Retract Workflow is '{}'", (Object)this.retractWorkflowId);
    }

    public static <T> boolean isNullOrEmpty(List<String> list) {
        return list == null || list.isEmpty();
    }

    @GET
    @Path(value="{eventId}")
    @RestQuery(name="getevent", description="Returns a single event. By setting the optional sign parameter to true, the method will pre-sign distribution urls if signing is turned on in Opencast. Remember to consider the maximum validity of signed URLs when caching this response.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="sign", isRequired=false, description="Whether public distribution urls should be signed.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withacl", isRequired=false, description="Whether the acl metadata should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withmetadata", isRequired=false, description="Whether the metadata catalogs should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withscheduling", isRequired=false, description="Whether the scheduling information should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withpublications", isRequired=false, description="Whether the publication ids and urls should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="includeInternalPublication", isRequired=false, description="Whether internal publications should be included.", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The event is returned.", responseCode=200), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getEvent(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @QueryParam(value="sign") boolean sign, @QueryParam(value="withacl") Boolean withAcl, @QueryParam(value="withmetadata") Boolean withMetadata, @QueryParam(value="withscheduling") Boolean withScheduling, @QueryParam(value="withpublications") Boolean withPublications, @QueryParam(value="includeInternalPublication") Boolean includeInternalPublication) throws Exception {
        Iterator iterator;
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
            withScheduling = false;
        }
        if ((iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator()).hasNext()) {
            Event event = (Event)iterator.next();
            event.updatePreview(this.previewSubtype);
            return ApiResponses.Json.ok(requestedVersion, this.eventToJSON(event, withAcl, withMetadata, withScheduling, withPublications, includeInternalPublication, sign, requestedVersion));
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="{eventId}/media")
    @RestQuery(name="geteventmedia", description="Returns media tracks of specific single event.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event's media is returned.", responseCode=200), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getEventMedia(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id) throws Exception {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        ArrayList<TrackImpl> tracks = new ArrayList<TrackImpl>();
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            void var10_12;
            Event event = (Event)iterator.next();
            MediaPackage mp = this.indexService.getEventMediapackage(event);
            Track[] trackArray = mp.getTracks();
            int n = trackArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                Track track = trackArray[var10_12];
                if (track instanceof TrackImpl) {
                    tracks.add((TrackImpl)track);
                }
                ++var10_12;
            }
            ArrayList<JObject> tracksJson = new ArrayList<JObject>();
            for (Track track : tracks) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (track.getChecksum() != null) {
                    fields.add(Jsons.f((String)"checksum", (JValue)Jsons.v((String)track.getChecksum().toString())));
                }
                if (track.getDescription() != null) {
                    fields.add(Jsons.f((String)"description", (JValue)Jsons.v((String)track.getDescription())));
                }
                if (track.getDuration() != null) {
                    fields.add(Jsons.f((String)"duration", (JValue)Jsons.v((Number)track.getDuration())));
                }
                if (track.getElementDescription() != null) {
                    fields.add(Jsons.f((String)"element-description", (JValue)Jsons.v((String)track.getElementDescription())));
                }
                if (track.getFlavor() != null) {
                    fields.add(Jsons.f((String)"flavor", (JValue)Jsons.v((String)track.getFlavor().toString())));
                }
                if (track.getIdentifier() != null) {
                    fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((String)track.getIdentifier())));
                }
                if (track.getMimeType() != null) {
                    fields.add(Jsons.f((String)"mimetype", (JValue)Jsons.v((String)track.getMimeType().toString())));
                }
                fields.add(Jsons.f((String)"size", (JValue)Jsons.v((Number)track.getSize())));
                if (!requestedVersion.isSmallerThan(ApiVersion.VERSION_1_7_0)) {
                    fields.add(Jsons.f((String)"has_video", (JValue)Jsons.v((Boolean)track.hasVideo())));
                    fields.add(Jsons.f((String)"has_audio", (JValue)Jsons.v((Boolean)track.hasAudio())));
                    fields.add(Jsons.f((String)"is_master_playlist", (JValue)Jsons.v((Boolean)track.isMaster())));
                    fields.add(Jsons.f((String)"is_live", (JValue)Jsons.v((Boolean)track.isLive())));
                }
                if (track.getStreams() != null) {
                    ArrayList<Field> streams = new ArrayList<Field>();
                    for (Stream stream : track.getStreams()) {
                        streams.add(Jsons.f((String)stream.getIdentifier(), (JValue)this.getJsonStream(stream)));
                    }
                    fields.add(Jsons.f((String)"streams", (JValue)Jsons.obj(streams)));
                }
                if (track.getTags() != null) {
                    ArrayList<JString> tags = new ArrayList<JString>();
                    for (String string : track.getTags()) {
                        tags.add(Jsons.v((String)string));
                    }
                    fields.add(Jsons.f((String)"tags", (JValue)Jsons.arr(tags)));
                }
                if (track.getURI() != null) {
                    fields.add(Jsons.f((String)"uri", (JValue)Jsons.v((String)track.getURI().toString())));
                }
                tracksJson.add(Jsons.obj(fields));
            }
            return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.arr(tracksJson));
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @DELETE
    @Path(value="{eventId}")
    @RestQuery(name="deleteevent", description="Deletes an event.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event has been deleted.", responseCode=204), @RestResponse(description="The retraction of publications has started.", responseCode=202), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response deleteEvent(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id) throws SearchIndexException, UnauthorizedException {
        IndexService.EventRemovalResult result;
        Opt event = this.indexService.getEvent(id, this.elasticsearchIndex);
        if (event.isNone()) {
            return RestUtil.R.notFound((Object)id);
        }
        try {
            result = this.indexService.removeEvent((Event)event.get(), this.retractWorkflowId);
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Workflow database is not reachable. This may be a temporary problem.");
            return RestUtil.R.serverError();
        }
        catch (NotFoundException e) {
            logger.error("Configured retract workflow not found. Check your configuration.");
            return RestUtil.R.serverError();
        }
        switch (result) {
            case SUCCESS: {
                return Response.noContent().build();
            }
            case RETRACTING: {
                return Response.accepted().build();
            }
            case GENERAL_FAILURE: {
                return Response.serverError().build();
            }
            case NOT_FOUND: {
                return RestUtil.R.notFound((Object)id);
            }
        }
        throw new RuntimeException("Unknown EventRemovalResult type: " + result.name());
    }

    @POST
    @Path(value="{eventId}")
    @RestQuery(name="updateeventmetadata", description="Updates an event.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="acl", isRequired=false, description="A collection of roles with their possible action", type=RestParameter.Type.STRING), @RestParameter(name="metadata", isRequired=false, description="Event metadata as Form param", type=RestParameter.Type.STRING), @RestParameter(name="scheduling", isRequired=false, description="Scheduling information as Form param", type=RestParameter.Type.STRING), @RestParameter(name="presenter", isRequired=false, description="Presenter movie track", type=RestParameter.Type.FILE), @RestParameter(name="presentation", isRequired=false, description="Presentation movie track", type=RestParameter.Type.FILE), @RestParameter(name="audio", isRequired=false, description="Audio track", type=RestParameter.Type.FILE), @RestParameter(name="processing", isRequired=false, description="Processing instructions task configuration", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event has been updated.", responseCode=204), @RestResponse(description="The event could not be updated due to a scheduling conflict.", responseCode=409), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response updateEventMetadata(@HeaderParam(value="Accept") String acceptHeader, @Context HttpServletRequest request, @PathParam(value="eventId") String eventId) {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        try {
            String startDatePattern = this.configuredMetadataFields.containsKey("startDate") ? this.configuredMetadataFields.get("startDate").getPattern() : null;
            String startTimePattern = this.configuredMetadataFields.containsKey("startTime") ? this.configuredMetadataFields.get("startTime").getPattern() : null;
            Iterator iterator = this.indexService.getEvent(eventId, this.elasticsearchIndex).iterator();
            if (iterator.hasNext()) {
                Optional<Response> clientError;
                Event event = (Event)iterator.next();
                EventHttpServletRequest eventHttpServletRequest = EventHttpServletRequest.updateFromHttpServletRequest((Event)event, (HttpServletRequest)request, this.getEventCatalogUIAdapters(), (String)startDatePattern, (String)startTimePattern);
                if (eventHttpServletRequest.getMetadataList().isSome()) {
                    this.indexService.updateEventMetadata(eventId, (MetadataList)eventHttpServletRequest.getMetadataList().get(), this.elasticsearchIndex);
                }
                if (eventHttpServletRequest.getAcl().isSome()) {
                    this.indexService.updateEventAcl(eventId, (AccessControlList)eventHttpServletRequest.getAcl().get(), this.elasticsearchIndex);
                }
                if (eventHttpServletRequest.getProcessing().isSome()) {
                    HashMap oldWorkflowConfig;
                    if (!event.isScheduledEvent() || event.hasRecordingStarted()) {
                        return RestUtil.R.badRequest((String)"Processing can't be updated for events that are already uploaded.");
                    }
                    JSONObject processing = (JSONObject)eventHttpServletRequest.getProcessing().get();
                    String workflowId = (String)processing.get((Object)"workflow");
                    if (workflowId == null) {
                        throw new IllegalArgumentException("No workflow template in metadata");
                    }
                    HashMap configuration = new HashMap();
                    if (((JSONObject)eventHttpServletRequest.getProcessing().get()).get((Object)"configuration") != null) {
                        configuration = new HashMap((JSONObject)((JSONObject)eventHttpServletRequest.getProcessing().get()).get((Object)"configuration"));
                    }
                    Opt caMetadataOpt = Opt.none();
                    Opt workflowConfigOpt = Opt.none();
                    HashMap<String, String> caMetadata = new HashMap<String, String>(this.getSchedulerService().getCaptureAgentConfiguration(eventId));
                    if (!workflowId.equals(caMetadata.get("org.opencastproject.workflow.definition"))) {
                        caMetadata.put("org.opencastproject.workflow.definition", workflowId);
                        caMetadataOpt = Opt.some(caMetadata);
                    }
                    if (!(oldWorkflowConfig = new HashMap(this.getSchedulerService().getWorkflowConfig(eventId))).equals(configuration)) {
                        workflowConfigOpt = Opt.some(configuration);
                    }
                    if (!caMetadataOpt.isNone() || !workflowConfigOpt.isNone()) {
                        this.getSchedulerService().updateEvent(eventId, Opt.none(), Opt.none(), Opt.none(), Opt.none(), Opt.none(), workflowConfigOpt, caMetadataOpt);
                    }
                }
                if (eventHttpServletRequest.getScheduling().isSome() && !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0) && (clientError = this.updateSchedulingInformation((JSONObject)eventHttpServletRequest.getScheduling().get(), eventId, requestedVersion, false)).isPresent()) {
                    return clientError.get();
                }
                return Response.noContent().build();
            }
            return ApiResponses.notFound("Cannot find an event with id '%s'.", eventId);
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find an event with id '%s'.", eventId);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to update event '{}'", (Object)eventId, (Object)e);
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IndexServiceException e) {
            logger.error("Unable to get multi part fields or file for event '{}'", (Object)eventId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SearchIndexException e) {
            logger.error("Unable to update event '{}'", (Object)eventId, (Object)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="createevent", description="Creates an event by sending metadata, access control list, processing instructions and files in a multipart request.", returnDescription="", restParameters={@RestParameter(name="acl", isRequired=false, description="A collection of roles with their possible action", type=RestParameter.Type.STRING), @RestParameter(name="metadata", description="Event metadata as Form param", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="scheduling", description="Scheduling information as Form param", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="presenter", description="Presenter movie track", isRequired=false, type=RestParameter.Type.FILE), @RestParameter(name="presentation", description="Presentation movie track", isRequired=false, type=RestParameter.Type.FILE), @RestParameter(name="audio", description="Audio track", isRequired=false, type=RestParameter.Type.FILE), @RestParameter(name="processing", description="Processing instructions task configuration", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A new event is created and its identifier is returned in the Location header.", responseCode=201), @RestResponse(description="The event could not be created due to a scheduling conflict.", responseCode=409), @RestResponse(description="The request is invalid or inconsistent..", responseCode=400)})
    public Response createNewEvent(@HeaderParam(value="Accept") String acceptHeader, @Context HttpServletRequest request) {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        try {
            String startDatePattern = this.configuredMetadataFields.containsKey("startDate") ? this.configuredMetadataFields.get("startDate").getPattern() : null;
            String startTimePattern = this.configuredMetadataFields.containsKey("startTime") ? this.configuredMetadataFields.get("startTime").getPattern() : null;
            EventHttpServletRequest eventHttpServletRequest = EventHttpServletRequest.createFromHttpServletRequest((HttpServletRequest)request, (IngestService)this.ingestService, this.getEventCatalogUIAdapters(), (String)startDatePattern, (String)startTimePattern);
            if (eventHttpServletRequest.getScheduling().isSome() && !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
                return this.scheduleNewEvent(eventHttpServletRequest, (JSONObject)eventHttpServletRequest.getScheduling().get(), requestedVersion);
            }
            JSONObject source = new JSONObject();
            source.put((Object)"type", (Object)"UPLOAD");
            eventHttpServletRequest.setSource(source);
            String eventId = this.indexService.createEvent(eventHttpServletRequest);
            return ApiResponses.Json.created(requestedVersion, URI.create(this.getEventUrl(eventId)), (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)eventId))}));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            logger.debug("Unable to create event", (Throwable)e);
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IndexServiceException | SchedulerException e) {
            if (e.getCause() != null && e.getCause() instanceof NotFoundException || e.getCause() instanceof IllegalArgumentException) {
                logger.debug("Unable to create event", e);
                return RestUtil.R.badRequest((String)e.getCause().getMessage());
            }
            logger.error("Unable to create event", e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            logger.error("Unable to create event", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response scheduleNewEvent(EventHttpServletRequest request, JSONObject scheduling, ApiVersion requestedVersion) throws MediaPackageException, IOException, IngestException, SchedulerException, NotFoundException, UnauthorizedException, SearchIndexException, java.text.ParseException {
        SchedulingUtils.SchedulingInfo schedulingInfo = SchedulingUtils.SchedulingInfo.of(scheduling);
        JSONObject source = schedulingInfo.toSource();
        request.setSource(source);
        try {
            String eventId = this.indexService.createEvent(request);
            if (StringUtils.isEmpty((CharSequence)eventId)) {
                return RestUtil.R.badRequest((String)"The date range provided did not include any events");
            }
            if (eventId.contains(",")) {
                return ApiResponses.Json.ok(requestedVersion, (JValue)Jsons.arr((Iterable)Arrays.stream(eventId.split(",")).map(s -> Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)s))})).collect(Collectors.toList())));
            }
            return ApiResponses.Json.created(requestedVersion, URI.create(this.getEventUrl(eventId)), (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)eventId))}));
        }
        catch (SchedulerConflictException e) {
            List<MediaPackage> conflictingEvents = SchedulingUtils.getConflictingEvents(schedulingInfo, this.agentStateService, this.schedulerService);
            logger.debug("Client tried to schedule conflicting event(s).");
            return ApiResponses.Json.conflict(requestedVersion, (JValue)Jsons.arr(SchedulingUtils.convertConflictingEvents(Optional.empty(), conflictingEvents, this.indexService, this.elasticsearchIndex)));
        }
    }

    @GET
    @Path(value="/")
    @RestQuery(name="getevents", description="Returns a list of events. By setting the optional sign parameter to true, the method will pre-sign distribution urls if signing is turned on in Opencast. Remember to consider the maximum validity of signed URLs when caching this response.", returnDescription="", restParameters={@RestParameter(name="sign", isRequired=false, description="Whether public distribution urls should be signed.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withacl", isRequired=false, description="Whether the acl metadata should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withmetadata", isRequired=false, description="Whether the metadata catalogs should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withscheduling", isRequired=false, description="Whether the scheduling information should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="withpublications", isRequired=false, description="Whether the publication ids and urls should be included in the response.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="includeInternalPublication", description="Whether internal publications should be included.", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="onlyWithWriteAccess", isRequired=false, description="Whether only to get the events to which we have write access.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="filter", isRequired=false, description="Usage [Filter Name]:[Value to Filter With]. Multiple filters can be used by combining them with commas \",\". Available Filters: presenters, contributors, location, textFilter, series, subject. If API ver > 1.1.0 also: identifier, title, description, series_name, language, created, license, rightsholder, is_part_of, source, status, agent_id, start, technical_start.", type=RestParameter.Type.STRING), @RestParameter(name="sort", description="Sort the results based upon a list of comma seperated sorting criteria. In the comma seperated list each type of sorting is specified as a pair such as: <Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending or descending order and is mandatory.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of results to return for a single request.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The index of the first result to return.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="A (potentially empty) list of events is returned.", responseCode=200)})
    public Response getEvents(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="id") String id, @QueryParam(value="commentReason") String reasonFilter, @QueryParam(value="commentResolution") String resolutionFilter, @QueryParam(value="filter") List<String> filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="sign") boolean sign, @QueryParam(value="withacl") Boolean withAcl, @QueryParam(value="withmetadata") Boolean withMetadata, @QueryParam(value="withscheduling") Boolean withScheduling, @QueryParam(value="onlyWithWriteAccess") Boolean onlyWithWriteAccess, @QueryParam(value="withpublications") Boolean withPublications, @QueryParam(value="includeInternalPublication") Boolean includeInternalPublication) {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
            withScheduling = false;
        }
        Option optLimit = Option.option((Object)limit);
        Option optOffset = Option.option((Object)offset);
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        EventSearchQuery query = new EventSearchQuery(this.getSecurityService().getOrganization().getId(), this.getSecurityService().getUser());
        if (optLimit.isSome() && limit == 0) {
            optLimit = Option.none();
        }
        ArrayList<IndexObject> allEvents = new ArrayList<IndexObject>();
        if (!EventsEndpoint.isNullOrEmpty(filter)) {
            if (!requestedVersion.isSmallerThan(ApiVersion.VERSION_1_5_0)) {
                filter = filter.subList(0, 1);
            }
            for (String filterPart : filter) {
                for (String f : filterPart.split(",")) {
                    Tuple fromAndToCreationRange;
                    String[] filterTuple = f.split(":");
                    if (filterTuple.length < 2) {
                        logger.debug("No value for filter {} in filters list: {}", (Object)filterTuple[0], filter);
                        continue;
                    }
                    String name = filterTuple[0];
                    String value = !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0) ? f.substring(name.length() + 1) : filterTuple[1];
                    if ("presenters".equals(name)) {
                        query.withPresenter(value);
                        continue;
                    }
                    if ("contributors".equals(name)) {
                        query.withContributor(value);
                        continue;
                    }
                    if ("location".equals(name)) {
                        query.withLocation(value);
                        continue;
                    }
                    if ("textFilter".equals(name)) {
                        query.withText(QueryPreprocessor.sanitize((String)value));
                        continue;
                    }
                    if ("series".equals(name)) {
                        query.withSeriesId(value);
                        continue;
                    }
                    if ("subject".equals(name)) {
                        query.withSubject(value);
                        continue;
                    }
                    if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) continue;
                    if ("identifier".equals(name)) {
                        query.withIdentifier(value);
                        continue;
                    }
                    if ("title".equals(name)) {
                        query.withTitle(value);
                        continue;
                    }
                    if ("description".equals(name)) {
                        query.withDescription(value);
                        continue;
                    }
                    if ("series_name".equals(name)) {
                        query.withSeriesName(value);
                        continue;
                    }
                    if ("language".equals(name)) {
                        query.withLanguage(value);
                        continue;
                    }
                    if ("created".equals(name)) {
                        query.withCreated(value);
                        continue;
                    }
                    if ("license".equals(name)) {
                        query.withLicense(value);
                        continue;
                    }
                    if ("rightsholder".equals(name)) {
                        query.withRights(value);
                        continue;
                    }
                    if ("is_part_of".equals(name)) {
                        query.withSeriesId(value);
                        continue;
                    }
                    if ("source".equals(name)) {
                        query.withSource(value);
                        continue;
                    }
                    if ("status".equals(name)) {
                        query.withEventStatus(value);
                        continue;
                    }
                    if ("agent_id".equals(name)) {
                        query.withAgentId(value);
                        continue;
                    }
                    if ("start".equals(name)) {
                        try {
                            fromAndToCreationRange = RestUtils.getFromAndToDateRange((String)value);
                            query.withStartFrom((Date)fromAndToCreationRange.getA());
                            query.withStartTo((Date)fromAndToCreationRange.getB());
                            continue;
                        }
                        catch (Exception e) {
                            return RestUtil.R.badRequest((String)String.format("Filter 'start' could not be parsed: %s", e.getMessage()));
                        }
                    }
                    if ("technical_start".equals(name)) {
                        try {
                            fromAndToCreationRange = RestUtils.getFromAndToDateRange((String)value);
                            query.withTechnicalStartFrom((Date)fromAndToCreationRange.getA());
                            query.withTechnicalStartTo((Date)fromAndToCreationRange.getB());
                            continue;
                        }
                        catch (Exception e) {
                            return RestUtil.R.badRequest((String)String.format("Filter 'technical_start' could not be parsed: %s", e.getMessage()));
                        }
                    }
                    logger.warn("Unknown filter criteria {}", (Object)name);
                    return RestUtil.R.badRequest((String)String.format("Unknown filter criterion in request: %s", name));
                }
                if (optSort.isSome()) {
                    Set sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
                    block70: for (SortCriterion criterion : sortCriteria) {
                        switch (criterion.getFieldName()) {
                            case "title": {
                                query.sortByTitle(criterion.getOrder());
                                continue block70;
                            }
                            case "presenter": {
                                query.sortByPresenter(criterion.getOrder());
                                continue block70;
                            }
                            case "technical_start": 
                            case "technical_date": {
                                query.sortByTechnicalStartDate(criterion.getOrder());
                                continue block70;
                            }
                            case "technical_end": {
                                query.sortByTechnicalEndDate(criterion.getOrder());
                                continue block70;
                            }
                            case "start_date": 
                            case "date": {
                                query.sortByStartDate(criterion.getOrder());
                                continue block70;
                            }
                            case "end_date": {
                                query.sortByEndDate(criterion.getOrder());
                                continue block70;
                            }
                            case "workflow_state": {
                                query.sortByWorkflowState(criterion.getOrder());
                                continue block70;
                            }
                            case "series_name": {
                                query.sortBySeriesName(criterion.getOrder());
                                continue block70;
                            }
                            case "location": {
                                query.sortByLocation(criterion.getOrder());
                                continue block70;
                            }
                            case "review_status": 
                            case "scheduling_status": {
                                continue block70;
                            }
                        }
                        return RestUtil.R.badRequest((String)String.format("Unknown sort criterion in request: %s", criterion.getFieldName()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)resolutionFilter)) {
                    try {
                        CommentResolution.valueOf(resolutionFilter);
                    }
                    catch (Exception e) {
                        logger.debug("Unable to parse comment resolution filter {}", (Object)resolutionFilter);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                }
                if (optLimit.isSome()) {
                    query.withLimit(((Integer)optLimit.get()).intValue());
                }
                if (optOffset.isSome()) {
                    query.withOffset(offset.intValue());
                }
                SearchResult results = null;
                try {
                    results = this.elasticsearchIndex.getByQuery(query);
                }
                catch (SearchIndexException e) {
                    logger.error("The External Search Index was not able to get the events list", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                SearchResultItem[] items = results.getItems();
                ArrayList<Event> events = new ArrayList<Event>();
                for (SearchResultItem item : items) {
                    Event source = (Event)item.getSource();
                    source.updatePreview(this.previewSubtype);
                    events.add(source);
                }
                allEvents.addAll(events);
            }
        } else {
            if (optSort.isSome()) {
                Set sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
                block72: for (SortCriterion criterion : sortCriteria) {
                    switch (criterion.getFieldName()) {
                        case "title": {
                            query.sortByTitle(criterion.getOrder());
                            continue block72;
                        }
                        case "presenter": {
                            query.sortByPresenter(criterion.getOrder());
                            continue block72;
                        }
                        case "technical_start": 
                        case "technical_date": {
                            query.sortByTechnicalStartDate(criterion.getOrder());
                            continue block72;
                        }
                        case "technical_end": {
                            query.sortByTechnicalEndDate(criterion.getOrder());
                            continue block72;
                        }
                        case "start_date": 
                        case "date": {
                            query.sortByStartDate(criterion.getOrder());
                            continue block72;
                        }
                        case "end_date": {
                            query.sortByEndDate(criterion.getOrder());
                            continue block72;
                        }
                        case "workflow_state": {
                            query.sortByWorkflowState(criterion.getOrder());
                            continue block72;
                        }
                        case "series_name": {
                            query.sortBySeriesName(criterion.getOrder());
                            continue block72;
                        }
                        case "location": {
                            query.sortByLocation(criterion.getOrder());
                            continue block72;
                        }
                        case "review_status": 
                        case "scheduling_status": {
                            continue block72;
                        }
                    }
                    return RestUtil.R.badRequest((String)String.format("Unknown sort criterion in request: %s", criterion.getFieldName()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)resolutionFilter)) {
                try {
                    CommentResolution.valueOf(resolutionFilter);
                }
                catch (Exception e) {
                    logger.debug("Unable to parse comment resolution filter {}", (Object)resolutionFilter);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (optLimit.isSome()) {
                query.withLimit(((Integer)optLimit.get()).intValue());
            }
            if (optOffset.isSome()) {
                query.withOffset(offset.intValue());
            }
            if (onlyWithWriteAccess != null && onlyWithWriteAccess.booleanValue()) {
                query.withoutActions();
                query.withAction(Permissions.Action.WRITE);
            }
            SearchResult results = null;
            try {
                results = this.elasticsearchIndex.getByQuery(query);
            }
            catch (SearchIndexException e) {
                logger.error("The External Search Index was not able to get the events list", (Throwable)e);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            SearchResultItem[] items = results.getItems();
            ArrayList<Event> events = new ArrayList<Event>();
            for (SearchResultItem item : items) {
                Event source = (Event)item.getSource();
                source.updatePreview(this.previewSubtype);
                events.add(source);
            }
            allEvents.addAll(events);
        }
        try {
            return this.getJsonEvents(acceptHeader, allEvents, withAcl, withMetadata, withScheduling, withPublications, includeInternalPublication, sign, requestedVersion);
        }
        catch (Exception e) {
            logger.error("Unable to get events", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected Response getJsonEvents(String acceptHeader, List<IndexObject> events, Boolean withAcl, Boolean withMetadata, Boolean withScheduling, Boolean withPublications, Boolean includeInternalPublication, Boolean withSignedUrls, ApiVersion requestedVersion) throws IndexServiceException, UnauthorizedException, SchedulerException {
        ArrayList<JValue> eventsList = new ArrayList<JValue>();
        for (IndexObject item : events) {
            eventsList.add(this.eventToJSON((Event)item, withAcl, withMetadata, withScheduling, withPublications, includeInternalPublication, withSignedUrls, requestedVersion));
        }
        return ApiResponses.Json.ok(requestedVersion, (JValue)Jsons.arr(eventsList));
    }

    protected JValue eventToJSON(Event event, Boolean withAcl, Boolean withMetadata, Boolean withScheduling, Boolean withPublications, Boolean includeInternalPublication, Boolean withSignedUrls, ApiVersion requestedVersion) throws IndexServiceException, SchedulerException, UnauthorizedException {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (event.getArchiveVersion() != null) {
            fields.add(Jsons.f((String)"archive_version", (JValue)Jsons.v((Number)event.getArchiveVersion())));
        }
        fields.add(Jsons.f((String)"created", (JValue)Jsons.v((Object)event.getCreated(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"creator", (JValue)Jsons.v((Object)event.getCreator(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"contributor", (JValue)Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Iterable)event.getContributors()).map(Jsons.Functions.stringToJValue))));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)event.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"has_previews", (JValue)Jsons.v((Boolean)event.hasPreview())));
        fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((Object)event.getIdentifier(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"location", (JValue)Jsons.v((Object)event.getLocation(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"presenter", (JValue)Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Iterable)event.getPresenters()).map(Jsons.Functions.stringToJValue))));
        if (!requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
            fields.add(Jsons.f((String)"language", (JValue)Jsons.v((Object)event.getLanguage(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"rightsholder", (JValue)Jsons.v((Object)event.getRights(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"license", (JValue)Jsons.v((Object)event.getLicense(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"is_part_of", (JValue)Jsons.v((Object)event.getSeriesId(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"series", (JValue)Jsons.v((Object)event.getSeriesName(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"source", (JValue)Jsons.v((Object)event.getSource(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"status", (JValue)Jsons.v((Object)event.getEventStatus(), (JValue)Jsons.BLANK)));
        }
        ArrayList<JString> publicationIds = new ArrayList<JString>();
        if (event.getPublications() != null) {
            for (Publication publication : event.getPublications()) {
                publicationIds.add(Jsons.v((String)publication.getChannel()));
            }
        }
        fields.add(Jsons.f((String)"publication_status", (JValue)Jsons.arr(publicationIds)));
        fields.add(Jsons.f((String)"processing_state", (JValue)Jsons.v((Object)event.getWorkflowState(), (JValue)Jsons.BLANK)));
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_4_0)) {
            fields.add(Jsons.f((String)"start", (JValue)Jsons.v((Object)event.getTechnicalStartTime(), (JValue)Jsons.BLANK)));
            if (event.getTechnicalEndTime() != null) {
                long duration = new DateTime((Object)event.getTechnicalEndTime()).getMillis() - new DateTime((Object)event.getTechnicalStartTime()).getMillis();
                fields.add(Jsons.f((String)"duration", (JValue)Jsons.v((Number)duration)));
            }
        } else {
            fields.add(Jsons.f((String)"start", (JValue)Jsons.v((Object)event.getRecordingStartDate(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"duration", (JValue)Jsons.v((Object)event.getDuration(), (JValue)Jsons.NULL)));
        }
        if (StringUtils.trimToNull((String)event.getSubject()) != null) {
            fields.add(Jsons.f((String)"subjects", (JValue)Jsons.arr(this.splitSubjectIntoArray(event.getSubject()))));
        } else {
            fields.add(Jsons.f((String)"subjects", (JValue)Jsons.arr()));
        }
        fields.add(Jsons.f((String)"title", (JValue)Jsons.v((Object)event.getTitle(), (JValue)Jsons.BLANK)));
        if (withAcl != null && withAcl.booleanValue()) {
            AccessControlList acl = EventsEndpoint.getAclFromEvent(event);
            fields.add(Jsons.f((String)"acl", (JValue)Jsons.arr(AclUtils.serializeAclToJson(acl))));
        }
        if (withMetadata != null && withMetadata.booleanValue()) {
            try {
                Opt<MetadataList> metadata = this.getEventMetadata(event);
                if (metadata.isSome()) {
                    fields.add(Jsons.f((String)"metadata", (JValue)MetadataJson.listToJson((MetadataList)((MetadataList)metadata.get()), (boolean)true)));
                }
            }
            catch (Exception e) {
                logger.error("Unable to get metadata for event '{}'", (Object)event.getIdentifier(), (Object)e);
                throw new IndexServiceException("Unable to add metadata to event", (Throwable)e);
            }
        }
        if (withScheduling != null && withScheduling.booleanValue()) {
            fields.add(Jsons.f((String)"scheduling", (JValue)SchedulingUtils.SchedulingInfo.of(event.getIdentifier(), this.schedulerService).toJson()));
        }
        if (withPublications != null && withPublications.booleanValue()) {
            List<JValue> publications = this.getPublications(event, withSignedUrls, includeInternalPublication, requestedVersion);
            fields.add(Jsons.f((String)"publications", (JValue)Jsons.arr(publications)));
        }
        return Jsons.obj(fields);
    }

    private List<JValue> splitSubjectIntoArray(String subject) {
        return com.entwinemedia.fn.Stream.$((Object[])subject.split(",")).map((Fn)new Fn<String, JValue>(){

            public JValue apply(String a) {
                return Jsons.v((String)a.trim());
            }
        }).toList();
    }

    @GET
    @Path(value="{eventId}/acl")
    @RestQuery(name="geteventacl", description="Returns an event's access policy.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The access control list for the specified event is returned.", responseCode=200), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getEventAcl(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id) throws Exception {
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            AccessControlList acl = EventsEndpoint.getAclFromEvent(event);
            return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.arr(AclUtils.serializeAclToJson(acl)));
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @PUT
    @Path(value="{eventId}/acl")
    @RestQuery(name="updateeventacl", description="Update an event's access policy.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="acl", isRequired=true, description="Access policy", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The access control list for the specified event is updated.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response updateEventAcl(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @FormParam(value="acl") String acl) throws Exception {
        if (this.indexService.getEvent(id, this.elasticsearchIndex).isSome()) {
            AccessControlList accessControlList;
            try {
                accessControlList = AclUtils.deserializeJsonToAcl(acl, false);
            }
            catch (ParseException e) {
                logger.debug("Unable to update event acl to '{}'", (Object)acl, (Object)e);
                return RestUtil.R.badRequest((String)String.format("Unable to parse acl '%s' because '%s'", acl, e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                logger.debug("Unable to update event acl to '{}'", (Object)acl, (Object)e);
                return RestUtil.R.badRequest((String)e.getMessage());
            }
            try {
                accessControlList = this.indexService.updateEventAcl(id, accessControlList, this.elasticsearchIndex);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to update event '{}' acl with '{}'", new Object[]{id, acl, e});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.noContent().build();
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @POST
    @Path(value="{eventId}/acl/{action}")
    @RestQuery(name="addeventace", description="Grants permission to execute action on the specified event to any user with role role. Note that this is a convenience method to avoid having to build and post a complete access control list.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="action", description="The action that is allowed to be executed", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="role", isRequired=true, description="The role that is granted permission", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The permission has been created in the access control list of the specified event.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response addEventAce(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @PathParam(value="action") String action, @FormParam(value="role") String role) throws Exception {
        List<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            AccessControlList accessControlList = EventsEndpoint.getAclFromEvent(event);
            AccessControlEntry newAce = new AccessControlEntry(role, action, true);
            boolean alreadyInAcl = false;
            for (AccessControlEntry ace : accessControlList.getEntries()) {
                if (ace.equals((Object)newAce)) {
                    entries = accessControlList.getEntries();
                    alreadyInAcl = true;
                    break;
                }
                if (ace.getAction().equals(newAce.getAction()) && ace.getRole().equals(newAce.getRole()) && !ace.isAllow()) {
                    entries.add(newAce);
                    alreadyInAcl = true;
                    continue;
                }
                entries.add(ace);
            }
            if (!alreadyInAcl) {
                entries.add(newAce);
            }
            AccessControlList withNewAce = new AccessControlList(entries);
            try {
                withNewAce = this.indexService.updateEventAcl(id, withNewAce, this.elasticsearchIndex);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to update event '{}' acl entry with action '{}' and role '{}'", new Object[]{id, action, role, e});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.noContent().build();
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @DELETE
    @Path(value="{eventId}/acl/{action}/{role}")
    @RestQuery(name="deleteeventace", description="Revokes permission to execute action on the specified event from any user with role role.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="action", description="The action that is no longer allowed to be executed", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="role", description="The role that is no longer granted permission", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The permission has been revoked from the access control list of the specified event.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response deleteEventAce(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @PathParam(value="action") String action, @PathParam(value="role") String role) throws Exception {
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            AccessControlList accessControlList = EventsEndpoint.getAclFromEvent(event);
            boolean foundDelete = false;
            for (AccessControlEntry ace : accessControlList.getEntries()) {
                if (ace.getAction().equals(action) && ace.getRole().equals(role)) {
                    foundDelete = true;
                    continue;
                }
                entries.add(ace);
            }
            if (!foundDelete) {
                return ApiResponses.notFound("Unable to find an access control entry with action '%s' and role '%s'", action, role);
            }
            AccessControlList withoutDeleted = new AccessControlList(entries);
            try {
                withoutDeleted = this.indexService.updateEventAcl(id, withoutDeleted, this.elasticsearchIndex);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to delete event's '{}' acl entry with action '{}' and role '{}'", new Object[]{id, action, role, e});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.noContent().build();
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @GET
    @Path(value="{eventId}/metadata")
    @RestQuery(name="geteventmetadata", description="Returns the event's metadata of the specified type. For a metadata catalog there is the flavor such as 'dublincore/episode' and this is the unique type.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=false, description="The type of metadata to get", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The metadata collection is returned.", responseCode=200), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getAllEventMetadata(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @QueryParam(value="type") String type) throws Exception {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (StringUtils.trimToNull((String)type) == null) {
            Opt<MetadataList> metadataList = this.getEventMetadataById(id);
            if (metadataList.isSome()) {
                boolean withOrderedText;
                MetadataList actualList = (MetadataList)metadataList.get();
                DublinCoreMetadataCollection collection = actualList.getMetadataByFlavor("dublincore/episode");
                boolean bl = withOrderedText = collection == null;
                if (collection != null) {
                    this.convertStartDateTimeToApiV1(collection);
                }
                return ApiResponses.Json.ok(requestedVersion, MetadataJson.listToJson((MetadataList)actualList, (boolean)withOrderedText));
            }
            return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
        }
        return this.getEventMetadataByType(id, type, requestedVersion);
    }

    private void convertStartDateTimeToApiV1(DublinCoreMetadataCollection collection) throws java.text.ParseException {
        String pattern;
        if (!collection.getOutputFields().containsKey("startDate")) {
            return;
        }
        MetadataField oldStartDateField = (MetadataField)collection.getOutputFields().get("startDate");
        SimpleDateFormat sdf = MetadataField.getSimpleDateFormatter((String)oldStartDateField.getPattern());
        Date startDate = sdf.parse((String)oldStartDateField.getValue());
        if (this.configuredMetadataFields.containsKey("startDate")) {
            MetadataField startDateField = this.configuredMetadataFields.get("startDate");
            pattern = startDateField.getPattern() == null ? "yyyy-MM-dd" : startDateField.getPattern();
            startDateField = new MetadataField(startDateField);
            startDateField.setPattern(pattern);
            sdf.applyPattern(startDateField.getPattern());
            startDateField.setValue((Object)sdf.format(startDate));
            collection.removeField(oldStartDateField);
            collection.addField(startDateField);
        }
        if (this.configuredMetadataFields.containsKey("startTime")) {
            MetadataField startTimeField = this.configuredMetadataFields.get("startTime");
            pattern = startTimeField.getPattern() == null ? "HH:mm" : startTimeField.getPattern();
            startTimeField = new MetadataField(startTimeField);
            startTimeField.setPattern(pattern);
            sdf.applyPattern(startTimeField.getPattern());
            startTimeField.setValue((Object)sdf.format(startDate));
            collection.addField(startTimeField);
        }
    }

    protected Opt<MetadataList> getEventMetadataById(String id) throws IndexServiceException, Exception {
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            return this.getEventMetadata(event);
        }
        return Opt.none();
    }

    protected Opt<MetadataList> getEventMetadata(Event event) throws IndexServiceException, Exception {
        MetadataList metadataList = new MetadataList();
        List<EventCatalogUIAdapter> catalogUIAdapters = this.getEventCatalogUIAdapters();
        EventCatalogUIAdapter eventCatalogUIAdapter = this.indexService.getCommonEventCatalogUIAdapter();
        catalogUIAdapters.remove(eventCatalogUIAdapter);
        if (catalogUIAdapters.size() > 0) {
            MediaPackage mediaPackage = this.indexService.getEventMediapackage(event);
            for (EventCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
                DublinCoreMetadataCollection fields = catalogUIAdapter.getFields(mediaPackage);
                if (fields == null) continue;
                ExternalMetadataUtils.removeCollectionList(fields);
                metadataList.add(catalogUIAdapter, fields);
            }
        }
        DublinCoreMetadataCollection collection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUIAdapter, (ResourceListQuery)new EmptyResourceListQuery());
        ExternalMetadataUtils.changeSubjectToSubjects(collection);
        ExternalMetadataUtils.removeCollectionList(collection);
        metadataList.add(eventCatalogUIAdapter, collection);
        if (WorkflowInstance.WorkflowState.RUNNING.toString().equals(event.getWorkflowState())) {
            metadataList.setLocked(MetadataList.Locked.WORKFLOW_RUNNING);
        }
        return Opt.some((Object)metadataList);
    }

    private Opt<MediaPackageElementFlavor> getFlavor(String flavorString) {
        try {
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
            return Opt.some((Object)flavor);
        }
        catch (IllegalArgumentException e) {
            return Opt.none();
        }
    }

    private Response getEventMetadataByType(String id, String type, ApiVersion requestedVersion) throws Exception {
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            Opt<MediaPackageElementFlavor> flavor = this.getFlavor(type);
            if (flavor.isNone()) {
                return RestUtil.R.badRequest((String)String.format("Unable to parse type '%s' as a flavor so unable to find the matching catalog.", type));
            }
            EventCatalogUIAdapter eventCatalogUIAdapter = this.indexService.getCommonEventCatalogUIAdapter();
            if (((MediaPackageElementFlavor)flavor.get()).equals((Object)eventCatalogUIAdapter.getFlavor())) {
                DublinCoreMetadataCollection collection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUIAdapter, (ResourceListQuery)new EmptyResourceListQuery());
                ExternalMetadataUtils.changeSubjectToSubjects(collection);
                ExternalMetadataUtils.removeCollectionList(collection);
                this.convertStartDateTimeToApiV1(collection);
                return ApiResponses.Json.ok(requestedVersion, MetadataJson.collectionToJson((DublinCoreMetadataCollection)collection, (boolean)false));
            }
            List<EventCatalogUIAdapter> catalogUIAdapters = this.getEventCatalogUIAdapters();
            catalogUIAdapters.remove(eventCatalogUIAdapter);
            if (catalogUIAdapters.size() > 0) {
                MediaPackage mediaPackage = this.indexService.getEventMediapackage(event);
                for (EventCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
                    if (!((MediaPackageElementFlavor)flavor.get()).equals((Object)catalogUIAdapter.getFlavor())) continue;
                    DublinCoreMetadataCollection fields = catalogUIAdapter.getFields(mediaPackage);
                    ExternalMetadataUtils.removeCollectionList(fields);
                    this.convertStartDateTimeToApiV1(fields);
                    return ApiResponses.Json.ok(requestedVersion, MetadataJson.collectionToJson((DublinCoreMetadataCollection)fields, (boolean)false));
                }
            }
            return ApiResponses.notFound("Cannot find a catalog with type '%s' for event with id '%s'.", type, id);
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @PUT
    @Path(value="{eventId}/metadata")
    @RestQuery(name="updateeventmetadata", description="Update the metadata with the matching type of the specified event. For a metadata catalog there is the flavor such as 'dublincore/episode' and this is the unique type.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=true, description="The type of metadata to update", type=RestParameter.Type.STRING), @RestParameter(name="metadata", description="Metadata catalog in JSON format", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The metadata of the given namespace has been updated.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response updateEventMetadataByType(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @QueryParam(value="type") String type, @FormParam(value="metadata") String metadataJSON) throws Exception {
        Map updatedFields;
        JSONParser parser = new JSONParser();
        try {
            updatedFields = RequestUtils.getKeyValueMap((String)metadataJSON);
        }
        catch (ParseException e) {
            logger.debug("Unable to update event '{}' with metadata type '{}' and content '{}'", new Object[]{id, type, metadataJSON, e});
            return RestUtil.R.badRequest((String)String.format("Unable to parse metadata fields as json from '%s'", metadataJSON));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to update event '{}' with metadata type '{}' and content '{}'", new Object[]{id, type, metadataJSON, e});
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        if (updatedFields == null || updatedFields.size() == 0) {
            return RestUtil.R.badRequest((String)String.format("Unable to parse metadata fields as json from '%s' because there were no fields to update.", metadataJSON));
        }
        Opt<MediaPackageElementFlavor> flavor = this.getFlavor(type);
        if (flavor.isNone()) {
            return RestUtil.R.badRequest((String)String.format("Unable to parse type '%s' as a flavor so unable to find the matching catalog.", type));
        }
        DublinCoreMetadataCollection collection = null;
        EventCatalogUIAdapter adapter = null;
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            MetadataList metadataList = new MetadataList();
            EventCatalogUIAdapter eventCatalogUIAdapter = this.indexService.getCommonEventCatalogUIAdapter();
            if (((MediaPackageElementFlavor)flavor.get()).equals((Object)eventCatalogUIAdapter.getFlavor())) {
                collection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUIAdapter);
                adapter = eventCatalogUIAdapter;
            } else {
                metadataList.add(eventCatalogUIAdapter, EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)eventCatalogUIAdapter));
            }
            List<EventCatalogUIAdapter> catalogUIAdapters = this.getEventCatalogUIAdapters();
            catalogUIAdapters.remove(eventCatalogUIAdapter);
            if (catalogUIAdapters.size() > 0) {
                MediaPackage mediaPackage = this.indexService.getEventMediapackage(event);
                for (EventCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
                    if (((MediaPackageElementFlavor)flavor.get()).equals((Object)catalogUIAdapter.getFlavor())) {
                        collection = catalogUIAdapter.getFields(mediaPackage);
                        adapter = eventCatalogUIAdapter;
                        continue;
                    }
                    metadataList.add(catalogUIAdapter, catalogUIAdapter.getFields(mediaPackage));
                }
            }
            if (collection == null) {
                return ApiResponses.notFound("Cannot find a catalog with type '%s' for event with id '%s'.", type, id);
            }
            for (String key : updatedFields.keySet()) {
                DateTime updatedStartDate;
                DateTime newStartDate;
                DateTime oldStartDate;
                SimpleDateFormat sdf;
                SimpleDateFormat apiSdf;
                String apiPattern;
                Opt<Response> error;
                MetadataField field;
                if ("subjects".equals(key)) {
                    field = (MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_SUBJECT.getLocalName());
                    error = this.validateField(field, key, id, type, updatedFields);
                    if (error.isSome()) {
                        return (Response)error.get();
                    }
                    collection.removeField(field);
                    JSONArray subjectArray = (JSONArray)parser.parse((String)updatedFields.get(key));
                    collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)StringUtils.join((Iterator)subjectArray.iterator(), (String)",")));
                    continue;
                }
                if ("startDate".equals(key)) {
                    field = (MetadataField)collection.getOutputFields().get(key);
                    error = this.validateField(field, key, id, type, updatedFields);
                    if (error.isSome()) {
                        return (Response)error.get();
                    }
                    apiPattern = field.getPattern();
                    if (this.configuredMetadataFields.containsKey("startDate")) {
                        String startDate = this.configuredMetadataFields.get("startDate").getPattern();
                        apiPattern = startDate == null ? apiPattern : startDate;
                    }
                    apiSdf = MetadataField.getSimpleDateFormatter((String)apiPattern);
                    sdf = MetadataField.getSimpleDateFormatter((String)field.getPattern());
                    oldStartDate = new DateTime((Object)sdf.parse((String)field.getValue()), DateTimeZone.UTC);
                    newStartDate = new DateTime((Object)apiSdf.parse((String)updatedFields.get(key)), DateTimeZone.UTC);
                    updatedStartDate = oldStartDate.withDate(newStartDate.year().get(), newStartDate.monthOfYear().get(), newStartDate.dayOfMonth().get());
                    collection.removeField(field);
                    collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)sdf.format(updatedStartDate.toDate())));
                    continue;
                }
                if ("startTime".equals(key)) {
                    field = (MetadataField)collection.getOutputFields().get("startDate");
                    error = this.validateField(field, "startDate", id, type, updatedFields);
                    if (error.isSome()) {
                        return (Response)error.get();
                    }
                    apiPattern = "HH:mm";
                    if (this.configuredMetadataFields.containsKey("startTime")) {
                        String startTime = this.configuredMetadataFields.get("startTime").getPattern();
                        apiPattern = startTime == null ? apiPattern : startTime;
                    }
                    apiSdf = MetadataField.getSimpleDateFormatter((String)apiPattern);
                    sdf = MetadataField.getSimpleDateFormatter((String)field.getPattern());
                    oldStartDate = new DateTime((Object)sdf.parse((String)field.getValue()), DateTimeZone.UTC);
                    newStartDate = new DateTime((Object)apiSdf.parse((String)updatedFields.get(key)), DateTimeZone.UTC);
                    updatedStartDate = oldStartDate.withTime(newStartDate.hourOfDay().get(), newStartDate.minuteOfHour().get(), newStartDate.secondOfMinute().get(), newStartDate.millisOfSecond().get());
                    collection.removeField(field);
                    collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)sdf.format(updatedStartDate.toDate())));
                    continue;
                }
                field = (MetadataField)collection.getOutputFields().get(key);
                error = this.validateField(field, key, id, type, updatedFields);
                if (error.isSome()) {
                    return (Response)error.get();
                }
                collection.removeField(field);
                collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)((String)updatedFields.get(key))));
            }
            metadataList.add(adapter, collection);
            this.indexService.updateEventMetadata(id, metadataList, this.elasticsearchIndex);
            return Response.noContent().build();
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    private Opt<Response> validateField(MetadataField field, String key, String id, String type, Map<String, String> updatedFields) {
        if (field == null) {
            return Opt.some((Object)ApiResponses.notFound("Cannot find a metadata field with id '%s' from event with id '%s' and the metadata type '%s'.", key, id, type));
        }
        if (field.isRequired() && StringUtils.isBlank((CharSequence)updatedFields.get(key))) {
            return Opt.some((Object)RestUtil.R.badRequest((String)String.format("The event metadata field with id '%s' and the metadata type '%s' is required and can not be empty!.", key, type)));
        }
        return Opt.none();
    }

    @DELETE
    @Path(value="{eventId}/metadata")
    @RestQuery(name="deleteeventmetadata", description="Delete the metadata namespace catalog of the specified event. This will remove all fields and values of the catalog.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=true, description="The type of metadata to delete", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The metadata of the given namespace has been updated.", responseCode=204), @RestResponse(description="The main metadata catalog dublincore/episode cannot be deleted as it has mandatory fields.", responseCode=403), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response deleteEventMetadataByType(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @QueryParam(value="type") String type) throws SearchIndexException {
        Iterator iterator = this.indexService.getEvent(id, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            Opt<MediaPackageElementFlavor> flavor = this.getFlavor(type);
            if (flavor.isNone()) {
                return RestUtil.R.badRequest((String)String.format("Unable to parse type '%s' as a flavor so unable to find the matching catalog.", type));
            }
            EventCatalogUIAdapter eventCatalogUIAdapter = this.indexService.getCommonEventCatalogUIAdapter();
            if (((MediaPackageElementFlavor)flavor.get()).equals((Object)eventCatalogUIAdapter.getFlavor())) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Unable to delete mandatory metadata catalog with type '%s' for event '%s'", type, id)).build();
            }
            try {
                this.indexService.removeCatalogByFlavor(event, (MediaPackageElementFlavor)flavor.get());
            }
            catch (NotFoundException e) {
                return ApiResponses.notFound(e.getMessage(), new Object[0]);
            }
            catch (IndexServiceException e) {
                logger.error("Unable to remove metadata catalog with type '{}' from event '{}'", new Object[]{type, id, e});
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (IllegalStateException e) {
                logger.debug("Unable to remove metadata catalog with type '{}' from event '{}'", new Object[]{type, id, e});
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            catch (UnauthorizedException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.noContent().build();
        }
        return ApiResponses.notFound("Cannot find an event with id '%s'.", id);
    }

    @GET
    @Path(value="{eventId}/publications")
    @RestQuery(name="geteventpublications", description="Returns an event's list of publications.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="sign", description="Whether public distribution urls should be signed.", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="includeInternalPublication", description="Whether internal publications should be included.", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The list of publications is returned.", responseCode=200), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getEventPublications(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @QueryParam(value="sign") boolean sign, @QueryParam(value="includeInternalPublication") boolean includeInternalPublication) throws Exception {
        try {
            ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
            Opt event = this.indexService.getEvent(id, this.elasticsearchIndex);
            if (event.isSome()) {
                return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.arr(this.getPublications((Event)event.get(), sign, includeInternalPublication, requestedVersion)));
            }
            return ApiResponses.notFound(String.format("Unable to find event with id '%s'", id), new Object[0]);
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get list of publications from event with id '{}'", (Object)id, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private List<JValue> getPublications(Event event, Boolean withSignedUrls, Boolean includeInternalPublication, ApiVersion requestedVersion) {
        return event.getPublications().stream().filter(publication -> includeInternalPublication != null && includeInternalPublication != false && !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_11_0) || (Boolean)EventUtils.internalChannelFilter.apply(publication) != false).map(p -> this.getPublication((Publication)p, withSignedUrls, requestedVersion)).collect(Collectors.toList());
    }

    public JObject getPublication(Publication publication, Boolean sign, ApiVersion requestedVersion) {
        URI publicationUrl = publication.getURI();
        if (!requestedVersion.isSmallerThan(ApiVersion.VERSION_1_7_0)) {
            publicationUrl = this.getSignedUrl(publicationUrl, sign);
        }
        return Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)publication.getIdentifier())), Jsons.f((String)"channel", (JValue)Jsons.v((String)publication.getChannel())), Jsons.f((String)"mediatype", (JValue)Jsons.v((Object)publication.getMimeType(), (JValue)Jsons.BLANK)), Jsons.f((String)"url", (JValue)Jsons.v((Object)publicationUrl, (JValue)Jsons.BLANK)), Jsons.f((String)"media", (JValue)Jsons.arr(this.getPublicationTracksJson(publication, sign, requestedVersion))), Jsons.f((String)"attachments", (JValue)Jsons.arr(this.getPublicationAttachmentsJson(publication, sign))), Jsons.f((String)"metadata", (JValue)Jsons.arr(this.getPublicationCatalogsJson(publication, sign)))});
    }

    private URI getSignedUrl(URI url, boolean sign) {
        if (url == null || !sign) {
            return url;
        }
        if (this.urlSigningService.accepts(url.toString())) {
            try {
                return URI.create(this.urlSigningService.sign(url.toString(), Long.valueOf(expireSeconds), null, null));
            }
            catch (UrlSigningException e) {
                logger.error("Unable to sign URI {}", (Object)url, (Object)e);
            }
        }
        return url;
    }

    private List<JValue> getPublicationTracksJson(Publication publication, Boolean sign, ApiVersion requestedVersion) {
        ArrayList<JValue> tracks = new ArrayList<JValue>();
        for (Track track : publication.getTracks()) {
            VideoStream[] videoStreams = (VideoStream[])TrackSupport.byType((Stream[])track.getStreams(), VideoStream.class);
            ArrayList<Field> trackInfo = new ArrayList<Field>();
            if (videoStreams.length > 0) {
                VideoStream videoStream = videoStreams[0];
                if (videoStream.getBitRate() != null) {
                    trackInfo.add(Jsons.f((String)"bitrate", (JValue)Jsons.v((Number)videoStream.getBitRate())));
                }
                if (videoStream.getFrameRate() != null) {
                    trackInfo.add(Jsons.f((String)"framerate", (JValue)Jsons.v((Number)videoStream.getFrameRate())));
                }
                if (videoStream.getFrameCount() != null) {
                    trackInfo.add(Jsons.f((String)"framecount", (JValue)Jsons.v((Number)videoStream.getFrameCount())));
                }
                if (videoStream.getFrameWidth() != null) {
                    trackInfo.add(Jsons.f((String)"width", (JValue)Jsons.v((Number)videoStream.getFrameWidth())));
                }
                if (videoStream.getFrameHeight() != null) {
                    trackInfo.add(Jsons.f((String)"height", (JValue)Jsons.v((Number)videoStream.getFrameHeight())));
                }
            }
            if (!requestedVersion.isSmallerThan(ApiVersion.VERSION_1_7_0)) {
                trackInfo.add(Jsons.f((String)"is_master_playlist", (JValue)Jsons.v((Boolean)track.isMaster())));
                trackInfo.add(Jsons.f((String)"is_live", (JValue)Jsons.v((Boolean)track.isLive())));
            }
            tracks.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Object)track.getIdentifier(), (JValue)Jsons.BLANK)), Jsons.f((String)"mediatype", (JValue)Jsons.v((Object)track.getMimeType(), (JValue)Jsons.BLANK)), Jsons.f((String)"url", (JValue)Jsons.v((Object)this.getSignedUrl(track.getURI(), sign), (JValue)Jsons.BLANK)), Jsons.f((String)"flavor", (JValue)Jsons.v((Object)track.getFlavor(), (JValue)Jsons.BLANK)), Jsons.f((String)"size", (JValue)Jsons.v((Number)track.getSize())), Jsons.f((String)"checksum", (JValue)Jsons.v((Object)track.getChecksum(), (JValue)Jsons.BLANK)), Jsons.f((String)"tags", (JValue)Jsons.arr((String[])track.getTags())), Jsons.f((String)"has_audio", (JValue)Jsons.v((Boolean)track.hasAudio())), Jsons.f((String)"has_video", (JValue)Jsons.v((Boolean)track.hasVideo())), Jsons.f((String)"duration", (JValue)Jsons.v((Object)track.getDuration(), (JValue)Jsons.NULL)), Jsons.f((String)"description", (JValue)Jsons.v((Object)track.getDescription(), (JValue)Jsons.BLANK))}).merge(trackInfo));
        }
        return tracks;
    }

    private List<JValue> getPublicationAttachmentsJson(Publication publication, Boolean sign) {
        ArrayList<JValue> attachments = new ArrayList<JValue>();
        for (Attachment attachment : publication.getAttachments()) {
            attachments.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Object)attachment.getIdentifier(), (JValue)Jsons.BLANK)), Jsons.f((String)"mediatype", (JValue)Jsons.v((Object)attachment.getMimeType(), (JValue)Jsons.BLANK)), Jsons.f((String)"url", (JValue)Jsons.v((Object)this.getSignedUrl(attachment.getURI(), sign), (JValue)Jsons.BLANK)), Jsons.f((String)"flavor", (JValue)Jsons.v((Object)attachment.getFlavor(), (JValue)Jsons.BLANK)), Jsons.f((String)"ref", (JValue)Jsons.v((Object)attachment.getReference(), (JValue)Jsons.BLANK)), Jsons.f((String)"size", (JValue)Jsons.v((Number)attachment.getSize())), Jsons.f((String)"checksum", (JValue)Jsons.v((Object)attachment.getChecksum(), (JValue)Jsons.BLANK)), Jsons.f((String)"tags", (JValue)Jsons.arr((String[])attachment.getTags()))}));
        }
        return attachments;
    }

    private List<JValue> getPublicationCatalogsJson(Publication publication, Boolean sign) {
        ArrayList<JValue> catalogs = new ArrayList<JValue>();
        for (Catalog catalog : publication.getCatalogs()) {
            catalogs.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Object)catalog.getIdentifier(), (JValue)Jsons.BLANK)), Jsons.f((String)"mediatype", (JValue)Jsons.v((Object)catalog.getMimeType(), (JValue)Jsons.BLANK)), Jsons.f((String)"url", (JValue)Jsons.v((Object)this.getSignedUrl(catalog.getURI(), sign), (JValue)Jsons.BLANK)), Jsons.f((String)"flavor", (JValue)Jsons.v((Object)catalog.getFlavor(), (JValue)Jsons.BLANK)), Jsons.f((String)"size", (JValue)Jsons.v((Number)catalog.getSize())), Jsons.f((String)"checksum", (JValue)Jsons.v((Object)catalog.getChecksum(), (JValue)Jsons.BLANK)), Jsons.f((String)"tags", (JValue)Jsons.arr((String[])catalog.getTags()))}));
        }
        return catalogs;
    }

    @GET
    @Path(value="{eventId}/publications/{publicationId}")
    @RestQuery(name="geteventpublication", description="Returns a single publication.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="publicationId", description="The publication id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="sign", description="Whether public distribution urls should be signed.", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The track details are returned.", responseCode=200), @RestResponse(description="The specified event or publication does not exist.", responseCode=404)})
    public Response getEventPublication(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String eventId, @PathParam(value="publicationId") String publicationId, @QueryParam(value="sign") boolean sign) throws Exception {
        try {
            ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
            return ApiResponses.Json.ok(acceptHeader, (JValue)this.getPublication(eventId, publicationId, sign, requestedVersion));
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound(e.getMessage(), new Object[0]);
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get list of publications from event with id '{}'", (Object)eventId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private JObject getPublication(String eventId, String publicationId, Boolean withSignedUrls, ApiVersion requestedVersion) throws SearchIndexException, NotFoundException {
        Iterator iterator = this.indexService.getEvent(eventId, this.elasticsearchIndex).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            List publications = event.getPublications().stream().filter(publication -> !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_11_0) || (Boolean)EventUtils.internalChannelFilter.apply(publication) != false).collect(Collectors.toList());
            for (Publication publication2 : publications) {
                if (!publicationId.equals(publication2.getIdentifier())) continue;
                return this.getPublication(publication2, withSignedUrls, requestedVersion);
            }
            throw new NotFoundException(String.format("Unable to find publication with id '%s' in event with id '%s'", publicationId, eventId));
        }
        throw new NotFoundException(String.format("Unable to find event with id '%s'", eventId));
    }

    protected static AccessControlList getAclFromEvent(Event event) {
        AccessControlList activeAcl = new AccessControlList();
        try {
            if (event.getAccessPolicy() != null) {
                activeAcl = AccessControlParser.parseAcl((String)event.getAccessPolicy());
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse access policy", (Throwable)e);
        }
        return activeAcl;
    }

    private JValue getJsonStream(Stream stream) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (stream instanceof AudioStream) {
            AudioStream audioStream = (AudioStream)stream;
            if (audioStream.getBitDepth() != null) {
                fields.add(Jsons.f((String)"bitdepth", (JValue)Jsons.v((Number)audioStream.getBitDepth())));
            }
            if (audioStream.getBitRate() != null) {
                fields.add(Jsons.f((String)"bitrate", (JValue)Jsons.v((Number)audioStream.getBitRate())));
            }
            if (audioStream.getCaptureDevice() != null) {
                fields.add(Jsons.f((String)"capturedevice", (JValue)Jsons.v((String)audioStream.getCaptureDevice())));
            }
            if (audioStream.getCaptureDeviceVendor() != null) {
                fields.add(Jsons.f((String)"capturedevicevendor", (JValue)Jsons.v((String)audioStream.getCaptureDeviceVendor())));
            }
            if (audioStream.getCaptureDeviceVersion() != null) {
                fields.add(Jsons.f((String)"capturedeviceversion", (JValue)Jsons.v((String)audioStream.getCaptureDeviceVersion())));
            }
            if (audioStream.getChannels() != null) {
                fields.add(Jsons.f((String)"channels", (JValue)Jsons.v((Number)audioStream.getChannels())));
            }
            if (audioStream.getEncoderLibraryVendor() != null) {
                fields.add(Jsons.f((String)"encoderlibraryvendor", (JValue)Jsons.v((String)audioStream.getEncoderLibraryVendor())));
            }
            if (audioStream.getFormat() != null) {
                fields.add(Jsons.f((String)"format", (JValue)Jsons.v((String)audioStream.getFormat())));
            }
            if (audioStream.getFormatVersion() != null) {
                fields.add(Jsons.f((String)"formatversion", (JValue)Jsons.v((String)audioStream.getFormatVersion())));
            }
            if (audioStream.getFrameCount() != null) {
                fields.add(Jsons.f((String)"framecount", (JValue)Jsons.v((Number)audioStream.getFrameCount())));
            }
            if (audioStream.getIdentifier() != null) {
                fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((String)audioStream.getIdentifier())));
            }
            if (audioStream.getPkLevDb() != null) {
                fields.add(Jsons.f((String)"pklevdb", (JValue)Jsons.v((Number)audioStream.getPkLevDb())));
            }
            if (audioStream.getRmsLevDb() != null) {
                fields.add(Jsons.f((String)"rmslevdb", (JValue)Jsons.v((Number)audioStream.getRmsLevDb())));
            }
            if (audioStream.getRmsPkDb() != null) {
                fields.add(Jsons.f((String)"rmspkdb", (JValue)Jsons.v((Number)audioStream.getRmsPkDb())));
            }
            if (audioStream.getSamplingRate() != null) {
                fields.add(Jsons.f((String)"samplingrate", (JValue)Jsons.v((Number)audioStream.getSamplingRate())));
            }
        } else if (stream instanceof VideoStream) {
            VideoStream videoStream = (VideoStream)stream;
            if (videoStream.getBitRate() != null) {
                fields.add(Jsons.f((String)"bitrate", (JValue)Jsons.v((Number)videoStream.getBitRate())));
            }
            if (videoStream.getCaptureDevice() != null) {
                fields.add(Jsons.f((String)"capturedevice", (JValue)Jsons.v((String)videoStream.getCaptureDevice())));
            }
            if (videoStream.getCaptureDeviceVendor() != null) {
                fields.add(Jsons.f((String)"capturedevicevendor", (JValue)Jsons.v((String)videoStream.getCaptureDeviceVendor())));
            }
            if (videoStream.getCaptureDeviceVersion() != null) {
                fields.add(Jsons.f((String)"capturedeviceversion", (JValue)Jsons.v((String)videoStream.getCaptureDeviceVersion())));
            }
            if (videoStream.getEncoderLibraryVendor() != null) {
                fields.add(Jsons.f((String)"encoderlibraryvendor", (JValue)Jsons.v((String)videoStream.getEncoderLibraryVendor())));
            }
            if (videoStream.getFormat() != null) {
                fields.add(Jsons.f((String)"format", (JValue)Jsons.v((String)videoStream.getFormat())));
            }
            if (videoStream.getFormatVersion() != null) {
                fields.add(Jsons.f((String)"formatversion", (JValue)Jsons.v((String)videoStream.getFormatVersion())));
            }
            if (videoStream.getFrameCount() != null) {
                fields.add(Jsons.f((String)"framecount", (JValue)Jsons.v((Number)videoStream.getFrameCount())));
            }
            if (videoStream.getFrameHeight() != null) {
                fields.add(Jsons.f((String)"frameheight", (JValue)Jsons.v((Number)videoStream.getFrameHeight())));
            }
            if (videoStream.getFrameRate() != null) {
                fields.add(Jsons.f((String)"framerate", (JValue)Jsons.v((Number)videoStream.getFrameRate())));
            }
            if (videoStream.getFrameWidth() != null) {
                fields.add(Jsons.f((String)"framewidth", (JValue)Jsons.v((Number)videoStream.getFrameWidth())));
            }
            if (videoStream.getIdentifier() != null) {
                fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((String)videoStream.getIdentifier())));
            }
            if (videoStream.getScanOrder() != null) {
                fields.add(Jsons.f((String)"scanorder", (JValue)Jsons.v((String)videoStream.getScanOrder().toString())));
            }
            if (videoStream.getScanType() != null) {
                fields.add(Jsons.f((String)"scantype", (JValue)Jsons.v((String)videoStream.getScanType().toString())));
            }
        }
        return Jsons.obj(fields);
    }

    private String getEventUrl(String eventId) {
        return UrlSupport.concat((String)this.endpointBaseUrl, (String)eventId);
    }

    @GET
    @Path(value="{eventId}/scheduling")
    @Produces(value={"application/json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
    @RestQuery(name="geteventscheduling", description="Returns an event's scheduling information.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The scheduling information for the specified event is returned.", responseCode=200), @RestResponse(description="The specified event has no scheduling information.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response getEventScheduling(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id) throws Exception {
        try {
            Opt event = this.indexService.getEvent(id, this.elasticsearchIndex);
            if (event.isNone()) {
                return ApiResponses.notFound(String.format("Unable to find event with id '%s'", id), new Object[0]);
            }
            JObject scheduling = SchedulingUtils.SchedulingInfo.of(((Event)event.get()).getIdentifier(), this.schedulerService).toJson();
            if (!scheduling.isEmpty()) {
                return ApiResponses.Json.ok(acceptHeader, (JValue)scheduling);
            }
            return Response.noContent().build();
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get list of publications from event with id '{}'", (Object)id, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{eventId}/scheduling")
    @Produces(value={"application/json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
    @RestQuery(name="updateeventscheduling", description="Update an event's scheduling information.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="scheduling", isRequired=true, description="Scheduling Information", type=RestParameter.Type.STRING), @RestParameter(name="allowConflict", description="Allow conflicts when updating scheduling", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The  scheduling information for the specified event is updated.", responseCode=204), @RestResponse(description="The specified event has no scheduling information to update.", responseCode=406), @RestResponse(description="The scheduling information could not be updated due to a conflict.", responseCode=409), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response updateEventScheduling(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @FormParam(value="scheduling") String scheduling, @FormParam(value="allowConflict") @DefaultValue(value="false") boolean allowConflict) throws Exception {
        JSONObject parsedJson;
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        Opt event = this.indexService.getEvent(id, this.elasticsearchIndex);
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_2_0)) {
            allowConflict = false;
        }
        if (event.isNone()) {
            return ApiResponses.notFound(String.format("Unable to find event with id '%s'", id), new Object[0]);
        }
        JSONParser parser = new JSONParser();
        try {
            parsedJson = (JSONObject)parser.parse(scheduling);
        }
        catch (ParseException e) {
            logger.debug("Client sent unparsable scheduling information for event {}: {}", (Object)id, (Object)scheduling);
            return RestUtil.R.badRequest((String)"Unparsable scheduling information");
        }
        Optional<Response> clientError = this.updateSchedulingInformation(parsedJson, id, requestedVersion, allowConflict);
        return clientError.orElse(Response.noContent().build());
    }

    private Optional<Response> updateSchedulingInformation(JSONObject parsedScheduling, String id, ApiVersion requestedVersion, boolean allowConflict) throws Exception {
        SchedulingUtils.SchedulingInfo schedulingInfo;
        try {
            schedulingInfo = SchedulingUtils.SchedulingInfo.of(parsedScheduling);
        }
        catch (DateTimeParseException e) {
            logger.debug("Client sent unparsable start or end date for event {}", (Object)id);
            return Optional.of(RestUtil.R.badRequest((String)"Unparsable date in scheduling information"));
        }
        TechnicalMetadata technicalMetadata = this.schedulerService.getTechnicalMetadata(id);
        Opt caConfig = Opt.none();
        if (schedulingInfo.getInputs().isSome()) {
            HashMap<String, String> configMap = new HashMap<String, String>(technicalMetadata.getCaptureAgentConfiguration());
            configMap.put("capture.device.names", (String)schedulingInfo.getInputs().get());
            caConfig = Opt.some(configMap);
        }
        try {
            this.schedulerService.updateEvent(id, schedulingInfo.getStartDate(), schedulingInfo.getEndDate(), schedulingInfo.getAgentId(), Opt.none(), Opt.none(), Opt.none(), caConfig, allowConflict);
        }
        catch (SchedulerConflictException e) {
            List<MediaPackage> conflictingEvents = SchedulingUtils.getConflictingEvents(schedulingInfo.merge(technicalMetadata), this.agentStateService, this.schedulerService);
            logger.debug("Client tried to change scheduling information causing a conflict for event {}.", (Object)id);
            return Optional.of(ApiResponses.Json.conflict(requestedVersion, (JValue)Jsons.arr(SchedulingUtils.convertConflictingEvents(Optional.of(id), conflictingEvents, this.indexService, this.elasticsearchIndex))));
        }
        return Optional.empty();
    }

    @POST
    @Path(value="{eventId}/track")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="updateFlavorWithTrack", description="Update an events track for a given flavor", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="Flavor to add track to, e.g. captions/source", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="Comma separated list of tags for the given track, e.g. archive,publish. If a 'lang:LANG-CODE' tag exists and overwriteExisting=true only tracks with same lang tag and flavor will be replaced. This behavior is used for captions.", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="If true, all other tracks in the specified flavor are REMOVED. If tags argument contains a lang:LANG-CODE tag, only elements with same tag would be removed.", isRequired=true, name="overwriteExisting", type=RestParameter.Type.BOOLEAN), @RestParameter(description="The track file", isRequired=true, name="track", type=RestParameter.Type.FILE)}, responses={@RestResponse(description="The specified event does not exist.", responseCode=404), @RestResponse(description="The track has been added to the event.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response updateFlavorWithTrack(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id, @Context HttpServletRequest request) {
        logger.debug("updateFlavorWithTrack called");
        try {
            Opt event;
            boolean overwriteExisting = false;
            MediaPackageElementFlavor tmpFlavor = MediaPackageElementFlavor.parseFlavor((String)"addTrack/temporary");
            MediaPackageElementFlavor newFlavor = null;
            List<String> tags = null;
            String langTag = null;
            try {
                event = this.indexService.getEvent(id, this.elasticsearchIndex);
            }
            catch (SearchIndexException e) {
                return RestUtil.R.badRequest((String)String.format("Error while searching for event with id %s; %s", id, e.getMessage()));
            }
            if (event.isNone()) {
                return ApiResponses.notFound(String.format("Unable to find event with id '%s'", id), new Object[0]);
            }
            MediaPackage mp = this.indexService.getEventMediapackage((Event)event.get());
            try {
                if (this.workflowService.mediaPackageHasActiveWorkflows(mp.getIdentifier().toString())) {
                    return RestUtil.R.conflict((String)String.format("Cannot update while a workflow is running on event '%s'", id));
                }
            }
            catch (WorkflowDatabaseException e) {
                return RestUtil.R.serverError();
            }
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                throw new IllegalArgumentException("No multipart content");
            }
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            block10: while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    if ("flavor".equals(fieldName)) {
                        String flavorString = Streams.asString((InputStream)item.openStream());
                        try {
                            newFlavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            return RestUtil.R.badRequest((String)String.format("Could not parse flavor %s; %s", flavorString, e.getMessage()));
                        }
                    }
                    if ("tags".equals(fieldName)) {
                        String tagsString = Streams.asString((InputStream)item.openStream());
                        if (!StringUtils.isNotBlank((CharSequence)tagsString)) continue;
                        tags = List.of(StringUtils.split((String)tagsString, (char)','));
                        for (String tag : tags) {
                            if (!StringUtils.startsWith((CharSequence)StringUtils.trimToEmpty((String)tag), (CharSequence)"lang:")) continue;
                            langTag = StringUtils.trimToEmpty((String)tag);
                            continue block10;
                        }
                        continue;
                    }
                    if (!"overwriteExisting".equals(fieldName)) continue;
                    overwriteExisting = Boolean.parseBoolean(Streams.asString((InputStream)item.openStream()));
                    continue;
                }
                if (!"track".equals(item.getFieldName())) continue;
                mp = this.ingestService.addTrack(item.openStream(), item.getName(), tmpFlavor, mp);
            }
            if (overwriteExisting) {
                Track[] existing = mp.getTracks(newFlavor);
                for (int i = 0; i < existing.length; ++i) {
                    if (null != langTag && !existing[i].containsTag(langTag)) continue;
                    mp.remove(existing[i]);
                    logger.debug("Overwriting existing asset {} {}", (Object)tmpFlavor, (Object)newFlavor);
                }
            }
            for (Track track : mp.getTracks(tmpFlavor)) {
                track.setFlavor(newFlavor);
                if (null == tags) continue;
                for (String tag : tags) {
                    track.addTag(tag);
                }
            }
            logger.debug("Updated asset {} {}", (Object)tmpFlavor, newFlavor);
            try {
                this.assetManager.takeSnapshot(mp);
            }
            catch (AssetManagerException e) {
                logger.error("Error while adding the updated media package ({}) to the archive", (Object)mp.getIdentifier(), (Object)e);
                return RestUtil.R.badRequest((String)e.getMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (IOException | IllegalArgumentException | FileUploadException | IndexServiceException | IngestException | MediaPackageException e) {
            return RestUtil.R.badRequest((String)String.format("Could not add track: %s", e.getMessage()));
        }
    }

    private static enum CommentResolution {
        ALL,
        UNRESOLVED,
        RESOLVED;

    }
}

