/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.execute.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.execute.api.ExecuteException;
import org.opencastproject.execute.api.ExecuteService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.UnsupportedElementException;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ExecuteService.class, ManagedService.class}, property={"service.description=Execute Service", "service.pid=org.opencastproject.execute.impl.ExecuteServiceImpl"})
public class ExecuteServiceImpl
extends AbstractJobProducer
implements ExecuteService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteServiceImpl.class);
    private ServiceRegistry serviceRegistry = null;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected Workspace workspace;
    protected final Set<String> allowedCommands = new HashSet<String>();
    public static final String COMMANDS_ALLOWED_PROPERTY = "commands.allowed";
    private BundleContext bundleContext;
    private Dictionary properties = null;
    public static final float DEFAULT_EXECUTE_JOB_LOAD = 0.1f;
    public static final String EXECUTE_JOB_LOAD_KEY = "job.load.execute";
    private float executeJobLoad = 1.0f;

    public ExecuteServiceImpl() {
        super("org.opencastproject.execute");
    }

    @Activate
    public void activate(ComponentContext cc) {
        String commandString;
        super.activate(cc);
        this.properties = cc.getProperties();
        if (this.properties != null && StringUtils.isNotBlank((CharSequence)(commandString = (String)this.properties.get(COMMANDS_ALLOWED_PROPERTY)))) {
            logger.info("Execute Service permitted commands: {}", (Object)commandString);
            for (String command : commandString.split("\\s+")) {
                this.allowedCommands.add(command);
            }
        }
        this.bundleContext = cc.getBundleContext();
    }

    public Job execute(String exec, String params, MediaPackageElement inElement, String outFileName, MediaPackageElement.Type expectedType, float load) throws ExecuteException, IllegalArgumentException {
        logger.debug("Creating Execute Job for command: {}", (Object)exec);
        if (StringUtils.isBlank((CharSequence)exec)) {
            throw new IllegalArgumentException("The command to execute cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)params)) {
            throw new IllegalArgumentException("The command arguments cannot be null");
        }
        if (inElement == null) {
            throw new IllegalArgumentException("The input MediaPackage element cannot be null");
        }
        if ((outFileName = StringUtils.trimToNull((String)outFileName)) == null && expectedType != null || outFileName != null && expectedType == null) {
            throw new IllegalArgumentException("Expected element type and output filename cannot be null");
        }
        try {
            ArrayList<String> paramList = new ArrayList<String>(5);
            paramList.add(exec);
            paramList.add(params);
            paramList.add(MediaPackageElementParser.getAsXml((MediaPackageElement)inElement));
            paramList.add(outFileName);
            paramList.add(expectedType == null ? null : expectedType.toString());
            return this.serviceRegistry.createJob("org.opencastproject.execute", Operation.Execute_Element.toString(), paramList, Float.valueOf(load));
        }
        catch (ServiceRegistryException e) {
            throw new ExecuteException(String.format("Unable to create a job of type '%s'", "org.opencastproject.execute"), (Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new ExecuteException("Error serializing an element", (Throwable)e);
        }
    }

    public Job execute(String exec, String params, MediaPackage mp, String outFileName, MediaPackageElement.Type expectedType, float load) throws ExecuteException {
        if (StringUtils.isBlank((CharSequence)exec)) {
            throw new IllegalArgumentException("The command to execute cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)params)) {
            throw new IllegalArgumentException("The command arguments cannot be null");
        }
        if (mp == null) {
            throw new IllegalArgumentException("The input MediaPackage cannot be null");
        }
        if ((outFileName = StringUtils.trimToNull((String)outFileName)) == null && expectedType != null || outFileName != null && expectedType == null) {
            throw new IllegalArgumentException("Expected element type and output filename cannot be null");
        }
        try {
            ArrayList<String> paramList = new ArrayList<String>(5);
            paramList.add(exec);
            paramList.add(params);
            paramList.add(MediaPackageParser.getAsXml((MediaPackage)mp));
            paramList.add(outFileName);
            paramList.add(expectedType == null ? null : expectedType.toString());
            return this.serviceRegistry.createJob("org.opencastproject.execute", Operation.Execute_Mediapackage.toString(), paramList, Float.valueOf(load));
        }
        catch (ServiceRegistryException e) {
            throw new ExecuteException(String.format("Unable to create a job of type '%s'", "org.opencastproject.execute"), (Throwable)e);
        }
    }

    protected String process(Job job) throws ExecuteException {
        ArrayList<String> arguments = new ArrayList<String>(job.getArguments());
        if (!this.allowedCommands.contains("*") && !this.allowedCommands.contains(arguments.get(0))) {
            throw new ExecuteException("Command '" + (String)arguments.get(0) + "' is not allowed");
        }
        String outFileName = null;
        String strAux = null;
        MediaPackage mp = null;
        MediaPackageElement.Type expectedType = null;
        MediaPackageElement element = null;
        Operation op = null;
        try {
            op = Operation.valueOf(job.getOperation());
            int nargs = arguments.size();
            if (nargs != 3 && nargs != 5) {
                throw new IndexOutOfBoundsException("Incorrect number of parameters for operation execute_" + op + ": " + arguments.size());
            }
            if (nargs == 5) {
                strAux = (String)arguments.remove(4);
                expectedType = strAux == null ? null : MediaPackageElement.Type.valueOf((String)strAux);
                outFileName = StringUtils.trimToNull((String)((String)arguments.remove(3)));
                if (StringUtils.isNotBlank((CharSequence)outFileName) && expectedType == null || StringUtils.isBlank((CharSequence)outFileName) && expectedType != null) {
                    throw new ExecuteException("The output type and filename must be both specified");
                }
                outFileName = outFileName == null ? null : job.getId() + "_" + outFileName;
            }
            switch (op) {
                case Execute_Mediapackage: {
                    mp = MediaPackageParser.getFromXml((String)((String)arguments.remove(2)));
                    return this.doProcess(arguments, mp, outFileName, expectedType);
                }
                case Execute_Element: {
                    element = MediaPackageElementParser.getFromXml((String)((String)arguments.remove(2)));
                    return this.doProcess(arguments, element, outFileName, expectedType);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + job.getOperation() + "'");
        }
        catch (MediaPackageException e) {
            throw new ExecuteException("Error unmarshalling the input mediapackage/element", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("This service can't handle operations of type '" + op + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ExecuteException("The argument list for operation '" + op + "' does not meet expectations", (Throwable)e);
        }
    }

    protected String doProcess(List<String> arguments, MediaPackage mp, String outFileName, MediaPackageElement.Type expectedType) throws ExecuteException {
        String params = arguments.remove(1);
        File outFile = null;
        MediaPackageElement[] elements = null;
        try {
            if (outFileName != null) {
                File firstElement = this.workspace.get(mp.getElements()[0].getURI());
                outFile = new File(firstElement.getParentFile(), outFileName);
            }
            Pattern pat = Pattern.compile("#\\{([^\\{\\}\\(\\)]+)(?:\\(([^\\{\\}\\(\\)]+)\\))?\\}");
            Matcher matcher = pat.matcher(params);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                File elementFile;
                if (matcher.group(1).equals("id")) {
                    matcher.appendReplacement(sb, mp.getIdentifier().toString());
                    continue;
                }
                if (matcher.group(1).equals("flavor")) {
                    elements = mp.getElementsByFlavor(MediaPackageElementFlavor.parseFlavor((String)matcher.group(2)));
                    if (elements.length == 0) {
                        throw new ExecuteException("No elements in the MediaPackage match the flavor '" + matcher.group(2) + "'.");
                    }
                    if (elements.length > 1) {
                        logger.warn("Found more than one element with flavor '{}'. Using {} by default...", (Object)matcher.group(2), (Object)elements[0].getIdentifier());
                    }
                    elementFile = this.workspace.get(elements[0].getURI());
                    matcher.appendReplacement(sb, elementFile.getAbsolutePath());
                    continue;
                }
                if (matcher.group(1).equals("tags")) {
                    elements = mp.getElementsByTags(Arrays.asList(StringUtils.split((String)matcher.group(2), (String)",")));
                    if (elements.length == 0) {
                        throw new ExecuteException("No elements in the MediaPackage match the tags '" + matcher.group(2) + "'.");
                    }
                    if (elements.length > 1) {
                        logger.warn("Found more than one element with matching tags '{}'. Using {} by default...", (Object)matcher.group(2), (Object)elements[0].getIdentifier());
                    }
                    elementFile = this.workspace.get(elements[0].getURI());
                    matcher.appendReplacement(sb, elementFile.getAbsolutePath());
                    continue;
                }
                if (matcher.group(1).equals("out")) {
                    matcher.appendReplacement(sb, outFile.getAbsolutePath());
                    continue;
                }
                if (matcher.group(1).equals("org_id")) {
                    matcher.appendReplacement(sb, this.securityService.getOrganization().getId());
                    continue;
                }
                if (this.properties.get(matcher.group(1)) != null) {
                    matcher.appendReplacement(sb, (String)this.properties.get(matcher.group(1)));
                    continue;
                }
                if (this.bundleContext.getProperty(matcher.group(1)) == null) continue;
                matcher.appendReplacement(sb, this.bundleContext.getProperty(matcher.group(1)));
            }
            matcher.appendTail(sb);
            params = sb.toString();
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("Tag 'flavor' must specify a valid MediaPackage element flavor.", (Throwable)e);
        }
        catch (NotFoundException e) {
            throw new ExecuteException("The element '" + elements[0].getURI().toString() + "' does not exist in the workspace.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ExecuteException("Error retrieving MediaPackage element from workspace: '" + elements[0].getURI().toString() + "'.", (Throwable)e);
        }
        arguments.addAll(this.splitParameters(params));
        return this.runCommand(arguments, outFile, expectedType);
    }

    protected String doProcess(List<String> arguments, MediaPackageElement element, String outFileName, MediaPackageElement.Type expectedType) throws ExecuteException {
        String params = arguments.remove(1);
        arguments.addAll(this.splitParameters(params));
        File outFile = null;
        try {
            File trackFile = this.workspace.get(element.getURI());
            if (outFileName != null) {
                outFile = new File(trackFile.getParentFile(), outFileName);
            }
            for (int i = 1; i < arguments.size(); ++i) {
                if (arguments.get(i).contains("#{in}")) {
                    arguments.set(i, arguments.get(i).replace("#{in}", trackFile.getAbsolutePath()));
                    continue;
                }
                if (arguments.get(i).contains("#{out}")) {
                    if (outFile != null) {
                        arguments.set(i, arguments.get(i).replace("#{out}", outFile.getAbsolutePath()));
                        continue;
                    }
                    logger.error("{} pattern found, but no valid output filename was specified", (Object)"#{out}");
                    throw new ExecuteException("#{out} pattern found, but no valid output filename was specified");
                }
                if (arguments.get(i).contains("#{id}")) {
                    arguments.set(i, arguments.get(i).replace("#{id}", element.getMediaPackage().getIdentifier().toString()));
                }
                if (!arguments.get(i).contains("#{org_id}")) continue;
                arguments.set(i, arguments.get(i).replace("#{org_id}", this.securityService.getOrganization().getId()));
            }
            return this.runCommand(arguments, outFile, expectedType);
        }
        catch (IOException e) {
            logger.error("Error retrieving file from workspace: {}", (Object)element.getURI());
            throw new ExecuteException("Error retrieving file from workspace: " + element.getURI(), (Throwable)e);
        }
        catch (NotFoundException e) {
            logger.error("Element '{}' cannot be found in the workspace.", (Object)element.getURI());
            throw new ExecuteException("Element " + element.getURI() + " cannot be found in the workspace");
        }
    }

    /*
     * Unable to fully structure code
     */
    private String runCommand(List<String> command, File outFile, MediaPackageElement.Type expectedType) throws ExecuteException {
        block13: {
            block14: {
                p = null;
                result = 0;
                ExecuteServiceImpl.logger.info("Running command {}", (Object)command.get(0));
                ExecuteServiceImpl.logger.debug("Starting subprocess {} with arguments {}", (Object)command.get(0), (Object)StringUtils.join(command.subList(1, command.size()), (String)", "));
                pb = new ProcessBuilder(command);
                pb.redirectErrorStream(true);
                p = pb.start();
                stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = stdout.readLine()) != null) {
                    ExecuteServiceImpl.logger.debug(line);
                }
                result = p.waitFor();
                ExecuteServiceImpl.logger.debug("Command {} finished with result {}", (Object)command.get(0), (Object)result);
                if (result != 0) break block13;
                if (outFile == null) ** GOTO lbl31
                if (!outFile.isFile()) break block14;
                newURI = this.workspace.putInCollection("executor", outFile.getName(), (InputStream)new FileInputStream(outFile));
                if (outFile.delete()) {
                    ExecuteServiceImpl.logger.debug("Deleted the local copy of the encoded file at {}", (Object)outFile.getAbsolutePath());
                } else {
                    ExecuteServiceImpl.logger.warn("Unable to delete the encoding output at {}", (Object)outFile.getAbsolutePath());
                }
                var10_16 = MediaPackageElementParser.getAsXml((MediaPackageElement)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(newURI, expectedType, null));
                IoSupport.closeQuietly((Process)p);
                return var10_16;
            }
            throw new ExecuteException("Expected output file does not exist: " + outFile.getAbsolutePath());
lbl31:
            // 1 sources

            var9_15 = "";
            IoSupport.closeQuietly((Process)p);
            return var9_15;
        }
        try {
            try {
                throw new ExecuteException(String.format("Process %s returned error code %d", new Object[]{command.get(0), result}));
            }
            catch (InterruptedException e) {
                throw new ExecuteException("The executor thread has been unexpectedly interrupted", (Throwable)e);
            }
            catch (IOException e) {
                ExecuteServiceImpl.logger.error("Could not start subprocess {}", (Object)command.get(0));
                throw new ExecuteException("Could not start subprocess: " + command.get(0), (Throwable)e);
            }
            catch (UnsupportedElementException e) {
                throw new ExecuteException("Couldn't create a new MediaPackage element of type " + expectedType.toString(), (Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new ExecuteException("Couldn't instantiate a new MediaPackage element builder", (Throwable)e);
            }
            catch (MediaPackageException e) {
                throw new ExecuteException("Couldn't serialize a new Mediapackage element of type " + expectedType.toString(), (Throwable)e);
            }
        }
        catch (Throwable var11_17) {
            IoSupport.closeQuietly(p);
            throw var11_17;
        }
    }

    private List<String> splitParameters(String input) {
        String quoteDelim = "(?<!\\\\)\"";
        String spaceDelim = "((?<!\\\\)\\s)+";
        ArrayList<String> parsedInput = new ArrayList<String>();
        boolean quoted = false;
        for (String token1 : input.split("(?<!\\\\)\"")) {
            if (quoted) {
                parsedInput.add(token1);
                quoted = false;
                continue;
            }
            for (String token2 : token1.split("((?<!\\\\)\\s)+")) {
                if (token2.isEmpty()) continue;
                parsedInput.add(token2);
            }
            quoted = true;
        }
        return parsedInput;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void updated(Dictionary properties) throws org.osgi.service.cm.ConfigurationException {
        this.executeJobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)EXECUTE_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
    }

    public static enum Operation {
        Execute_Element,
        Execute_Mediapackage;

    }
}

