/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.search.MultiRangeQuery;

public class FloatPointMultiRangeBuilder
extends MultiRangeQuery.Builder {
    public FloatPointMultiRangeBuilder(String field, int numDims) {
        super(field, 4, numDims);
    }

    @Override
    public MultiRangeQuery build() {
        return new MultiRangeQuery(this.field, this.numDims, this.bytesPerDim, this.clauses){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Float.toString(FloatPoint.decodeDimension(value, 0));
            }
        };
    }

    public void add(float[] lowerValue, float[] upperValue) {
        if (upperValue.length != this.numDims || lowerValue.length != this.numDims) {
            throw new IllegalArgumentException("Passed in range does not conform to specified dimensions");
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (!(upperValue[i] < lowerValue[i])) continue;
            throw new IllegalArgumentException("Upper value of range should be greater than lower value of range");
        }
        this.add(FloatPoint.pack((float[])lowerValue).bytes, FloatPoint.pack((float[])upperValue).bytes);
    }
}

